// $Id: Arams.h,v 1.3 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    Arams.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef ARAMS_H
#define ARAMS_H

#include "JGManager.h"
#include "JGVariable.h"

#define TRIGGER_CLEAR_FAULT          _TX("CLEAR_FAULT")
#define TRIGGER_DETECT_FAULT         _TX("DETECT_FAULT")
#define TRIGGER_LIMIT                _TX("LIMIT")
#define TRIGGER_USER_SELECT          _TX("USER_SELECT")
#define TRIGGER_EXCEPTION            _TX("EXCEPTION")
#define TRIGGER_STANDBY              _TX("STANDBY")
#define TRIGGER_PRODUCTIVE           _TX("PRODUCTIVE")
#define TRIGGER_POWER_ON             _TX("POWER_ON")
#define TRIGGER_POWER_OFF            _TX("POWER_OFF")

// Forward declaration
class JGEquipment;

//-----------------------------------------------------------------------------
//
// ARAMS Object
//
//-----------------------------------------------------------------------------
class Arams : public JGManager
{
    friend class AramsState;
public:
    Arams();
    ~Arams() {}

    virtual int init(void * = 0);
    virtual BS2Message * msg_svc(JGTrigger * trigger, BS2Message * msg);
    virtual int update(JGState * current);

    void dump() const;

    //
    JGvalue& getARAMSAccumReset()   { return m_ARAMSAccumReset->getv(); }
    JGvalue& getARAMSInfo()         { return m_ARAMSInfo->getv(); }
    JGvalue& getARAMSState()        { return m_ARAMSState->getv(); }
    JGvalue& getARAMSText()         { return m_ARAMSText->getv(); }
    JGvalue& getARAMSTimestamp()    { return m_ARAMSTimestamp->getv(); }
    JGvalue& getDowntimeAlarm()     { return m_DowntimeAlarm->getv(); }
    JGvalue& getDowntimeAlarmText() { return m_DowntimeAlarmText->getv(); }
    JGvalue& getDowntimeData()      { return m_DowntimeData->getv(); }
    void  getClock(string& tmbuf);
    UINT  getCycleCtr();
    bool  getEngInterrupt()       { return m_EngInterrupt; }
    bool  getEngRecovery()        { return m_EngRecovery; }
    UINT  getEngTime() const      { return m_EngTime->getv().getUInt(); }
    const string& getEqpModel() const;
    const string& getSerialNum() const;
    UINT  getInterruptionPrd()    { return m_InterruptionPrd; }
    UINT  getInterruptionTotal()  { return m_InterruptionTotal; }
    JGvalue& getLastPowerdown()  { return m_LastPowerdown->getv(); }
    JGvalue& getPowerdownTime()  { return m_PowerdownTime->getv(); }
    JGvalue& getPowerupState()   { return m_PowerupState->getv(); }
    JGvalue& getPrdState()       { return m_PrdState->getv(); }
    JGvalue& getPrevARAMSState() { return m_PrevARAMSState->getv(); }
    JGvalue& getSymptomID()      { return m_SymptomID->getv(); }
    JGvalue& getSymptomText()    { return m_SymptomText->getv(); }
    bool  getPrdRecovery()    { return m_PrdRecovery->getv().getBool(); }
    bool  getSubstateSelect() { return m_SubstateSelect; }
    bool  getSbyRecovery()    { return m_SbyRecovery->getv().getBool(); }
    UINT  getNSTime()  { return m_NSTime->getv().getUInt(); }
    UINT  getPrdTime() { return m_PrdTime->getv().getUInt(); }
    UINT  getSDTime()  { return m_SDTime->getv().getUInt(); }
    UINT  getSbyTime() { return m_SbyTime->getv().getUInt(); }
    UINT  getUDTime()  { return m_UDTime->getv().getUInt(); }

    //
    void setEngInterrupt(bool flag) { m_EngInterrupt = flag; }
    void setEngRecovery(bool flag)  { m_EngRecovery = flag; }
    void setEngTime(UINT time)      { JGvalue val(time); m_EngTime->setv(val); }
    void setInterruptionPrd(UINT count)   { m_InterruptionPrd = count; }
    void setInterruptionTotal(UINT count) { m_InterruptionTotal = count; }
    void setNSTime(UINT time)             {
            JGvalue val(time); m_NSTime->setv(val);
        }
    void setPowerupState(const TCHAR * state) {
            JGvalue val(state); m_PowerupState->setv(val);
        }
    void setPrdRecovery(bool flag) {
            JGvalue val(flag); m_PrdRecovery->setv(val);
        }
    void setPrdTime(UINT time) {
            JGvalue val(time); m_PrdTime->setv(val);
        }
    void setSDTime(UINT time) { JGvalue val(time); m_SDTime->setv(val); }
    void setSbyRecovery(bool flag) {
            JGvalue val(flag); m_SbyRecovery->setv(val);
        }
    void setSubstateSelect(bool flag) { m_SubstateSelect = flag; }
    void setSbyTime(UINT time) { JGvalue val(time); m_SbyTime->setv(val); }
    void setUDTime(UINT time)  { JGvalue val(time); m_UDTime->setv(val); }

    static Arams * instance();

//
protected:
    string m_mdln;
    string m_serial;
    bool   m_EngInterrupt;
    bool   m_EngRecovery;
    UINT   m_InterruptionPrd;
    UINT   m_InterruptionTotal;
    bool   m_SubstateSelect;

    JGVariable * m_ARAMSAccumReset;    // string
    JGVariable * m_ARAMSInfo;          // string
    JGVariable * m_ARAMSState;         // string
    JGVariable * m_ARAMSText;          // string
    JGVariable * m_ARAMSTimestamp;     // string
    JGVariable * m_DowntimeAlarm;      // string
    JGVariable * m_DowntimeAlarmText;  // string
    JGVariable * m_DowntimeData;       // string
    JGVariable * m_EngTime;            // u_int
    JGVariable * m_InterruptionCtr;    // u_int
    JGVariable * m_LastPowerdown;      // string
    JGVariable * m_NSTime;             // u_int
    JGVariable * m_PowerdownTime;      // string
    JGVariable * m_PowerupState;       // string
    JGVariable * m_PrdRecovery;        // bool
    JGVariable * m_PrdState;           // string
    JGVariable * m_PrdTime;            // u_int
    JGVariable * m_PrevARAMSState;     // string
    JGVariable * m_SbyRecovery;        // bool
    JGVariable * m_SbyTime;            // u_int
    JGVariable * m_SDTime;             // u_int
    JGVariable * m_SymptomID;          // string
    JGVariable * m_SymptomText;        // string
    JGVariable * m_UDTime;             // u_int

    AramsState * m_aramsState;         // State Model
};


#endif
