// $Id: DBEventElm.h,v 1.4 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBEventElm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef DBEVENTELM_H
#define DBEVENTELM_H

#include "dbio.h"
#include "JGEvent.h"
#include "JGReport.h"

class JGEquipment;

// Define an object to hold configure data
class DBEventElm : public JGEvent
{
public:
    DBEventElm() : JGEvent() { }
    DBEventElm(const JGEvent& rhs) : JGEvent(rhs) { }
    DBEventElm& operator=(const JGEvent& rhs) {
            if (this == &rhs) return *this;
            *((JGEvent *)this) = rhs;
            return *this;
        }
    friend class dtl::DefaultBCA<DBEventElm>;
    friend class dtl::DefaultInsValidate<DBEventElm>;
    friend class dtl::DefaultSelValidate<DBEventElm>;
    friend class UPDEventElm;

    friend bool operator<(const DBEventElm &val1, const DBEventElm &val2)
    {
        return (val1.m_id < val2.m_id);
    }

    static void load(JGEquipment * equip);
    static void save(JGEquipment * equip);
    static int  update(JGEquipment * equip, JGid& vid);
    int formdb();

protected:
    string m_ceidStr;
    string m_enabledStr;

};

//
// Define an object to hold configure data
//
class DBEvtReportElm : public JGEvtReport
{
public:
    DBEvtReportElm() : JGEvtReport() { }
    DBEvtReportElm(const JGEvtReport& rhs) : JGEvtReport(rhs) { }
    DBEvtReportElm& operator=(const JGEvtReport& rhs) {
            if (this == &rhs) return *this;
            *((JGEvtReport *)this) = rhs;
            return *this;
        }
    friend class dtl::DefaultBCA<DBEvtReportElm>;
    friend class dtl::DefaultInsValidate<DBEvtReportElm>;
    friend class dtl::DefaultSelValidate<DBEvtReportElm>;

    friend bool operator<(const DBEvtReportElm &val1,
                          const DBEvtReportElm &val2)
    {
        return (val1.m_ceid < val2.m_ceid);
    }

    static void load(JGEquipment * equip);
    static void save(JGEquipment * equip);

protected:
    string m_ceidStr;
    string m_rptidStr;

};

// Updata element
class UPDEventElm
{
public:
    void operator()(BoundIOs &boundIOs, DBEventElm &rowbuf)
    {
        boundIOs[_TX("ENABLED")] == rowbuf.m_enabledStr;
    }
};


// Create an association between table columns and fields in our object
// Here, BoundIOs is a class that is passed in to store column names &
// mappings

BEGIN_DTL_NAMESPACE

template<> class DefaultBCA<DBEventElm>
{
public:
    void operator()(BoundIOs &cols, DBEventElm &row)
    {
        cols[_TX("CEID")] == row.m_ceidStr;
        cols[_TX("CENAME")] == row.m_name;
        cols[_TX("ENABLED")] == row.m_enabledStr;
        cols[_TX("CATEGORY")] == row.m_category;
        cols[_TX("EVT_ACTION")] == row.m_action;
    }
};

// Specialization of DefaultInsValidate for DBEventElm
// This defines a business rule we wish to enforce for all
// DBEventElm objects before they are allowed to be inserted into the database
template<> class DefaultInsValidate<DBEventElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBEventElm &rowbuf) {
        // data is valid if rowbuf.m_ceid is nonempty and
        // rowbuf.m_cename is nonempty
        return (!rowbuf.m_id.isNil() && rowbuf.m_name.length() > 0);
    }
};

template<> class DefaultSelValidate<DBEventElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBEventElm &rowbuf) {
        return true;
    }
};

// Parameter for update
template<> class DefaultParamObj<DBEventElm>
{
public:
    string m_ceidStr;
};

template<> class DefaultBPA<DefaultParamObj<DBEventElm> >
{
public:
    void operator()(BoundIOs &boundIOs, DefaultParamObj<DBEventElm> &paramObj)
    {
      boundIOs[0] == paramObj.m_ceidStr;
    }
};

//
// Event-Report Element
//
template<> class DefaultBCA<DBEvtReportElm>
{
public:
    void operator()(BoundIOs &cols, DBEvtReportElm &row)
    {
        cols[_TX("CEID")] == row.m_ceidStr;
        cols[_TX("RPTID")] == row.m_rptidStr;
        cols[_TX("SEQ_NUM")] == row.m_seqnum;
    }
};

// Specialization of DefaultInsValidate for DBEvtReportElm
// This defines a business rule we wish to enforce for all
// DBEvtReportElm objects before they are allowed to be inserted
// into the database
template<> class DefaultInsValidate<DBEvtReportElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBEvtReportElm &rowbuf) {
        // data is valid if rowbuf.m_ceid is nonempty and
        // rowbuf.m_rptid is nonempty
        return (!rowbuf.m_ceid.isNil() && !rowbuf.m_rptid.isNil());
    }
};

template<> class DefaultSelValidate<DBEvtReportElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBEvtReportElm &rowbuf) {
        return true;
    }
};



END_DTL_NAMESPACE


#endif  /* DBEVENTELM_H */
