// $Id: DBIODeviceElm.h,v 1.6 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBIODeviceElm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================


#ifndef DBIODEVICEELM_H
#define DBIODEVICEELM_H

#include "dbio.h"
#include "sac/JGIODevice.h"


class JGEquipment;

 // Define an object to hold our row data -- used by all single table examples
class DBIODeviceElm : public JGIODevice
{
public:
    DBIODeviceElm() : JGIODevice() {}

    friend class dtl::DefaultBCA<DBIODeviceElm>;
    friend class dtl::DefaultInsValidate<DBIODeviceElm>;
    friend class dtl::DefaultSelValidate<DBIODeviceElm>;

    friend bool operator<(const DBIODeviceElm &io1, const DBIODeviceElm &io2)
    {
        return (io1.devid() < io2.devid());
    }

    static void load(JGEquipment * equip);

protected:
    string m_devidStr;
    string m_sysidStr;
    string m_valueStr;
    string m_maxvalStr;
    string m_minvalStr;
    string m_deltavalStr;
    string m_timeEnableStr;
    string m_addressStr;
    string m_access_time;
    string m_interval_time;
    string m_resetStr;
    string m_enabledStr;
};

// Create an association between table columns and fields in our object
// Here, BoundIOs is a class that is passed in to store column names &
// mappings

BEGIN_DTL_NAMESPACE

template<> class DefaultBCA<DBIODeviceElm>
{
public:
    void operator()(BoundIOs &cols, DBIODeviceElm &row)
    {
        cols[_TX("IODEV_ID")] == row.m_devidStr;
        cols[_TX("IODEV_NAME")] == row.m_name;
        cols[_TX("SUBSYS_ID")] == row.m_sysidStr;
        cols[_TX("IODEV_TYPE")] == row.m_devtype;
        cols[_TX("IODATA_TYPE")] == row.m_datatype;
        cols[_TX("FORMAT")] == row.m_format;
        cols[_TX("DATANUM")] == row.m_dataq;
        cols[_TX("INTERVAL_TIME")] == row.m_interval_time;
        cols[_TX("VALUE")] == row.m_valueStr;
        cols[_TX("TIME_ENABLED")] == row.m_timeEnableStr;
        cols[_TX("ACCESS_TIME")] == row.m_access_time;
        cols[_TX("INTERLOCK")] == row.m_interlock;
        cols[_TX("MAX_VAL")] == row.m_maxvalStr;
        cols[_TX("MIN_VAL")] == row.m_minvalStr;
        cols[_TX("DIMENSION")] == row.m_dimension;
        cols[_TX("DELTA_VAL")] == row.m_deltavalStr;
        cols[_TX("ADDRESS")] == row.m_addressStr;
        cols[_TX("ALGORITHM_ID")] == row.m_algorithm;
        cols[_TX("RESET")] == row.m_resetStr;
        cols[_TX("ENABLED")] == row.m_enabledStr;
    }
};

// Specialization of DefaultInsValidate for DBIODeviceElm
// This defines a business rule we wish to enforce for all
// DBIODeviceElm objects before they are allowed to be inserted into
// the database
template<> class DefaultInsValidate<DBIODeviceElm>
{
public:
    bool operator()(BoundIOs &boundIOs, DBIODeviceElm &rowbuf) {
        // data is valid if rowbuf.m_vid is nonempty and
        // rowbuf.n_name is nonempty and rowbuf.n_valtype is
        // between 0 and 3 (v, sv, ec, dvval)
        //return (rowbuf.m_devidStr.length() > 0 && rowbuf.m_name.length() > 0 &&
        //        rowbuf.m_devtype >= 1 && rowbuf.m_devtype  <= 65535);
        return true;
    }
};

template<> class DefaultSelValidate<DBIODeviceElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBIODeviceElm &rowbuf) {
        return true;
    }
};


END_DTL_NAMESPACE

#endif  /* DBIODEVICEELM_H */
