// $Id: DBLimitElm.h,v 1.3 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBLimitElm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef DBLIMITELM_H
#define DBLIMITELM_H

#include "dbio.h"
#include "JGLimit.h"

class JGEquipment;

//
// Define an object to hold trace data
//
class DBLimitElm : public JGLimit
{
public:
    DBLimitElm() : JGLimit() { }

    friend class dtl::DefaultBCA<DBLimitElm>;
    friend class dtl::DefaultInsValidate<DBLimitElm>;
    friend class dtl::DefaultSelValidate<DBLimitElm>;

    friend bool operator<(const DBLimitElm &val1, const DBLimitElm &val2)
    {
        return (val1.m_vidStr < val2.m_vidStr);
    }

    static void load(JGEquipment * equip);

protected:
    string m_vidStr;
    string m_ceidStr;
    string m_enabledStr;
    string m_maxstr;
    string m_minstr;
};

//
// Define an object to hold trace variable data
//
class DBLimitBorderElm : public JGLimitBorder
{
public:
    DBLimitBorderElm() : JGLimitBorder() { }

    friend class dtl::DefaultBCA<DBLimitBorderElm>;
    friend class dtl::DefaultInsValidate<DBLimitBorderElm>;
    friend class dtl::DefaultSelValidate<DBLimitBorderElm>;

    friend bool operator<(const DBLimitBorderElm &val1,
                          const DBLimitBorderElm &val2)
    {
        return (val1.m_vidStr < val2.m_vidStr);
    }

    static void load(JGEquipment * equip);

protected:
    string m_vidStr;
    string m_enabledStr;
    string m_upperdb;
    string m_lowerdb;
};


// Create an association between table columns and fields in our object
// Here, BoundIOs is a class that is passed in to store column names &
// mappings

BEGIN_DTL_NAMESPACE

template<> class DefaultBCA<DBLimitElm>
{
public:
    void operator()(BoundIOs &cols, DBLimitElm &row)
    {
        cols[_TX("VID")] == row.m_vidStr;
        cols[_TX("CEID")] == row.m_ceidStr;
        cols[_TX("UNIT")] == row.m_unit;
        cols[_TX("MAX_VAL")] == row.m_maxstr;
        cols[_TX("MIN_VAL")] == row.m_minstr;
        cols[_TX("LIMITID")] == row.m_limitid;
        cols[_TX("TRANSITION")] == row.m_transition;
        cols[_TX("ENABLED")] == row.m_enabledStr;
    }
};

// Specialization of DefaultInsValidate for DBLimitElm
// This defines a business rule we wish to enforce for all
// DBLimitElm objects before they are allowed to be inserted into the database
template<> class DefaultInsValidate<DBLimitElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBLimitElm &rowbuf) {
        // data is valid if rowbuf.m_vid is nonempty and
        // rowbuf.m_ceid is nonempty
        return (rowbuf.m_vidStr.length() > 0 && rowbuf.m_ceidStr.length() > 0);
    }
};

template<> class DefaultSelValidate<DBLimitElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBLimitElm &rowbuf) {
        return true;
    }
};

//
// Trace variable
//
template<> class DefaultBCA<DBLimitBorderElm>
{
public:
    void operator()(BoundIOs &cols, DBLimitBorderElm &row)
    {
        cols[_TX("VID")] == row.m_vidStr;
        cols[_TX("LIMITID")] == row.m_limid;
        cols[_TX("LOWERDB")] == row.m_lowerdb;
        cols[_TX("UPPERDB")] == row.m_upperdb;
        cols[_TX("ENABLED")] == row.m_enabledStr;
    }
};

// Specialization of DefaultInsValidate for DBLimitBorderElm
// This defines a business rule we wish to enforce for all
// DBLimitBorderElm objects before they are allowed to be inserted into
// the database
template<> class DefaultInsValidate<DBLimitBorderElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBLimitBorderElm &rowbuf) {
        // data is valid if rowbuf.m_rptid is nonempty and
        // rowbuf.m_vid is nonempty
        return (rowbuf.m_vidStr.length() > 0 && rowbuf.m_lowerdb.length() > 0 &&
                rowbuf.m_upperdb.length() > 0);
    }
};

template<> class DefaultSelValidate<DBLimitBorderElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBLimitBorderElm &rowbuf) {
        return true;
    }
};


END_DTL_NAMESPACE

#endif  /* DBLIMITELM_H */
