// $Id: DBSubSystemElm.cpp,v 1.5 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBSubSystemElm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "JGResourceManager.h"
#include "dbio/DBVariableElm.h"
#include "dbio/DBSubSystemElm.h"
#ifdef GEM300
#include "JGLoadPort.h"
#undef   TRIGGER_CANCEL     // Definition duplicate JGLoadPort and ProcChamber
#include "JGProcChamber.h"
#endif

extern int setSystemFunction(JGVariable * var);
extern int setLibFunction(JGVariable * var);

//-----------------------------------------------------------------------------
//
void DBSubSystemElm::load(JGEquipment * equip)
{
    JGResourceManager * rsmngr =
                    (JGResourceManager *)equip->findManager(CATEGORY_RESOURCE);
    JGSubSystemTable * subsystem = rsmngr->subSystem();
    DBView<DBSubSystemElm> view(_TX("G_SUBSYSTEM"));

    DBView<DBSubSystemElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBSubSystemElm * subsys_elm = (DBSubSystemElm *)(&(*read_it));
        JGid subid = subsys_elm->m_subidStr;
        subsys_elm->subsysid(subid);
        u_int ui = _tcstoul(subsys_elm->m_locidStr.c_str(), NULL, 0);
        JGid locid(ui);
        subsys_elm->locid(locid);
        JGSubSystem * subptr;
        //
        // Set Object
        //
        if (subsys_elm->m_subtypeStr == _TX("LoadPort"))
        {
            subsys_elm->subSystemType(JGSubSystem::LOADPORT);
#ifdef GEM300
            subptr = new JGLoadPort;
            subptr->set(*subsys_elm);
#else
            subptr = new JGSubSystem(*subsys_elm);
#endif
        }
        else if (subsys_elm->m_subtypeStr == _TX("LoadLock"))
        {
            subsys_elm->subSystemType(JGSubSystem::LOADLOCK);
            subptr = new JGSubSystem(*subsys_elm);
        }
        else if (subsys_elm->m_subtypeStr == _TX("Process"))
        {
            subsys_elm->subSystemType(JGSubSystem::PROCESS);
#ifdef GEM300
            subptr = new JGProcChamber;
            subptr->set(*subsys_elm);
#else
            subptr = new JGSubSystem(*subsys_elm);
#endif
        }
        else if (subsys_elm->m_subtypeStr == _TX("Transfer"))
        {
            subsys_elm->subSystemType(JGSubSystem::TRANSFER);
            subptr = new JGSubSystem(*subsys_elm);
        }
        else if (subsys_elm->m_subtypeStr == _TX("Aligner"))
        {
            subsys_elm->subSystemType(JGSubSystem::ALIGNER);
            subptr = new JGSubSystem(*subsys_elm);
        }
        else
        {
            subsys_elm->subSystemType(JGSubSystem::UNKNOWN);
            subptr = new JGSubSystem(*subsys_elm);
        }

        subsystem->insert(JGSubSystemPair(subsys_elm->subsysid(), subptr));
    }

    return ;
}

