// $Id: DBTraceElm.cpp,v 1.3 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBTraceElm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "JGTraceManager.h"
#include "dbio/DBTraceElm.h"

//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBTraceElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBTraceElm::load");

    JGTraceManager * traceManager =
                        (JGTraceManager *)equip->findManager(CATEGORY_TRACE);
    JGTraceTable * trace_tbl = traceManager->keepTable();
    DBView<DBTraceElm> view(_TX("G_TRACES"));

    DBView<DBTraceElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBTraceElm * trace_elm = (DBTraceElm *)(&(*read_it));
        JGid id(trace_elm->m_tridStr);
        trace_elm->trid(id);
        trace_elm->manager(traceManager);
        trace_tbl->insert(JGTracePair(id, *read_it));
    }

    return ;
}

//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBTraceVarElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBTraceVarElm::load");

    JGInfoManager * infoManager =
                        (JGInfoManager *)equip->findManager(CATEGORY_INFO);
    JGTraceManager * traceManager =
                        (JGTraceManager *)equip->findManager(CATEGORY_TRACE);
    JGTraceTable * trace_tbl = traceManager->keepTable();
    JGVarNameTable * var_tbl = infoManager->nameTable();

    DBView<DBTraceVarElm> view(_TX("G_TRACE_VARS"));

    // Convert ASCII data.
    DBView<DBTraceVarElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBTraceVarElm trace_var = (*read_it);
        JGid trid(trace_var.m_trid);           // Convert trid
        JGTraceTable::iterator trace_it = trace_tbl->find(trid);
        JGVarNameTable::iterator var_it = var_tbl->find(trace_var.m_vid);
        if (trace_it != trace_tbl->end() && var_it != var_tbl->end())
        {   // append variable
            JGTrace * trace = &((*trace_it).second);
            JGVariable * var = (*var_it).second;
            trace->insert(var);
        }
        else
        {
            TRACE_ERROR((_TX("Unliked variable %s %s\n"),
                         trace_var.m_trid.c_str(), trace_var.m_vid.c_str()));
        }
    }
    return ;
}

