// $Id: DBTraceElm.h,v 1.3 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBTraceElm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef DBTRACEELM_H
#define DBTRACEELM_H

#include "dbio.h"
#include "JGTrace.h"

class JGEquipment;

//
// Define an object to hold trace data
//
class DBTraceElm : public JGTrace
{
public:
    DBTraceElm() : JGTrace() { }

    friend class dtl::DefaultBCA<DBTraceElm>;
    friend class dtl::DefaultInsValidate<DBTraceElm>;
    friend class dtl::DefaultSelValidate<DBTraceElm>;

    friend bool operator<(const DBTraceElm &val1, const DBTraceElm &val2)
    {
        return (val1.m_tridStr < val2.m_tridStr);
    }

    static void load(JGEquipment * equip);

protected:
    string m_tridStr;
};

//
// Define an object to hold trace variable data
//
class DBTraceVarElm
{
    string m_trid;
    string m_vid;
    int    m_seqnum;

public:
    DBTraceVarElm() : m_trid(_TX("")), m_vid(_TX("")), m_seqnum(0) { }
    DBTraceVarElm(string& trid, string& vid, int seqnum)
        : m_trid(trid), m_vid(vid), m_seqnum(seqnum) { }

    friend class dtl::DefaultBCA<DBTraceVarElm>;
    friend class dtl::DefaultInsValidate<DBTraceVarElm>;
    friend class dtl::DefaultSelValidate<DBTraceVarElm>;

    friend bool operator<(const DBTraceVarElm &val1, const DBTraceVarElm &val2)
    {
        return (val1.m_trid < val2.m_trid);
    }

    static void load(JGEquipment * equip);

};


// Create an association between table columns and fields in our object
// Here, BoundIOs is a class that is passed in to store column names &
// mappings

BEGIN_DTL_NAMESPACE

template<> class DefaultBCA<DBTraceElm>
{
public:
    void operator()(BoundIOs &cols, DBTraceElm &row)
    {
        cols[_TX("TRID")] == row.m_tridStr;
        cols[_TX("DSPER")] == row.m_dsper;
        cols[_TX("TOTSMP")] == row.m_totsmp;
        cols[_TX("REPGSZ")] == row.m_repgsz;
    }
};

// Specialization of DefaultInsValidate for DBTraceElm
// This defines a business rule we wish to enforce for all
// DBTraceElm objects before they are allowed to be inserted into the database
template<> class DefaultInsValidate<DBTraceElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBTraceElm &rowbuf) {
        // data is valid if rowbuf.m_trid is nonempty and
        // rowbuf.m_dsper is nonempty
        return (rowbuf.m_tridStr.length() > 0 && rowbuf.m_dsper.length() > 0);
    }
};

template<> class DefaultSelValidate<DBTraceElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBTraceElm &rowbuf) {
        return true;
    }
};

//
// Trace variable
//
template<> class DefaultBCA<DBTraceVarElm>
{
public:
    void operator()(BoundIOs &cols, DBTraceVarElm &row)
    {
        cols[_TX("TRID")] == row.m_trid;
        cols[_TX("VID")] == row.m_vid;
        cols[_TX("SEQ_NUM")] == row.m_seqnum;
    }
};

// Specialization of DefaultInsValidate for DBTraceVarElm
// This defines a business rule we wish to enforce for all
// DBTraceVarElm objects before they are allowed to be inserted into the database
template<> class DefaultInsValidate<DBTraceVarElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBTraceVarElm &rowbuf) {
        // data is valid if rowbuf.m_rptid is nonempty and
        // rowbuf.m_vid is nonempty
        return (rowbuf.m_trid.length() > 0 && rowbuf.m_vid.length() > 0);
    }
};

template<> class DefaultSelValidate<DBTraceVarElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBTraceVarElm &rowbuf) {
        return true;
    }
};


END_DTL_NAMESPACE

#endif  /* DBTRACEELM_H */
