// $Id: DBTriggerInfoElm.cpp,v 1.2 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBTriggerInfoElm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "JGTimeModule.h"
#include "dbio/DBTriggerInfoElm.h"
#include "JGBitsetSub.h"
#include "JGEnumSub.h"
#include "JGScalarSub.h"
#include "JGPluralSub.h"

//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBTriggerInfoElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBTriggerInfoElm::load");

    JGTimeModule * timeModule =
                        (JGTimeModule *)equip->findManager(CATEGORY_CLOCK);
    JGTriggerSubTable * trgsub_tbl = timeModule->trgsubTable();
    DBView<DBTriggerInfoElm> view(_TX("G_TRIGGER"));

    DBView<DBTriggerInfoElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        JGTriggerSubject * subject;
        DBTriggerInfoElm trigElm = (*read_it);
        JGVariable * relvar = NULL;
        JGManager * mngr =
                (JGManager *)equip->findManager(trigElm.m_mngrName.c_str());
        if (mngr == NULL)
        {
            TRACE_ERROR((_TX("Trigger : manager(%s) is not found.\n"),
                         trigElm.m_mngrName.c_str()));
        }
        trigElm.manager(mngr);
        if (trigElm.m_vid.size() > 0)
        {
            relvar = equip->variable(trigElm.m_vid.c_str());
        }

        // Create Trigger Subject
        if (trigElm.m_trgType == _TX("ENUM_DEVICE"))
        {
            JGEnumSubBase * esub = new JGEnumSubBase(trigElm);
            esub->parse();
            subject = (JGTriggerSubject *)esub;
        }
        else if (trigElm.m_trgType == _TX("ENUM_PARM_DEVICE"))
        {
            JGEnumParmSubBase * epsub = new JGEnumParmSubBase(trigElm);
            // set relational variable
            epsub->relation(relvar);
            epsub->parse();

            subject = (JGTriggerSubject *)epsub;
        }
        else if (trigElm.m_trgType == _TX("SCALAR_DEVICE"))
        {
            JGScalarSubBase * ssub = new JGScalarSubBase(trigElm);
            // set relational variable
            ssub->relation(relvar);

            subject = (JGTriggerSubject *)ssub;
        }
        else if (trigElm.m_trgType == _TX("BITSET_DEVICE"))
        {
            JGBitsetSubBase * bsub = new JGBitsetSubBase(trigElm);
            bsub->parse();
            // Set top and size from algorithm item

            subject = (JGTriggerSubject *)bsub;
        }
        else if (trigElm.m_trgType == _TX("PLURAL_DEVICE"))
        {
            JGPluralSubBase * psub = new JGPluralSubBase(trigElm);
            psub->parse();
            psub->relation(relvar);    // set relational(watchdog) variable
            // Set top and size from algorithm item

            subject = (JGTriggerSubject *)psub;
        }
        else
        {
            TRACE_ERROR((_TX("Trigger info(%s) is illegal type.\n"),
                         trigElm.m_trgType.c_str()));
            subject = NULL;
        }

        if (subject != NULL)
        {
            trgsub_tbl->insert(JGTriggerSubPair(subject->name(), subject));
        }
    }

    return ;
}

