// $Id: DBTriggerInfoElm.h,v 1.3 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBTriggerInfoElm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef DBTRIGGERINFOELM_H
#define DBTRIGGERINFOELM_H

#include "dbio.h"
#include "JGTriggerInfo.h"

class JGEquipment;

// Define an object to hold configure data
class DBTriggerInfoElm : public JGTriggerSubject
{
public:
    DBTriggerInfoElm() : JGTriggerSubject() { }

    friend class dtl::DefaultBCA<DBTriggerInfoElm>;
    friend class dtl::DefaultInsValidate<DBTriggerInfoElm>;
    friend class dtl::DefaultSelValidate<DBTriggerInfoElm>;

    friend bool operator<(const DBTriggerInfoElm &val1,
                          const DBTriggerInfoElm &val2)
    {
        return (strcmp(val1.m_trgid.c_str(), val2.m_trgid.c_str()) < 0);
    }

    static void load(JGEquipment * equip);

protected:
    string m_vid;
    string m_trgType;
    string m_mngrName;
    string m_algo;

};


// Create an association between table columns and fields in our object
// Here, BoundIOs is a class that is passed in to store column names &
// mappings

BEGIN_DTL_NAMESPACE

template<> class DefaultBCA<DBTriggerInfoElm>
{
public:
    void operator()(BoundIOs &cols, DBTriggerInfoElm &row)
    {
        cols[_TX("TRIGGER")] == row.m_trgid;
        cols[_TX("TRIGGER_NAME")] == row.m_trgName;
        cols[_TX("PRIORITY")] == row.m_priority;

        cols[_TX("VID")] == row.m_vid;
        cols[_TX("TRIGGER_TYPE")] == row.m_trgType;
        cols[_TX("MANAGER")] == row.m_mngrName;
        cols[_TX("ALGORITHM")] == row.m_algo;
    }
};

// Specialization of DefaultInsValidate for DBTriggerInfoElm
// This defines a business rule we wish to enforce for all
// DBTriggerInfoElm objects before they are allowed to be inserted into
// the database
template<> class DefaultInsValidate<DBTriggerInfoElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBTriggerInfoElm &rowbuf) {
        // data is valid if rowbuf.m_trgid is nonempty and
        // rowbuf.m_mngrName is nonempty
        return (rowbuf.m_trgid.length() > 0 && rowbuf.m_mngrName.length() > 0);
    }
};

template<> class DefaultSelValidate<DBTriggerInfoElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBTriggerInfoElm &rowbuf) {
        return true;
    }
};

END_DTL_NAMESPACE

#endif  /* DBTRIGGERINFOELM_H */
