// $Id: equipment.cpp,v 1.2 2002/10/12 09:11:52 fukasawa Exp $

//=============================================================================
/**
 *  @file    equipment.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "ace/Get_Opt.h"

// for ACE
#undef main

//
// Global data
//
extern BCHAR * DSN = _TX("UID=jyugem;PWD=jyugem;DSN=MySQL;");
#ifdef _DEBUG
extern BCHAR * PLC_DLL = _TX("melshm_d");
#else
extern BCHAR * PLC_DLL = _TX("melshm");
#endif
static bool _debug = false;

// Parse the command-line arguments and set options.
static int parse_args (int argc, char ** argv)
{
    ACE_Get_Opt get_opt(argc, argv, "dp:f:r:v");
    int c;

    while ((c = get_opt()) != -1)
    {
        switch (c)
        {
        case 'd':
            _debug = true;
            break;
        case 'p':
            PLC_DLL = get_opt.opt_arg();
            break;
        case 'n':
            DSN = get_opt.opt_arg();
            break;
        default:
            ACE_ERROR((LM_ERROR, "Usage:\n"
                                 "-d debug(not support)\n"
                                 "-n dataset name\n"
                                 "-p plc's dll name\n"));
            return -1;
            break;
        }
    }
    return 0;
}


//
// GEM Application
//
int main(int argc, char ** argv)
{
    if (::parse_args(argc, argv) == -1)
        return -1;

    JGEquipment * equipment = JGEquipment::instance();
    equipment->setDSNName(DSN);
    equipment->setPLCName(PLC_DLL);
    equipment->init();
    equipment->start_comm();    // Start communicate to host

    ACE_Thread_Manager::instance()->wait();

    ACE_DEBUG((LM_DEBUG, ACE_TEXT("Equipment::exit\n")));
    return 0;

}
