// $Id: JGIODevManager.h,v 1.4 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGIODevManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGIODEVMANAGER_H
#define JGIODEVMANAGER_H

#include "JGManager.h"
#include "sac/JGIODevice.h"

/*
 * I/O device manager class
 */
class JGIODevManager: public JGManager
{
public:
    JGIODevManager();
    ~JGIODevManager();

    int init(void * = 0);

    JGIODevice * find(JGid& devid);
    JGIODevice * findByName(const string& devname);
    JGIODevice * findByName(const BCHAR * devname) {
            string ioname(devname); return findByName(ioname);
        }

    virtual int getClock(struct tm& rettm);
    virtual int setClock(struct tm& newtm);

    JGIODeviceTable * iodevTable() { return &m_iotable; }
    JGIODeviceMap   * iodevMap()   { return &m_iomap; }
    static JGIODevManager * instance();

private:
    JGIODevice * find(JGVariable * var);
    void linkDevices();
//
private:
    JGIODeviceTable m_iotable;
    JGIODeviceMap   m_iomap;
};

#endif
