// $Id: JGIODevice.cpp,v 1.9 2003/03/19 16:49:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGIODevice.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "sac/JGIODevice.h"
#include "JGVariable.h"
#include "JGTriggerInfo.h"
#include "PLCDevice.h"

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
JGIODevice::JGIODevice(const JGIODevice& rhs) : JGPLCDevice(rhs)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGIODevice::JGIODevice");
    m_var = rhs.m_var;
    m_interlock = rhs.m_interlock;
    m_timeEnable = rhs.m_timeEnable;
    m_algorithm = rhs.m_algorithm;
    m_reset = rhs.m_reset;
    m_baseval = rhs.m_baseval;
    m_deltaval = rhs.m_deltaval;

    m_manager = rhs.m_manager;
    m_plc = rhs.m_plc;
    m_subject = rhs.m_subject;
    m_subsystem = rhs.m_subsystem;
}

//-----------------------------------------------------------------------------
// Copy
//-----------------------------------------------------------------------------
JGIODevice& JGIODevice::operator=(const JGIODevice& rhs)
{
    TRACE_FUNCTION(TRL_LOW, "JGIODevice::operator=");
    if (this == &rhs)
        return *this;
    copy(rhs);
    return *this;
}

//-----------------------------------------------------------------------------
void JGIODevice::copy(const JGIODevice& rhs)
{
    TRACE_FUNCTION(TRL_LOW, "JGIODevice::copy");
    this->JGPLCDevice::copy(rhs);
    m_var = rhs.m_var;
    m_interlock = rhs.m_interlock;
    m_timeEnable = rhs.m_timeEnable;
    m_algorithm = rhs.m_algorithm;
    m_reset = rhs.m_reset;
    m_baseval = rhs.m_baseval;
    m_deltaval = rhs.m_deltaval;

    m_manager = rhs.m_manager;
    m_plc = rhs.m_plc;
    m_subject = rhs.m_subject;
    m_subsystem = rhs.m_subsystem;
}

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
void JGIODevice::variable(JGVariable * var)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGIODevice::variable");
    m_var = var;
    if (this->format() == JGPLCDevice::STRING)
    {
        this->format(ATOM_ASCII);
    }
    else if (this->format() == JGPLCDevice::BIT ||
             this->format() == JGPLCDevice::BITSET)
    {
        this->format(ATOM_BOOLEAN);
    }
    else if (this->format() == JGPLCDevice::WORD ||
             this->format() == JGPLCDevice::WORDSET)
    {
        this->format(ATOM_UINT2);
    }
    else
    {
        TRACE_ERROR((_TX("Illegal I/O device data format = %d.\n"), this->format()));
        this->format(ATOM_UINT2);
    }
    this->viewFormat(var->format());
}

//-----------------------------------------------------------------------------
// Read data from i/o device.
//-----------------------------------------------------------------------------
int JGIODevice::sense()
{
    TRACE_FUNCTION(TRL_LOW, "JGIODevice::sense");

    int result = BEE_SUCCESS;
    JGvalue latest = m_value;    // Save the last value
    this->get();
    if (latest != m_value)
    {   // changed
        if (m_var != NULL)
        {   // update value of variable
            m_var->refresh(m_value);
        }
        if (m_subject != NULL)
        {
            m_subject->changed();
        }
        // Reset register
        //if (m_reset)
        //{
        //    m_value = m_baseval;
        //    this->put(m_value);
        //}
    }

    return result;
}

