// $Id: tclgem.cpp,v 1.7 2003/03/16 14:51:02 fukasawa Exp $

//=============================================================================
/**
 *  @file    tclgem.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "ace/Log_Msg.h"
#include "JGEquipment.h"

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#include <windows.h>
#endif

#include "tcl.h"

#define TCLGEM_VERSION     "1.0"
/*
 * Function prototype
 */
extern "C" {
DLLEXPORT int Gem_Init (Tcl_Interp *interp);
DLLEXPORT int Gem_SafeInit (Tcl_Interp *interp);
}
extern int Gem_openCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Gem_closeCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Gem_dbCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Gem_variableCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Gem_eventCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Gem_reportCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Gem_alarmCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Gem_terminalCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Gem_debugCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Gem_spoolCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Gem_ppCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);

static void
Gem_InterpDeleteProc (ClientData , Tcl_Interp *)
{
    ;
}

// ACE Objects
// ACE_Object_Manager ace_object_manager;

/*
 *  This procedure performs application-specific initialization.
 *  Most applications, especially those that incorporate additional
 *  packages, will have their own version of this procedure.
 *
 * Results:
 *  Returns a standard Tcl completion code, and leaves an error
 *  message in interp->result if an error occurs.
 *
 * Side effects:
 *  Depends on the startup script.
 */
DLLEXPORT int
Gem_Init (Tcl_Interp *interp)
{
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, "8.0", 0) == NULL) {
        return TCL_ERROR;
    }
#endif

    Tcl_CallWhenDeleted(interp, Gem_InterpDeleteProc, 0);

    JGEquipment * equipment = JGEquipment::instance();

    // Create additional commands.
    Tcl_CreateObjCommand(interp, "gem::open", Gem_openCmd,
        (ClientData)equipment, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "gem::close", Gem_closeCmd,
        (ClientData)equipment, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "gem::db", Gem_dbCmd,
        (ClientData)equipment, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "gem::variable", Gem_variableCmd,
        (ClientData)equipment, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "gem::event", Gem_eventCmd,
        (ClientData)equipment, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "gem::report", Gem_reportCmd,
        (ClientData)equipment, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "gem::alarm", Gem_alarmCmd,
        (ClientData)equipment, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "gem::terminal", Gem_terminalCmd,
        (ClientData)equipment, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "gem::debug", Gem_debugCmd,
        (ClientData)equipment, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "gem::spool", Gem_spoolCmd,
        (ClientData)equipment, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "gem::pp", Gem_ppCmd,
        (ClientData)equipment, (Tcl_CmdDeleteProc *)0);

    return Tcl_PkgProvide(interp, "gem", TCLGEM_VERSION);
}

/*
 *  This procedure initializes commands for a safe interpreter.
 *  You would leave out of this procedure any commands you deemed unsafe.
 *
 * Results:
 *  A standard Tcl result.
 *
 * Side effects:
 *  None.
 */
DLLEXPORT int
Gem_SafeInit (Tcl_Interp *interp)
{
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, "8.0", 0) == NULL) {
        return TCL_ERROR;
    }
#endif

    return Tcl_PkgProvide(interp, "gem", TCLGEM_VERSION);
}
