// $Id: MELDeviceClient.cpp,v 1.2 2002/10/12 09:11:53 fukasawa Exp $

//=============================================================================
/**
 *  @file    MELDeviceClient.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================


#define BEE_BUILD_DLL

#include "ace/Mem_Map.h"
#include "ace/Log_Msg.h"
#include "MELXmlParser.h"
#include "MELDeviceClient.h"

static MELDeviceClient * _deviceClient = NULL;

// Function prototype

//-----------------------------------------------------------------------------
// Constructor/Destructor.
//-----------------------------------------------------------------------------
MELDeviceClient::~MELDeviceClient()
{
}

//------------------------------------------------------------------------------
// Instance MELSEC device server object.
//------------------------------------------------------------------------------
MELDeviceClient * MELDeviceClient::instance()
{
    if (_deviceClient != NULL) {
        return _deviceClient;
    }

    // Create melsec device server
    _deviceClient = new MELDeviceClient();

    MELDeviceManager::instance(_deviceClient);

    return _deviceClient;
}

//-----------------------------------------------------------------------------
// Initialize Device Manager Object.
//-----------------------------------------------------------------------------
int MELDeviceClient::init(const char * pname, const char * xmlname,
                          int chan, int stnum, int unit)
{
    int result;
    result = this->MELDeviceManager::init(pname, xmlname, chan, stnum, unit);
    if (result < 0)
    {
        return result;
    }

    openVirtualMemory();                // Open shared memory

    setVirtualAddress();                // Set address to memory info.

    return result;
}

//------------------------------------------------------------------------------
// Open virtual melsec memory.
//------------------------------------------------------------------------------
int MELDeviceClient::openVirtualMemory()
{
    int result = m_melmmap.map(m_filename.c_str(), -1, O_RDWR | O_CREAT,
                           ACE_DEFAULT_FILE_PERMS, PROT_RDWR, ACE_MAP_SHARED);
    if (result == -1)
    {
        ACE_ERROR_RETURN((LM_ERROR,
            "MELDeviceClient::openVirtualMemory: %p\n", "mmap"), -1);
    }
    m_vmtop = (VirtualMelsec *)m_melmmap.addr();
    return 0;
}


//------------------------------------------------------------------------------
// Returns the pointer to the PLCDeviceManager class.
// The BEE_BUILD_DLL and BEE_Export directives are necessary as take care
// of exporting the function for Win32 platforms.
extern "C" BEE_Export PLCDeviceManager * CreatePLC(void);

PLCDeviceManager * CreatePLC(void)
{
    PLCDeviceManager * pm = MELDeviceClient::instance();
    return pm;
}

