// $Id: PLCDevice.h,v 1.2 2003/03/16 14:51:02 fukasawa Exp $

//=============================================================================
/**
 *  @file    PLCDevice.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef PLCDEVICE_H
#define PLCDEVICE_H

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#endif

#include <string>
using namespace std;
#include "ace/streams.h"
#include "ace/OS.h"
#include "BEE_Export.h"
#include "PLCAddress.h"

class PLCDeviceManager;

//------------------------------------------------------------------------------
// PLC Device Register
//------------------------------------------------------------------------------
class BEE_Export PLCDevice
{
public:
    enum { MEM_BIT, MEM_WORD };

    PLCDevice(const ACE_TCHAR * name, int devcd, int memtype, size_t memSize,
              long base = 0)
            : m_devname(name), m_devCode(devcd), m_memType(memtype),
              m_areaSize(memSize), m_base(base) {}
    virtual ~PLCDevice() {}

    virtual int open(long bus, long stnum, long addr = 0, long offset = 0);
    virtual int close();
    virtual int read(long address, size_t size, u_short * data) const = 0;
    virtual int write(long address, size_t size, u_short * data) = 0;
    virtual int put(long address, u_short data) = 0;
    virtual u_short get(long address) const = 0;
    virtual size_t  words() const = 0;
    virtual int  setvm(long address, size_t size, u_short * data) = 0;
    virtual int  vmread(long address, size_t size, u_short * data) const = 0;
    virtual u_short vmget(long address) const = 0;
    virtual void dump(long top = 0, size_t size = ACTION_END) const = 0;

    bool   isBit()  const { return (m_memType == MEM_BIT); }
    bool   isWord() const { return (m_memType == MEM_WORD); }
    size_t size() const   { return m_areaSize; }
    const  string& name() const { return m_devname; }
    long   devPath() const      { return m_path; }
    long   stationNum() const   { return m_stnum; }
    int    devCode() const      { return m_devCode; }
    size_t bytes() const        { return (this->words() * 2); }
    long   convAddress(string& adr) const { return convAddress(adr.c_str()); }
    long   convAddress(const ACE_TCHAR * addr) const;

    u_short * vm() const        { return m_vmaddr; }
    void      vm(u_short * top) { m_vmaddr = top; }

//
protected:
    string m_devname;            // Device Name
    int    m_path;               // bus's path
    int    m_stnum;              // station number
    int    m_devCode;            // Device Code
    int    m_memType;            // Device Type: BIT or WORD
    size_t m_areaSize;
    size_t m_actSize;
    long   m_base;               // base address

    u_short * m_vmaddr;          // virtual memory address
};


#endif  /* PLCDEVICE_H */
