# kabuAPI: Application Programmer Interface for Stock Trading 
# Copyright (C) 2007 kabuAPI Project (http://sourceforge.jp/projects/kabuapi/)
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import yahoo
import matsui
import string
import sys
import time
import pickle
import os

buycandidate = [2712]
upperlim = 100000

def yobi(n):
    if n <= 2000: return n
    elif n <= 3000: return marume(n,5)
    elif n <= 30000: return marume(n,10)
    elif n <= 50000: return marume(n,50)
    elif n <= 100000: return marume(n,100)
    elif n <= 1000000: return marume(n,1000)
    elif n <= 20000000: return marume(n,10000)
    elif n <= 30000000: return marume(n,50000)
    else: return marume(n,100000)

def marume(m,tanni):
    return int(round(float(m) / float(tanni)) * tanni)

def round_to_tangen(n, code):
    tan = yahoo.code2tangen(code)
    return (n / tan) * tan

