# -*- coding: japanese.euc-jp -*-

# kabuAPI: Application Programmer Interface for Stock Trading 
# Copyright (C) 2007 kabuAPI Project (http://sourceforge.jp/projects/kabuapi/)
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import urllib2
import urlparse
import re

def remcomma(string):
    def strappend(str1, str2):
        return str1 + str2
    return reduce(strappend, string.split(','))

def code2name(code):
    url = "http://quote.yahoo.co.jp/l?s=" + str(code)
    page = urllib2.urlopen(url)
    udata = unicode(page.read(), "euc-jp")
    page.close()
    try:
        return re.compile("<td>[^>]*</td>").search(udata).group().encode("euc-jp")[4:-5]
    except AttributeError:
        return "not exist"

def code2tangen(code):
    def st2int(st):
        if st == "---":
            return 1
        else:
            return int(remcomma(st))
    url = 'http://quote.yahoo.co.jp/q?s='+ str(code) +'&d=t'
    page = urllib2.urlopen(url)
    data = page.read()
    page.close()
    udata = unicode(data[30:],"euc-jp")
    try:
        ex = re.compile(u"ñ<br>[0-9,-]*").search(udata).group()
    except AttributeError:
        return -1
    return st2int(ex[8:-1])


def code2price(code):
    url = 'http://quote.yahoo.co.jp/q?s='+ str(code) +'&d=t'
    page = urllib2.urlopen(url)
    data = page.read()
    page.close()
    udata = unicode(data[30:],"euc-jp")
    try:
        ex = re.compile(u"<br>[0-9/:]* <b>[0-9,]*</b>").search(udata).group()
    except AttributeError:
        return -1
    try:
        ex = re.compile(u"<b>[0-9,]*</b>").search(ex).group()
    except AttributeError:
        return -1
    return int(remcomma(ex[3:-4]))
