/* $Id: memory.h,v 1.1.1.1 2004/07/14 05:07:41 ryos Exp $ */
/* Copyright (C) 2000-2004 Sinby Corporation */
/* All Rights Reserved */
/* This project is covered by LGPL */

#ifndef __SINBY_KAFFE_ECOS_MEMORY_H__
#define __SINBY_KAFFE_ECOS_MEMORY_H__

#include <pkgconf/system.h>
#include <cyg/infra/cyg_type.h>
#include <sinby/kaffe/md/memory.h>

void ecos_mempool_init(void);
void ecos_view_mempool_info(void);

#ifdef CYGPKG_MEMALLOC
#define ECOS_MALLOC(_size) malloc(_size)
#define ECOS_FREE(_ptr) free(_ptr)
#else
void *ecos_malloc(size_t size);
void ecos_free(void *ptr);
#define ECOS_MALLOC(_size) ecos_malloc(_size)
#define ECOS_FREE(_ptr) ecos_free(_ptr)
#endif

#define gc_pgsize 8192
#define gc_pgbits 13

void* gc_heap_malloc(size_t sz);
void gc_heap_free(void* mem);

#endif /* __SINBY_KAFFE_ECOS_MEMORY_H__ */
