/* $Id: init.c,v 1.1.1.1 2004/07/14 05:07:41 ryos Exp $ */
/* Copyright (C) 2000-2004 Sinby Corporation */
/* All Rights Reserved */
/* This project is covered by LGPL */

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/diag.h> 
#include <cyg/kernel/kapi.h>
#include <cyg/hal/hal_arch.h>
#include <pkgconf/system.h>
#include <cyg/fileio/fileio.h>  // mount
#include <network.h>
#include <sinby/kaffe/md.h>
#include <sinby/kaffe/fs_support.h>
#include <sinby/kaffe/memory.h>
#include <sinby/kaffe/init.h>

CYG_HAL_TABLE_BEGIN( __KAFFE_ECOS_INIT_FUNC_TABLE__, kaffe_ecos_init_table);
CYG_HAL_TABLE_END( __KAFFE_ECOS_INIT_FUNC_TABLE_END__, kaffe_ecos_init_table);

KAFFE_ECOS_INIT_ENTRY(kaffe_ecos_init1_10_ecos_md_init,ecos_md_init);

void ecos_mempool_init(void);

//#define STACK_DEBUG
static cyg_uint32 *uip;

void view_uip(void)
{
	diag_printf("uip(0x%x) == 0x%x\n",uip,*uip);
}

void
kaffe_ecos_init(void)
{
	int err;
	kaffe_ecos_init_func_t *func;

#ifdef STACK_DEBUG
	cyg_addrword_t sbase;
	cyg_uint32 ssize;
	cyg_handle_t th;

	th = cyg_thread_self();
	sbase = cyg_thread_get_stack_base(th);
	ssize = cyg_thread_get_stack_size(th);
	diag_printf("sbase:0x%x ssize:0x%x\n",sbase,ssize);
	diag_printf("now sp:0x%x\n",&th);
	uip = (cyg_uint32)sbase;
	*uip = 0x12091103;
	view_uip();
#endif

	ecos_mempool_init();

	err = mount( "", "/", "rdcf" );
	if( err < 0 ) {
		diag_printf("ecos_md_init:rdcf mount error %d\n", err);
	}
	err = chdir( "/" );
	if( err < 0 ) {
		diag_printf("ecos_md_init:rdcf chdir error %d\n", err);
	}

	init_all_network_interfaces();

	for ( func = __KAFFE_ECOS_INIT_FUNC_TABLE__; func < &__KAFFE_ECOS_INIT_FUNC_TABLE_END__ ; func++ ) {
//#define MD_DEBUG
#ifdef MD_DEBUG
		diag_printf("INIT MD 0x%x\n",*func);
#endif
		(*func)();
	}
#ifdef MD_DEBUG
	diag_printf("INIT MD done\n");
#endif
}
