/* $Id: memory.c,v 1.1.1.1 2004/07/14 05:07:41 ryos Exp $ */
/* Copyright (C) 2000-2004 Sinby Corporation */
/* All Rights Reserved */
/* This project is covered by LGPL */

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/diag.h>
#include <cyg/kernel/kapi.h>
#include <sinby/kaffe/memory.h>
#include <sinby/kaffe/md.h>
#include <stdlib.h>

#ifndef CYGPKG_MEMALLOC
static cyg_handle_t cyg_heap_handle;
static cyg_mempool_var mempool;
#endif

void
ecos_mempool_init(void)
{
#ifndef CYGPKG_MEMALLOC
	cyg_mempool_var_create(
		KAFFE_ECOS_HEAP_BASE,
		KAFFE_ECOS_HEAP_SIZE,
		&cyg_heap_handle,
		&mempool);
#endif
}

#ifndef CYGPKG_MEMALLOC
void *ecos_malloc(size_t size) 
{
#ifdef CYGDBG_KAFFE_ECOS_MEMORY_DEBUG
	void *rv;

	rv = cyg_mempool_var_try_alloc(cyg_heap_handle,size);
	if ( rv != NULL ) {
		return rv;
	}

	diag_printf("size:0x%x ",size);
	ecos_view_mempool_info();
	return NULL;
#else
	return cyg_mempool_var_try_alloc(cyg_heap_handle,size);
#endif
}

void ecos_free(void *ptr)
{
	return cyg_mempool_var_free(cyg_heap_handle,ptr);
}
#endif /* CYGPKG_MEMALLOC */

void ecos_view_mempool_info()
{

#ifdef CYGPKG_MEMALLOC
	struct mallinfo info;

	info = mallinfo();
	diag_printf("info.arena:0x%x info.maxfree:0x%x\n",
		info.arena,info.maxfree);
#else
    cyg_mempool_info info;
	cyg_mempool_var_get_info(cyg_heap_handle,&info);
	diag_printf("total:0x%x free:0x%x base:0x%x maxfree:0x%x\n",
		info.totalmem,info.freemem,info.base,info.maxfree);
#endif
}
