/* $Id: networks.c,v 1.1.1.1 2004/07/14 05:07:41 ryos Exp $ */
/* Copyright (C) 2000-2004 Sinby Corporation */
/* All Rights Reserved */
/* This project is covered by LGPL */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <network.h>
#include <sinby/kaffe/syscalls.h>

#ifndef ECOS_HOST_NAME
#define ECOS_HOST_NAME "myhost"
#endif

int
gethostname(char *name, int namelen) 
{
	strncpy(name,ECOS_HOST_NAME,namelen);

	return 0;
}

int
ecos_native_socket(int domain, int type, int protocol, int *outsock)
{
	*outsock = socket(domain,type,protocol);
	if ( *outsock < 0 ) {
		return errno;
	}
	return 0;
}

int
ecos_native_connect(int sock, struct sockaddr* addr, int len, int timeout)
{
	int rv;

	rv = connect(sock,addr,len);
	if ( rv < 0 ) {
		return errno;
	}
	return 0;
}

int
ecos_native_bind(int sock, struct sockaddr* addr, int len)
{
	return (bind(sock, addr, len) < 0) ? errno : 0;
}

int
ecos_native_listen(int sock, int backlog)
{
	return (listen(sock, backlog) < 0) ? errno : 0;
}

int
ecos_native_accept(int sock, struct sockaddr* addr, int *len, int timeout, int* outsock)
{
	*outsock = accept(sock, addr, len);
	return (*outsock < 0) ? errno : 0;
}

int
ecos_native_sock_read(int sock, void* buf, size_t len, int timeout, ssize_t *out)
{
	*out = read(sock, buf , len );
	return (*out < 0) ? errno : 0;
}

int
ecos_native_recvfrom(int sock, void* buf, size_t len, int flags, struct sockaddr* addr, int* flen, int timeout, ssize_t *out)
{
	*out = recvfrom(sock, buf, len, flags, addr, flen);
	return (*out < 0) ? errno : 0;
}

int
ecos_native_sock_write(int sock, const void* buf, size_t len, ssize_t *out)
{
	*out = write(sock, (void *)buf , len );
	return (*out < 0) ? errno : 0;
}

int
ecos_native_sendto(int sock, const void* buf, size_t len, int flags, const struct sockaddr* addr, int tolen, ssize_t *out)
{
	*out = sendto(sock,buf,len,flags,addr,tolen);
	return (*out < 0) ? errno : 0;
}

int
ecos_native_setsockopt(int sock, int level, int optname, const void* optval, int optlen)
{
	return (setsockopt(sock,level,optname,optval,optlen) < 0) ? errno : 0;
}

int
ecos_native_getsockopt(int sock, int level, int optname, void* optval, int *optlen)
{
	return (getsockopt(sock,level,optname,optval,optlen) < 0) ? errno : 0;
}

int
ecos_native_getsockname(int sock, struct sockaddr* name, int* namelen)
{
	return (getsockname(sock, name, namelen) < 0) ? errno : 0;
}

int
ecos_native_getpeername(int sock, struct sockaddr* name, int* namelen)
{
	return (getpeername(sock, name, namelen) < 0) ? errno : 0;
}

int
ecos_native_sockclose(int sock)
{
	return (close(sock) < 0) ? errno : 0;
}

int
ecos_native_gethostbyname(const char *host, struct hostent **out)
{
	*out = gethostbyname(host);
	return (*out == 0) ? ENOSUPP : 0;
}

int
ecos_native_gethostbyaddr(const char* addr, int len, int type, struct hostent **out)
{
	*out = gethostbyaddr(addr,len,type);
	return (*out == 0) ? ENOSUPP : 0;
}

int
ecos_native_select(int nfd, fd_set* in, fd_set* out, fd_set* ex, struct timeval* tv, int* rout)
{
	*rout = select(nfd,in,out,ex,tv);
	return (*rout < 0) ? errno : 0;
}
