/* $Id: mips.c,v 1.1.1.1 2004/07/14 05:07:41 ryos Exp $ */
/* Copyright (C) 2000-2004 Sinby Corporation */
/* All Rights Reserved */
/* This project is covered by LGPL */

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/diag.h> 
#include <cyg/kernel/kapi.h>
#include <cyg/hal/hal_arch.h>
#include <sinby/kaffe/md.h>
#include <sinby/kaffe/init.h>

void dumpThreads(void);
void kaffe_exception_handler(cyg_addrword_t data,cyg_code_t exception_number,cyg_addrword_t info);
cyg_exception_handler_t     *old_handler; 
cyg_addrword_t              old_data;

void
ecos_md_init(void)
{
	cyg_exception_set_handler(7,
		kaffe_exception_handler,
		0x1290,
		&old_handler,
		&old_data);
}

void
kaffe_exception_handler(cyg_addrword_t data,cyg_code_t exception_number,cyg_addrword_t info)
{
	volatile int count = 0;
	HAL_SavedRegisters *regsp;

	cyg_scheduler_lock();

	regsp = (HAL_SavedRegisters *)info;
	diag_printf("vector 0x%x\n", regsp->vector);
	diag_printf("pc     0x%x\n", regsp->pc    );
	diag_printf("sr     0x%x\n", regsp->sr    );
	diag_printf("cache  0x%x\n", regsp->cache );

	diag_printf("cause  0x%x\n", regsp->cause );
	diag_printf("badvr  0x%x\n", regsp->badvr );
	diag_printf("prid   0x%x\n", regsp->prid  );
	diag_printf("config 0x%x\n", regsp->config);

	dumpThreads();

	while(1) {
		count++;
	}
}
