/* Copyright (c) 2000,2001 Sinby, Inc.
   All Rights Reserved 

   This project is covered by the E-Sinby Embedded System Public License. 
   */

/* $Id: SystemResources.c,v 1.5 2001/10/08 08:17:42 ryos Exp $ */

#include "config.h"
#include "config-std.h"
#include "config-io.h"
#include "config-mem.h"
#include "baseClasses.h"
#include "java_lang_Integer.h"
#include "network.h" // for bootp

#include "SystemResources.h"
#define INET_NAME "net0"

int addClasspath(const char *);

jboolean
com_sinby_kaffe_ecos_SystemResources_addClasspath0(struct Hjava_lang_String *jstr)
{
	const char *cstr;

	if ( jstr == NULL ) {
		SignalError("java.lang.NullPointerException", "");
	} else {
		int rv;
		cstr = checkPtr(stringJava2C(jstr));
		rv = addClasspath(cstr);
		return ( rv == 1 )?true:false;
	}
}

struct systemResourceUsageTable;
static struct Hjava_lang_Object *getGCHeapUsage(struct systemResourceUsageTable *,const char *);

#define SystemResourceUsage(name,func) { name , sizeof(name)-1 , func }

static struct systemResourceUsageTable {
	const char *resource_name;
	int name_len;
	struct Hjava_lang_Object *(*funcP)(struct systemResourceUsageTable *,const char *);
} systemResourceUsageTable[] = {
	SystemResourceUsage("gc.heap.",getGCHeapUsage),
	{ NULL , 0 , NULL }
};

struct Hjava_lang_Object* 
com_sinby_kaffe_ecos_SystemResources_getSystemResourceUsage0(struct Hjava_lang_String* jstr) 
{
	const char *cstr;
	struct systemResourceUsageTable *tableP;

	if ( jstr == NULL ) {
		SignalError("java.lang.NullPointerException", "");
		return NULL;
	}

	cstr = checkPtr(stringJava2C(jstr));
	for ( tableP = systemResourceUsageTable ; tableP->resource_name != NULL ; tableP++ ) {
		if ( memcmp(cstr,tableP->resource_name,tableP->name_len) == 0 ) {
			return tableP->funcP(tableP,cstr);
		}
	}

	return NULL;
}


static 
struct Hjava_lang_Object *
getGCHeapUsage(struct systemResourceUsageTable *tableP,const char *cstr)
{
	extern size_t gc_heap_total;/* current size of the heap */
	extern size_t gc_heap_allocation_size;/* amount of memory by which to grow heap */
	extern size_t gc_heap_initial_size;/* amount of memory to initially allocate */
	extern size_t gc_heap_limit;/* maximum size to which heap should grow */

	const char *name;
	struct Hjava_lang_Integer *intObj;

	name = &cstr[tableP->name_len];
	if ( strcmp(name,"total") == 0 ) {
		intObj = (struct Hjava_lang_Integer *)newObject(javaLangIntegerClass);
		intObj->value = (jint)gc_heap_total;
		return (struct Hjava_lang_Object *)intObj;
	} else if ( strcmp(name,"allocation_size") == 0 ) {
		intObj = (struct Hjava_lang_Integer *)newObject(javaLangIntegerClass);
		intObj->value = (jint)gc_heap_allocation_size;
		return (struct Hjava_lang_Object *)intObj;
	} else if ( strcmp(name,"initial_size") == 0 ) {
		intObj = (struct Hjava_lang_Integer *)newObject(javaLangIntegerClass);
		intObj->value = (jint)gc_heap_initial_size;
		return (struct Hjava_lang_Object *)intObj;
	} else if ( strcmp(name,"limit") == 0 ) {
		intObj = (struct Hjava_lang_Integer *)newObject(javaLangIntegerClass);
		intObj->value = (jint)gc_heap_limit;
		return (struct Hjava_lang_Object *)intObj;
	}

	return NULL;
}

jboolean
com_sinby_kaffe_ecos_SystemResources_re_init_net0(struct Hjava_lang_String *driver, struct Hjava_lang_String *ipaddr, struct Hjava_lang_String *netmask, struct Hjava_lang_String *broadcast, struct Hjava_lang_String *gateway, struct Hjava_lang_String *server)
{

	struct bootp bootp_record;
	int rv;

	if ((driver == NULL) ||
		(ipaddr == NULL) ||
		(netmask == NULL) ||
		(broadcast == NULL) ||
		(gateway == NULL) ||
		(server == NULL)) {

		SignalError("java.lang.NullPointerException", "");
	}
	
//diag_printf("driver:%s\n",stringJava2C(driver));
	build_bootp_record(&bootp_record,
		checkPtr(stringJava2C(driver)),
		checkPtr(stringJava2C(ipaddr)),
		checkPtr(stringJava2C(netmask)),
		checkPtr(stringJava2C(broadcast)),
		checkPtr(stringJava2C(gateway)),
		checkPtr(stringJava2C(server)));
	
	rv = init_net(checkPtr(stringJava2C(driver)),&bootp_record);
	return ( rv == 1 )?true:false;
}
