/* Copyright (c) 2001 Sinby, Inc.
   All Rights Reserved 

   This project is covered by the E-Sinby Embedded System Public License. 
   */

/* $Id: SystemResources.java,v 1.7 2001/10/06 08:43:13 ryos Exp $ */

package com.sinby.kaffe_ecos;

import java.util.*;

public class SystemResources {
	public static final boolean embedded;
	static {
		embedded = System.getProperty("kaffe.embedded", "false").equals("true");
		if ( embedded ) {
			System.loadLibrary("sinby");
		}
	}

	public static synchronized boolean addClasspath(String str) {
		if ( embedded ) {
			Properties props;
			String classpath;
			String sep;

			props = System.getProperties();
			classpath = props.getProperty("java.class.path");

			sep =  System.getProperties().getProperty("path.separator");
			if ( sep == null ) {
				sep = ":";
			}
			props.put("java.class.path",classpath + sep + str);

			return addClasspath0(str);
		} else {
			return false;
		}
	}

	private static native boolean addClasspath0(String str);

	public static Object getSystemResourceUsage(String str) {
		if ( embedded ) {
			return getSystemResourceUsage0(str);
		} else {
			return null;
		}
	}

	private static native Object getSystemResourceUsage0(String str);

	private static native boolean re_init_net0(String driver,String ipaddr,String netmask,String broadcast,String gateway,String server);

	static boolean re_init_net(String driver,String ipaddr,String netmask,String broadcast,String gateway,String server)
	{
		if ( embedded ) {
			return re_init_net0(driver,ipaddr,netmask,broadcast,gateway,server);
		} else {
			return false;
		}
	}
}
