<?php
/**
* commentregist.php 処理概要：メモ・コメント詳細表示処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/db/service/ContentsViewService.class.php");
require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("class/xml/RSSController.class.php");			// RSS
require_once("function/KakikoContentsCommon.php");


require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("commentRegistForm", "POST", $_SERVER["PHP_SELF"], "_self");

$dataArray = null;
if (isset($_POST['commentId']) && $_POST['commentId'] != "") {
	// コメント情報を取得
	$dataArray = getCommntData($_POST['commentId']);
}else{
	// メモ情報を取得
	$dataArray = getMemoData($_POST['memoId'], $s_UserId);
}

// 入力項目のデフォルトをセット
$contributor = $o_resource->getValue("G04005L011");
if($s_UserName != null){
	$contributor = $s_UserName;
}
$o_form->setDefaults(array(
    "name"      => $contributor,
    "title"     => "Re:".$dataArray['title'],
    "text"      => ">".preg_replace("/\n/","\n>", $dataArray['text']),
    "mail"      => "",
    "url"       => "",
    "imgFile"   => "",
    "updDelPwd" => ""
));

// 項目セット
$o_form->addElement("header",   "header",     $o_resource->getValue("G04005L001"));
$o_form->addElement("text",     "name",       $o_resource->getValue("G04005L002"), array("size"=>"40", "maxlength"=>"32", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("text",     "title",      $o_resource->getValue("G04005L003"), array("size"=>"40", "maxlength"=>"20", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("textarea", "text",       $o_resource->getValue("G04005L004"), array("maxlength"=>"500", "autocomplete"=>"off", "class"=>"", "cols"=>"45", "rows"=>"10"));
$o_form->addElement("text",     "mail",       $o_resource->getValue("G04005L005"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("text",     "url",        $o_resource->getValue("G04005L006"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("file",     "imgFile",    $o_resource->getValue("G04005L007"), array("autocomplete"=>"off", "class"=>""));
$o_form->addElement("password", "updDelPwd",  $o_resource->getValue("G04005L008"), array("size"=>"4", "maxlength"=>"4", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("hidden",   "memoId",     $_POST['memoId']);
$o_form->addElement("hidden",   "memoTypeId", $_POST['memoTypeId']);
$o_form->addElement("hidden",   "commentId",  $_POST['commentId']);

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

// チェック項目
$o_form->addRule("name",      $o_resource->getValue("G04005M001"), "required");
$o_form->addRule("name",  	  $o_resource->getValue("G04005M002"), "maxlength_valid", 32);
$o_form->addRule("title",     $o_resource->getValue("G04005M003"), "required");
$o_form->addRule("title",  	  $o_resource->getValue("G04005M004"), "maxlength_valid",	20);
$o_form->addRule("text",  	  $o_resource->getValue("G04005M005"), "maxlength_valid",	500);
$o_form->addRule("mail",  	  $o_resource->getValue("G04005M006"), "email",	null);
$o_form->addRule("mail",	  $o_resource->getValue("G04005M007"), "maxlength_valid",	128);
$o_form->addRule("url",  	  $o_resource->getValue("G04005M008"), "regex",	"/^(http|https)?(:\/\/([\w-]+\.)+[\w-]+(\/[\w- .\/?%&=]*)?)/");
$o_form->addRule("url",	      $o_resource->getValue("G04005M009"), "maxlength_valid",	128);
$o_form->addRule("updDelPwd", $o_resource->getValue("G04005M010"), "regex", "/^[a-zA-Z0-9]+$/");
$o_form->addRule("updDelPwd", $o_resource->getValue("G04005M011"), "maxlength_valid",	4);

$errorMessage = "";
$pageFlg = 0;
$tplName = "";
$errorRadio = "";
$filecheck = TRUE;
// 登録ボタン
if (isset($_POST[submit])) {
	
	// アップロードファイルチェック
    if($_FILES['imgFile']['name'] != ""){
		if($_FILES['imgFile']['size'] > 204800){
	    	$errorFileSize = $o_resource->getValue("G04005M015");
	    	$filecheck = FALSE;
		}else if(in_array($_FILES['imgFile']['type'], explode(",", UPLOAD_MIME_TYPE)) == FALSE){
	    	$errorFileType = $o_resource->getValue("G04005M016");
	    	$filecheck = FALSE;
		}
    }
    	
    // チェックOK
    if ($o_form->validate() && $filecheck) {
        $pageFlg = 1;
        
		// ファイルアップロード処理
		$uploadDir = "./img/memo/";
		list($msec, $sec) = explode(" ", microtime()); 
		$filename = str_replace("/", "_", crypt(date('YmdHis', time()).(((float)$msec)*1000000), "kakikomap"));	// 軽度にファイル名を暗号化
		$uploadfileName = "";

		if($_FILES['imgFile']['name'] != ""){
		    $pathArray = pathinfo($_FILES['imgFile']['name']);
			$uploadfileName = $filename.".".$pathArray['extension'];
			if(is_uploaded_file){
				if(!move_uploaded_file($_FILES['imgFile']['tmp_name'], $uploadDir.$uploadfileName)){
					print("File Upload Error!!".$uploadDir.$uploadfileName);
				}    
			}else{
				trigger_error("Illegal file!!", E_USER_ERROR);
			    exit(-1);
			}
		}
		
        // **************************
        // DB登録処理実装部
        // **************************
        $commentId = 0;
        if(isset($_POST['commentId']) && $_POST['commentId'] != ""){
        	$commentId = $_POST['commentId'];
        }

		// コメント詳細情報
		$detail = new CommentData();
		$detail->setMemoTypeID($_POST['memoTypeId']);
		$detail->setMemoID($_POST['memoId']);
		$detail->setCommentID("");
		$detail->setHigherCommentID($commentId);
		$detail->setUserName($_POST['name']);
		$detail->setCommentTitle($_POST['title']);
		$detail->setCommentText($_POST['text']);
		$detail->setMailAddress($_POST['mail']);
		$detail->setReleteURL($_POST['url']);
		$detail->setImageFile($uploadfileName);
		$detail->setUpdateDeletePassword($_POST['updDelPwd']);
		$detail->setAccessCount("0");
		$detail->setDeleteFlg("0");
		$detail->setAddDateTime(date('Y/m/d H:i:s'));
		$detail->setUpdateDateTime(date('Y/m/d H:i:s'));
		
		// INSERT
		$service = new ContentsViewService(DIRECTORY_NAME);
		if(!$service->insertCommnet($detail)){
			trigger_error("DB Error!!", E_USER_ERROR);
		    exit(-1);
		}
        
		// RSS出力
		$rss = new RSSController($dataArray['layerid'], DIRECTORY_NAME);
		if(!$rss->writeRssFile()){
			trigger_error("RSS Error!!", E_USER_ERROR);
		    exit(-1);
		}
    }
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// ボタンを表示
if ($pageFlg == 0) {
    // 登録画面
    $o_form->addElement("submit", "submit", $o_resource->getValue("G04005L009"), array("class"=>"fs12_black"));
    $o_form->addElement("button", "close",  $o_resource->getValue("G04005L010"), array("onclick"=>"window.close();", "class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());
	$labelArray = array(
      "label01"  => $o_resource->getValue("G04005M012"),
      "label02"  => $o_resource->getValue("G04005M013"),
      "label03"  => $o_resource->getValue("G04005M014"),
      "errorFileSize" => $errorFileSize,
      "errorFileType" => $errorFileType
	);
	$o_smarty->assign("labelArray", $labelArray);
	$o_smarty->assign("errorMessage", $errorMessage);

    $tplName = DIRECTORY_NAME."/commentregist.tpl";

} else {
    // 完了画面
    $tplName = DIRECTORY_NAME."/memoclose.tpl";
}

$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ引用データ取得
* 処理詳細：メモ引用データを取得する
*
* @引数： (I) memoid	- string  メモID
*         (I) userId    - string  ユーザID
* @戻値： array 詳細情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getMemoData($memoid, $userId){

	$service    = new ContentsViewService(DIRECTORY_NAME);
	$dataObject = $service->getOneMemoDetailViewDataAuth($memoid, $userId);

	$memoData = array(
		"title"	=> $dataObject->getMemoTitle(),
		"text"	=> $dataObject->getMemoText(),
		"layerid"	=> $dataObject->getLayerID()
	);

	return $memoData;
}

/**
* 関数概要：コメント引用データ取得
* 処理詳細：コメント引用データを取得する
*
* @引数： (I) $commentid	- string  コメントID
* @戻値： array 詳細情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getCommntData($commentid){

	$service    = new ContentsViewService(DIRECTORY_NAME);
	$dataObject = $service->getOneCommentData($commentid);

	$commentData = array(
		"title"	=> $dataObject->getCommentTitle(),
		"text"	=> $dataObject->getCommentText(),
		"layerid"	=> $dataObject->getLayerID()
	);
	
	return $commentData;	
}

?>