<?php
/**
* deleteuser.php 処理概要：個人情報削除処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/db/service/ContentsViewService.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("userDeleteForm", "POST", $_SERVER["PHP_SELF"], "_self");

// 入力項目のデフォルトをセット
$s_UserId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
}
$userArray = getUserData($s_UserId);
$o_form->setDefaults(array(
	"userId"      => $s_UserId,
    "userName"    => $userArray['userName'],
    "mail"        => $userArray['mailAddress'],
    "addDateTime" => date("Y/m/d", strtotime($userArray['addDateTime'])),
    "chkDelete"   => ""
    )
);

// 項目セット
$o_form->addElement("header",   "header",      $o_resource->getValue("G04014L001"));
$o_form->addElement("static",   "title",       $o_resource->getValue("G04014L002"));
$o_form->addElement("static",   "userId",      $o_resource->getValue("G04014L003"), "");
$o_form->addElement("static",   "userName",    $o_resource->getValue("G04014L004"), "");
$o_form->addElement("static",   "mail",        $o_resource->getValue("G04014L005"), "");
$o_form->addElement("static",   "addDateTime", $o_resource->getValue("G04014L006"), "");
$o_form->addElement("checkbox", "chkDelete",   $o_resource->getValue("G04014L007"), "", array("class"=>"fs12_black"));

// チェック項目
$o_form->addRule("chkDelete", $o_resource->getValue("G04014M001"), "required");

// 独自チェックルールの定義
//$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

$errorMessage = "";
$pageFlg = 0;
$tplName = "";
// 登録ボタン
if (isset($_POST[submit])) {

    // チェックOK
    if ($o_form->validate()) {
        $pageFlg = 1;
        
        // **************************
        // DB削除処理実装部
        // **************************
		// DELETE
		$service = new ContentsViewService(DIRECTORY_NAME);
		if(!$service->deleteUserByKey($s_UserId)){
			trigger_error("DB Error!!", E_USER_ERROR);
		    exit(-1);
		}
		
    }
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
// ボタンを表示
if ($pageFlg == 0) {
    // 設定画面
    $o_form->addElement("submit", "submit", $o_resource->getValue("G04014L008"), array("class"=>"fs12_black"));
    $o_form->addElement("submit", "back",   $o_resource->getValue("G04014L009"), array("onclick"=>"this.form.action='./userinfo.php'", "class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());

	$labelArray = array(
		"label01"  => $o_resource->getValue("G04014M002"),
		"label02"  => $o_resource->getValue("G04014M003")
   	);
	$o_smarty->assign("labelArray", $labelArray);

	$o_smarty->assign("errorMessage", $errorMessage);

    $tplName = DIRECTORY_NAME."/deleteuser.tpl";

} else {
    // 完了画面（ログアウト処理）
	header("location: ./logout.php");
}
$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：ユーザデータ取得
* 処理詳細：ユーザデータを取得する
*
* @引数： (I) userId	- string  ユーザID
* @戻値： array ユーザ情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getUserData($userId){

	$service = new ContentsViewService(DIRECTORY_NAME);
	
	$data = $service->getUserDataByKey($userId);

	$userArray = array(
		"userName"	  => $data->getUserName(),
		"mailAddress" => $data->getMailAddress(),
		"addDateTime" => $data->getAddDateTime()
	);	
	
	return $userArray;
}
?>