<?php
/**
* imicolorinfotableupdate.php 処理概要：カテゴリ名更新処理(AJAX)
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み

require_once("class/db/service/ImiViewService.class.php");
require_once("class/xml/ReadResource.class.php");						// リソースファイル読込み

require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID,ユーザ種別,意味空間IDを取得
$s_UserId = null;
$s_UserType = null;
$s_ImiSpaceId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId   = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserType = $_SESSION[DIRECTORY_NAME.'_usertype'];
}
if(isset($_SESSION[DIRECTORY_NAME.'_imiSpaceId'])){
	$s_ImiSpaceId = $_SESSION[DIRECTORY_NAME.'_imiSpaceId'];
}else{
	trigger_error("Illegal Access!!", E_USER_ERROR);
	exit(-1);
}
// 編集不可の場合は更新処理を行わない
if(!isset($_SESSION[DIRECTORY_NAME.'_imiSpaceId']) || $_SESSION[DIRECTORY_NAME.'_editMode'] == 0){
	exit(-1);
}

// 更新データオブジェクト作成
$colorInfoData = new ImiColorInfoData();
$colorInfoData->setImiSpaceID($s_ImiSpaceId);
$colorInfoData->setColorID($_POST['colorId']);
$colorInfoData->setCategoryName($_POST['categoryName']);
$colorInfoData->setUpdateDatetime(date('Y/m/d H:i:s'));


$service = new ImiViewService(DIRECTORY_NAME);
if(!$service->updateCategory($colorInfoData)){
	trigger_error("DB Error!!", E_USER_ERROR);
    exit(-1);
}
// カラーIDをレスポンスとして返却
//print($_POST['colorId']);

?>