<?php
/**
* index.php 処理概要：
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/db/service/ImiViewService.class.php");
require_once("class/xml/ReadResource.class.php");						// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}
// セッションからユーザID,ユーザ種別,意味空間IDを取得
$s_UserId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId   = $_SESSION[DIRECTORY_NAME.'_userid'];
}
// レイヤー表示設定画面からの遷移も考慮するためGETメソッドも可とする
$imiSpaceId = null;
if(isset($_POST['imiSpaceId']) || isset($_GET['imiSpaceId'])){
	if(isset($_POST['imiSpaceId'])){
		$imiSpaceId = $_POST['imiSpaceId'];
	}else{
		$imiSpaceId = $_GET['imiSpaceId'];
	}
}
if($imiSpaceId != null){
	// セッションに意味空間ID、編集フラグを設定
	$_SESSION[DIRECTORY_NAME.'_imiSpaceId'] = $imiSpaceId;
	// 編集権限の取得
	if(getImiBaseInfoUser($_SESSION[DIRECTORY_NAME.'_imiSpaceId']) == $s_UserId){
		$_SESSION[DIRECTORY_NAME.'_editMode'] = 1;
	}else{
		$_SESSION[DIRECTORY_NAME.'_editMode'] = 0;
	}
}else{
    header("location: ./imispacemenu.php");
}

$viewMode = "";
if(isset($_POST['viewMode'])){
	$viewMode = $_POST['viewMode'];
}else{
	$viewMode = $_GET['viewMode'];
}


// 編集権限がある場合は閲覧モードをUPDATE
if($_SESSION[DIRECTORY_NAME.'_editMode'] == 1){
	updateViewMode($imiSpaceId, $viewMode);
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

$labelArray = array(
	"label01"  => $o_resource->getValue("G07010L001"),
	"label02"  => $o_resource->getValue("G07010L002")
);
$o_smarty->assign("labelArray", $labelArray);
$o_smarty->assign("viewMode", $viewMode);
$o_smarty->display(DIRECTORY_NAME."/imiindex.tpl");

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：意味空間作成者名を取得
* 処理詳細：意味空間作成者名を取得する
*
* @引数： (I) spaceId	- string  意味空間ID
* @戻値： string 作成者名
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getImiBaseInfoUser($spaceId){
	
	$service = new ImiViewService(DIRECTORY_NAME);
	$recordData = $service->getImiBaseInfoData($spaceId);
	
	return $recordData->getUserID();

}

/**
* 関数概要：表示モード登録処理
* 処理詳細：表示モードを登録する
*
* @引数： (I) spaceId	- string  意味空間ID
*         (I) viewMode	- string  表示モード
* @戻値： string 作成者名
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function updateViewMode($spaceId, $viewMode){

	$service = new ImiViewService(DIRECTORY_NAME);
	if(!$service->updateImiViewMode($spaceId, $viewMode)){
		trigger_error("DB Error!!", E_USER_ERROR);
	    exit(-1);
	}

}

?>