<?php
/**
* imimapcontrol.php 処理概要：意味空間左フレーム（編集モード）表示処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 
require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み

require_once("class/db/service/ImiViewService.class.php");
require_once("class/xml/ReadResource.class.php");						// リソースファイル読込み

require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID,ユーザ種別,意味空間IDを取得
$s_UserId = null;
$s_UserType = null;
$s_ImiSpaceId = null;
$s_ImiEditMode = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId   = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserType = $_SESSION[DIRECTORY_NAME.'_usertype'];
}
if(isset($_SESSION[DIRECTORY_NAME.'_imiSpaceId']) && isset($_SESSION[DIRECTORY_NAME.'_editMode'])){
	$s_ImiSpaceId = $_SESSION[DIRECTORY_NAME.'_imiSpaceId'];
	$s_ImiEditMode = $_SESSION[DIRECTORY_NAME.'_editMode'];
}else{
	trigger_error("Illegal Access!!", E_USER_ERROR);
	exit(-1);
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("memoControlForm", "POST", $_SERVER["PHP_SELF"], "_self");

// 項目セット
$o_form->addElement("header", "header",        $o_resource->getValue("G07110L001"));
$o_form->addElement("header", "newHeader",     $o_resource->getValue("G07110L002"));
$o_form->addElement("text",   "searchNew",     $o_resource->getValue("G07110L003"), array("size"=>"6", "maxlength"=>"6", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("header", "periodHeader",  $o_resource->getValue("G07110L004"));
$o_form->addElement("date",   "searchFromDate", "", array("langage"=>"ja", "format"=>"Y年m月d日～", "minYear"=>(date("Y") - 10), "maxYear"=>(date("Y") + 10), "addEmptyOption"=>"true", "emptyOptionValue"=>"", "emptyOptionText"=>""));
$o_form->addElement("date",   "searchToDate",   "", array("langage"=>"ja", "format"=>"Y年m月d日", "minYear"=>(date("Y") - 10), "maxYear"=>(date("Y") + 10), "addEmptyOption"=>"true", "emptyOptionValue"=>"", "emptyOptionText"=>""));
$o_form->addElement("header", "wordHeader",    $o_resource->getValue("G07110L005"));
$o_form->addElement("text",   "searchWord",    $o_resource->getValue("G07110L006"), array("size"=>"16", "autocomplete"=>"off", "class"=>"fs12_black"));

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "new"              => "",
    "fromDate"         => "",
    "toDate"           => "",
    "word"             => ""
));

// チェック項目はなし

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// ボタンを表示
if ($pageFlg == 0) {
    // メニュー
    $o_form->addElement("button", "reload", $o_resource->getValue("G07110L007"), array("onclick"=>"submitMemoSearchProcess()","class"=>"fs12_black"));
    $o_form->addElement("link",   "layerIndicateSet",  "", "./layerindicateset.php?viewMode=".$_GET['viewMode'], $o_resource->getValue("G07110L008"), array("target"=>"_top","class"=>"fs12_black"));
//categoryname
	// 情報の整理色分け
	$imiCategoryArray = getCategoryColorList($s_ImiSpaceId);
	$o_smarty->assign("imiCategoryArray", $imiCategoryArray);

    $o_form->addElement("link",   "endCategoryMode",  "", "./imilogout.php", $o_resource->getValue("G07110L009"), array("target"=>"_top","class"=>"fs12_black","onclick"=>"if(typeof(top.map.subWindow) != 'undefined' && !top.map.subWindow.closed){top.map.subWindow.close();}"));
	if((isset($_GET['viewMode']) && $_GET['viewMode'] == 0)){
		if($s_ImiEditMode == 0){
			$o_form->addElement("static",   "dispChangeLabel", $o_resource->getValue("G07110L010"));
	    	$o_form->addElement("submit",   "dispChange",      $o_resource->getValue("G07110L011"), array("onclick"=>"if(typeof(top.map.subWindow) != 'undefined' && !top.map.subWindow.closed){top.map.subWindow.close();}document.memoControlForm.action='imiindex.php';document.memoControlForm.target='_top'","class"=>"fs12_black"));
		}else{
			$o_form->addElement("static",   "dispChangeLabel", $o_resource->getValue("G07110L012"));
	    	$o_form->addElement("submit",   "dispChange",      $o_resource->getValue("G07110L013"), array("onclick"=>"if(typeof(top.map.subWindow) != 'undefined' && !top.map.subWindow.closed){top.map.subWindow.close();}document.memoControlForm.action='imiindex.php';document.memoControlForm.target='_top'","class"=>"fs12_black"));
		}
		$o_form->addElement("hidden", "viewMode", "1");
	}else{
		if($s_ImiEditMode == 0){
			$o_form->addElement("static",   "dispChangeLabel", $o_resource->getValue("G07110L014"));
	    	$o_form->addElement("submit",   "dispChange",      $o_resource->getValue("G07110L015"), array("onclick"=>"if(typeof(top.map.subWindow) != 'undefined' && !top.map.subWindow.closed){top.map.subWindow.close();}document.memoControlForm.action='imiindex.php';document.memoControlForm.target='_top'","class"=>"fs12_black"));
		}else{
			$o_form->addElement("static",   "dispChangeLabel", $o_resource->getValue("G07110L016"));
	    	$o_form->addElement("submit",   "dispChange",      $o_resource->getValue("G07110L017"), array("onclick"=>"if(typeof(top.map.subWindow) != 'undefined' && !top.map.subWindow.closed){top.map.subWindow.close();}document.memoControlForm.action='imiindex.php';document.memoControlForm.target='_top'","class"=>"fs12_black"));
		}
		$o_form->addElement("hidden", "viewMode", "0");
	}
	$o_form->addElement("hidden", "imiSpaceId", $s_ImiSpaceId);
	
	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());
	
	$o_smarty->assign("viewMode", $_GET['viewMode']);
	$o_smarty->assign("editMode", $s_ImiEditMode);

	$labelArray = array(
      "label01"      => $o_resource->getValue("G07110L018"),
      "label02"      => $o_resource->getValue("G07110L019"),
      "label03"      => getImiBaseInfoName($s_ImiSpaceId),
      "label04"      => $o_resource->getValue("G07110L020"),
      "label05"      => $o_resource->getValue("G07110L021"),
      "label06"      => $o_resource->getValue("G07110L022"),
      "label07"      => $o_resource->getValue("G07110L023"),
      "label08"      => $o_resource->getValue("G07110L024"),
      "label09"      => $o_resource->getValue("G07110L025"),
      "label10"      => $o_resource->getValue("G07110L026")
	);
	$o_smarty->assign("labelArray", $labelArray);

	$layerMemoTypeArray = getLayerMemoTypeData($s_ImiSpaceId, $s_UserId);
	$o_smarty->assign("layerMemoTypeArray", $layerMemoTypeArray);
	
}
$o_smarty->display(DIRECTORY_NAME."/imimapcontrol.tpl");

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ種類データ取得
* 処理詳細：メモ種類データを取得・整形する
*
* @引数： (I) userid	- string  ユーザID
* @戻値： array メモ種類情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getLayerMemoTypeData($imiSpaceId, $userid) {

	$service = new ImiViewService(DIRECTORY_NAME);
	$recordData = $service->getImiMapControllLayerMemotypeData($imiSpaceId, $userid);

	$layerMemoTypeList = array();
	$memoArrayList = array();
	$layerId = "";
	$layerName ="";
	foreach($recordData as $data){
		// レイヤーIDごとのリストを生成する
		if($layerId != "" && $layerId != $data->getLayerID()){
			$layerArray = array(
							'layerid'  => $layerId, 
							'layername'  => $layerName,
							'userid' => $userid,
							$memoArrayList);
			array_push($layerMemoTypeList, $layerArray);
			$memoArrayList = array();
		}
		$layerId = $data->getLayerID();
		$layerName = $data->getLayerName();
		
		// アイコンタイプでアドレス切り替え
		$iconPath = "";
		if($data->getIconType() == 0){
			$iconPath = "../../img/icon/".$data->getIcon();
		}else{
			$iconPath = "./img/icon/".$data->getIcon();
		}
		$memoArray = array(
			'typeid'   => $data->getMemoTypeID(),
			'typename' => $data->getMemoTypeName(),
			'ico'       => $iconPath,
			'ribbon'   => $data->getRibbonColor(),
			'disptype'   => $data->getListType()
		);
		array_push($memoArrayList, $memoArray);	
	}
	if($layerId != ""){
		$layerArray = array(
						'layerid'  => $layerId, 
						'layername'  => $layerName,
						'userid' => $userid,
					$memoArrayList);
		array_push($layerMemoTypeList, $layerArray);
	}
	
	// ゲストかつCookieが存在した場合はその順にレイヤーを並べ替える
    if (!isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
    // クッキーから表示するレイヤー一覧を取得
	    if (isset($_COOKIE[LAYERPRIORITY])) {
	        $layer_array = explode(",", $_COOKIE[LAYERPRIORITY]);	        
	        // テンポラリにコピー
	        $tempArrayList = $layerMemoTypeList;
			// 初期化	        
	        $layerMemoTypeList = array();
			// クッキーに設定されているレイヤー順に積みなおし
			foreach($layer_array as $cokkieLayerId){
				foreach($tempArrayList as $tempArray){
					if($tempArray['layerid'] == $cokkieLayerId){
						array_push($layerMemoTypeList, $tempArray);
					}
				}
			}
	    }
    }

	return $layerMemoTypeList;	
}

/**
* 関数概要：カテゴリ色情報取得
* 処理詳細：カテゴリ色情報を取得する
*
* @引数： (I) spaceId	- string  意味空間ID
* @戻値： array カテゴリ色情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getCategoryColorList($spaceId){
	
	$service = new ImiViewService(DIRECTORY_NAME);
	$recordData = $service->getImiColorViewData($spaceId);
	
	$memoArrayList = array();
	foreach($recordData as $data){
		
		$memoArray = array(
			'colorid'      => $data->getColorID(),
			'colornumber'  => $data->getColorNumber(),
			'icon'          => "../../img/icon/".$data->getPinIconName(),
			'categoryname' => $data->getCategoryName()
		);
		array_push($memoArrayList, $memoArray);
	}

	return $memoArrayList;
	
}


/**
* 関数概要：意味空間名称報取得
* 処理詳細：意味空間名称を取得する
*
* @引数： (I) spaceId	- string  意味空間ID
* @戻値： string 意味空間名
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getImiBaseInfoName($spaceId){
	
	$service = new ImiViewService(DIRECTORY_NAME);
	$recordData = $service->getImiBaseInfoData($spaceId);
	
	return $recordData->getImiSpaceName();

}
?>