<?php
/**
* imipremod.php 処理概要：情報の整理 新規登録処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/db/service/ImiAdminService.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");


// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザIDを取得
$s_UserId = null;
$s_UserType = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserType = $_SESSION[DIRECTORY_NAME.'_usertype'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("imiPremodForm", "POST", $_SERVER["PHP_SELF"], "_self");

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
	"checkUnderstand"   => ""
	)
);

// smarty インスタンス化
//$o_smarty = new KakikoSmarty();


// 表示項目セット
$o_form->addElement("checkbox", "checkUnderstand", $o_resource->getValue("G07008L003"), "", array("class"=>"fs12_black"));
$labelArray = array(
	"header" => $o_resource->getValue("G07008L001"),
	"title"  => $o_resource->getValue("G07008L001"),
	"colTitle01" => $o_resource->getValue("G07008L002"),
	"titleMessage01" => "「",
	"titleMessage02" => "」".$o_resource->getValue("G07008M001"),
	"information01" => $o_resource->getValue("G07008M002"),
	"information02" => $o_resource->getValue("G07008M003"),
	"information03" => $o_resource->getValue("G07008M004"),
	"imispaceidtmp" => $_POST['imiSpaceId']
	
);

// チェック項目
$o_form->addRule("checkUnderstand",  $o_resource->getValue("G07008M005"), "required");

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

$errorMessage = "";
$errorCheck = "";
$pageFlg = 0;
$tplName = "";
// 登録ボタン
if (isset($_POST[submit])) {
	
    // チェックOK
    if ($o_form->validate()) {
        $pageFlg = 1;
        // **************************
        // DB登録処理実装部
        // **************************
		$service = new ImiAdminService(DIRECTORY_NAME);
		if(!$service->updateImiAdditionMemo($_POST['imiSpaceId'])){
			trigger_error("DB Error!!", E_USER_ERROR);
		    exit(-1);
		}
/*
		// セッションをUPDATE
		$_SESSION[DIRECTORY_NAME.'_username'] = $_POST['userName'];
*/
    }
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
// ボタンを表示
if ($pageFlg == 0) {
$o_form->addElement("submit", "submit", $o_resource->getValue("G07008L004"), array("class"=>"fs12_black"));
$o_form->addElement("submit",  "cancel",  $o_resource->getValue("G07008L005"), array("class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());

	// 意味空間名
	$o_smarty->assign("infoName", getImiBaseInfo($_POST['imiSpaceId']));
	// 項目情報設定
	$o_smarty->assign("labelArray", $labelArray);

	$o_smarty->assign("errorMessage", $errorMessage);
	$o_smarty->assign("errorCheck",   $errorCheck);

    $tplName = DIRECTORY_NAME."/imipremod.tpl";

} else {
	
	header("location: ./imispacemenu.php");
}
$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：意味空間基本情報取得
* 処理詳細：レイヤー名表示に使用するデータを取得する
*
* @引数： (I) $imiSpaceId	- 意味空間ID
* @戻値： 意味空間名
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getImiBaseInfo($imiSpaceId){

	$service = new ImiAdminService(DIRECTORY_NAME);
	$data = $service->getImiBaseInfoData($imiSpaceId);
	
	return $data->getImiSpaceName();
}


?>