<?php
/**
* imispacemenu.php 処理概要：意味空間メニュー画面
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 
require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("class/db/service/ImiAdminService.class.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザIDを取得
$s_UserId = null;
$s_UserType = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId   = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserType = $_SESSION[DIRECTORY_NAME.'_usertype'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// Pager
$data_array = getImiBaseInfo($s_UserId, $s_UserType);

$rowCount = count($data_array);
$params = array(
    "perPage"    => IMISPACELIST_ROW,
    "mode"       => "Jumping",
    "itemData"   => $data_array,
    "totalItem"  => $rowCount,
    "prevImg"    => $o_resource->getValue("G07001L001"),
    "nextImg"    => $o_resource->getValue("G07001L002"),
    "httpMethod" => "POST"
);
$o_page   = Pager::factory($params);
$listdata = $o_page->getPageData();
$o_smarty->assign("listData", $listdata);
$navi     = $o_page->getlinks();
$o_smarty->assign("navi", $navi["all"]);

$labelArray = array(
				"header"      => $o_resource->getValue("G07001L003"),
				"title"       => $o_resource->getValue("G07001L004"),
				"newButton"   => $o_resource->getValue("G07001L005"),

				"modButton"   => $o_resource->getValue("G07001L006"),
				"editButton"  => $o_resource->getValue("G07001L007"),
				"viewButton"  => $o_resource->getValue("G07001L008"),
				"delButton"   => $o_resource->getValue("G07001L009"),
				"takeButton"  => $o_resource->getValue("G07001L010"),
				"label01"     => $o_resource->getValue("G07001L011"),
				"label02"     => $o_resource->getValue("G07001L012"),

				"colTitle01"  => $o_resource->getValue("G07001L013"),
				"colTitle02"  => $o_resource->getValue("G07001L014"),
				"colTitle03"  => $o_resource->getValue("G07001L015"),
				"colTitle04"  => $o_resource->getValue("G07001L016"),
				"colTitle05"  => $o_resource->getValue("G07001L017"),
				"colTitle06"  => $o_resource->getValue("G07001L018"),
				"colTitle07"  => $o_resource->getValue("G07001L019"),
				"labelWarn"   => $o_resource->getValue("G07001L020"),				
				"gomapButton" => $o_resource->getValue("G07001L021"),								
				"rowCount"     => $rowCount,
				"currentStart" => (($o_page->getCurrentPageID() - 1) * IMISPACELIST_ROW) + 1 ,
				"currentEnd"   => (($o_page->getCurrentPageID() - 1) * IMISPACELIST_ROW) + count($listdata)
			);
$o_smarty->assign("labelArray", $labelArray);

$o_smarty->display(DIRECTORY_NAME."/imispacemenu.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：情報の整理メニューデータ取得
* 処理詳細：情報の整理メニューデータを取得する
*
* @引数： (I) userId	- string  ユーザID
*         (I) userType	- string  ユーザ種別
* @戻値： array メニュー情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getImiBaseInfo($userId, $userType){

	$service = new ImiAdminService(DIRECTORY_NAME);
	$dataArray = $service->getImiBaseInfoDataList($userId);

	$menuData = array();
	foreach($dataArray as $record){

		// 権限フラグ
		// 作成者がログインユーザと同一のとき
		// （環境設定ボタン・閲覧編集ボタン・削除ボタン）
		$makeUserFlag = 0;
		if($record->getUserID() == $userId){
			$makeUserFlag = 1;
		}		

		$recordData = array(
			"imiSpaceId"     => $record->getImiSpaceID(),
			"imiSpaceName"   => $record->getImiSpaceName(),
			"authorId"         => $record->getUserID(),
			"userName"       => $record->getUserName(),
			"memoChangeFlag" => $record->getMemoChangeFlg(),
			"memoDeleteWarnFlag" => $record->getMemoDeleteWarnFlg(),
			"viewMode"        => $record->getViewMode(),
			"makeUserFlag"   => $makeUserFlag,
			"userType"       => $userType
			
		);
		array_push($menuData, $recordData);
	}

	return $menuData;
}

?>
