<?php
/**
* layerlist.php 処理概要：レイヤー一覧
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");                          // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("../userauth.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/db/tabledata/LayerData.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み


if(!isset($_SESSION['LOGINMODE'])){
	// SESSIONに「LOGINMODE」を設定
	$_SESSION['LOGINMODE'] = MAP_AUTOLOGIN;
}

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"        => $o_resource->getValue("G04022L001"),
    "colTitle01"      => $o_resource->getValue("G04022L002"),
    "colTitle02"      => $o_resource->getValue("G04022L003"),
    "colTitle03"      => $o_resource->getValue("G04022L004"),
    "colTitle04"      => $o_resource->getValue("G04022L005"),
    "setupEnd"        => $o_resource->getValue("G04022L006"),
    "stsKnd00"        => $o_resource->getValue("G04022L007"),
    "stsKnd01"        => $o_resource->getValue("G04022L008"),
    "stsKnd02"        => $o_resource->getValue("G04022L009"),
    "addnewBtn"       => $o_resource->getValue("G04022L010"),
    "usermainteBtn"   => $o_resource->getValue("G04022L011"),
    "memomainteBtn"   => $o_resource->getValue("G04022L012"),
    "layermainteBtn"  => $o_resource->getValue("G04022L013"),
    "deleteBtn"       => $o_resource->getValue("G04022L014")
);

// SESSIONの内容をクリア
unset($_SESSION[DIRECTORY_NAME.'_newlayer']);
unset($_SESSION[DIRECTORY_NAME.'_mntlayer']);

// 日付クラス
$o_date = new Date();

// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// 状態の変更
if (isset($_POST['chgBtn'])) {
    $rtn = chengeStatus($o_service, $_POST['h_sts'] == KAKIKOMAP_STATUSFLG_ON ? KAKIKOMAP_STATUSFLG_OFF : KAKIKOMAP_STATUSFLG_ON);
    if ($rtn != true) {
    	exit();
    }
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("layerlist", "POST", $_SERVER["PHP_SELF"]);

$errorMessage = "";

// POSTで渡って来た内容を破棄
$_myPOST = $_POST;
unset($_POST['h_layerid'],
      $_POST['h_sts'], 
      $_POST['h_page'],
      $_POST['chgBtn']
      );

if (isset($_myPOST['chgBtn'])) {
    $nowpage = $_myPOST['h_page'];
    $chgsts = TRUE;
} else {
    $nowpage = 1;
    $chgsts = FALSE;
}

// レイヤー一覧情報データ取得
$data_array = getLayerListData($o_service);
if (is_null($data_array)) {
	exit();
}

// Pager
$rowNum = count($data_array);
$params = array(
    "perPage"=>LAYERLIST_ROW,
    "urlVar"=>"list",
    "mode"=>"Jumping",
    "totalItems"=>$rowNum,
    "prevImg"=>$o_resource->getValue("G04022L015"),
    "nextImg"=>$o_resource->getValue("G04022L016"),
    "httpMethod"=>"POST"
);

$o_page = Pager::factory($params);
if ($nowpage > $o_page->numPages()){
    $nowpage = $o_page->numPages();
}
if ($chgsts) {
    $navi = $o_page->getlinks($nowpage);
} else {
    $navi = $o_page->getlinks();
    $nowpage = $o_page->getCurrentPageID();
}

$listData = getListData($data_array, $o_date, ($nowpage - 1) * LAYERLIST_ROW, LAYERLIST_ROW, $rowNum);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("listDatas",    $listData);
$o_smarty->assign("labels",       $label);
$o_smarty->assign("pager",        $navi["all"]);
$o_smarty->assign("nowpage",      $nowpage);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display(DIRECTORY_NAME."/layerlist.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：レイヤー一覧表示情報取得
* 処理詳細：レイヤー管理テーブルより情報を取得するDBアクセスを行う
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： array レイヤーデータオブジェクト型配列
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getLayerListData($o_service) {

	$data = $o_service->getLayerDataList($_SESSION[DIRECTORY_NAME.'_userid']);

	return $data;
}

/**
* 関数概要：レイヤー一覧表示情報取得
* 処理詳細：レイヤー管理テーブルより情報を取得する
*
* @引数： (I) data		- object  データオブジェクト型配列
*         (I) o_date 	- object  日付クラス
*         (I) start  	- integer 開始抽出データ
*         (I) cnt    	- integer 抽出データ数
*         (I) rowNum 	- integer データ件数
* @戻値： array 一覧情報(連想配列)
* @戻値： 一覧情報配列
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getListData($data, $o_date, $start, $cnt, $rowNum){

    $ret_array = array();

    if (count($data) <> 0) {

        for ($i = $start; $i < $start + $cnt; $i++) {
    
            if ($i == $rowNum) break;

			if (is_null($data[$i]))	break;

			$o_date->setDate($data[$i]->getAddDateTime());

			$recode_array = array(
	               "layerid"=>$data[$i]->getLayerID(),
	               "layername"=>$data[$i]->getLayerName(),
	               "layernote"=>urlencode($data[$i]->getLayerNote()),
	               "adddatetime"=>$o_date->format("%Y/%m/%d"),
	               "statusflg"=>$data[$i]->getStatusFlg()
			);
            $ret_array[] = $recode_array;
        }
    }
    return $ret_array;
}

/**
* 関数概要：レイヤー管理テーブル状態更新
* 処理詳細：レイヤー管理テーブルの状態フラグを変更する
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) status		- integer 更新する値
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function chengeStatus($o_service, $status) {

	// マップ配下のレイヤー管理テーブルデータの更新

	// 条件及びNULL等のターゲット設定
	$targetLayerDataObj = new LayerData();

	// 条件
	$targetLayerDataObj->setUserID(WHERE_KEY);
	$targetLayerDataObj->setLayerID(WHERE_KEY);

	// 更新項目ターゲット設定
	$targetLayerDataObj->setStatusFlg(VAL_TARGET);
	$targetLayerDataObj->setUpdateDateTime(VAL_TARGET);

	// 更新項目設定
	$valLayerDataObj = new LayerData();

	// ユーザID(キー)
	$valLayerDataObj->setUserID($_SESSION[DIRECTORY_NAME.'_userid']);
	// レイヤーID(キー)
	$valLayerDataObj->setLayerID($_POST['h_layerid']);
	// 状態フラグ
	$valLayerDataObj->setStatusFlg($status);
	// 更新日時
	$valLayerDataObj->setUpdateDateTime(date('Y/m/d H:i:s'));

	// レイヤーデータ更新処理
	$rtn = $o_service->updateLayerDataByKey($targetLayerDataObj, $valLayerDataObj);

    return $rtn;
}

?>
