<?php
/**
* layerset.php 処理概要：レイヤー設定画面
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");                          // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/db/tabledata/LayerData.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"          => $o_resource->getValue("G04025L001"),
    "topTitle2"         => $o_resource->getValue("G04025L002"),
    "colTitle01"        => $o_resource->getValue("G04025L003"),
    "colTitle02"        => $o_resource->getValue("G04025L004"),
    "colTitle03"        => $o_resource->getValue("G04025L005"),
    "colTitle04"        => $o_resource->getValue("G04025L006"),
    "colTitle05"        => $o_resource->getValue("G04025L007"),
    "colTitle06"        => $o_resource->getValue("G04025L008"),
    "colTitle07"        => $o_resource->getValue("G04025L009"),
    "colTitle08"        => $o_resource->getValue("G04025L010"),
    "colTitle09"        => $o_resource->getValue("G04025L011"),
    "colTitle10"        => $o_resource->getValue("G04025L012"),
    "publiclayerKnd0"   => $o_resource->getValue("G04025L013"),
    "publiclayerKnd1"   => $o_resource->getValue("G04025L014"),
    "publiclayerKnd9"   => $o_resource->getValue("G04025L015"),
    "receiptlayerKnd0"  => $o_resource->getValue("G04025L016"),
    "receiptlayerKnd1"  => $o_resource->getValue("G04025L017"),
    "addattestuserKnd0" => $o_resource->getValue("G04025L018"),
    "addattestuserKnd1" => $o_resource->getValue("G04025L019"),
    "directlinkKnd0"    => $o_resource->getValue("G04025L020"),
    "directlinkKnd1"    => $o_resource->getValue("G04025L021"),
    "x_label"           => $o_resource->getValue("G04025L022"),
    "y_label"           => $o_resource->getValue("G04025L023"),
    "addBtn"            => $o_resource->getValue("G04025L024"),
    "rstBtn"            => $o_resource->getValue("G04025L025"),
    "rtnBtn"            => $o_resource->getValue("G04025L026"),
    "lstBtn"            => $o_resource->getValue("G04025L027"),
    "colTitle11"        => $o_resource->getValue("G04025L028"),
    "colTitle12"        => $o_resource->getValue("G04025L029"),
    "colTitle13"        => $o_resource->getValue("G04025L030"),
    "colTitle14"        => $o_resource->getValue("G04025L031"),
    "colTitle15"        => $o_resource->getValue("G04025L032"),
    "colTitle16"        => $o_resource->getValue("G04025L033"),
    "linkTitle01"       => $o_resource->getValue("G04025L034"),
    "linkTitle02"       => $o_resource->getValue("G04025L035")
);

// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// レイヤー情報の取得
$data = selectRecode($o_service);
if (is_null($data)) {
	exit();
}

// DBからマップテーブル＆マップ詳細テーブルのデータの取得
$mapdata = selectMapRecode($o_service);
if (is_null($mapdata)) {
	exit();
}
// GIS有無区分の設定
$usegis = $mapdata[0]->getUseGIS_BaseMap();
//$usegis = KAKIKOMAP_USEGIS_ON;

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("layerset", "POST", $_SERVER["PHP_SELF"]);

// 座標変換
if (!is_null($data->getStartX()) 
		&& !is_null($data->getStartY())
		&& !is_null($data->getEndX())
		&& !is_null($data->getEndY())) {
	list($x1, $y1, $x2, $y2) = getCoordinates(1, $data->getStartX(), $data->getStartY(), $data->getEndX(), $data->getEndY());
}

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
	"layerid"				=> $data->getLayerID(),
	"h_layerid"				=> $data->getLayerID(),
	"layername"				=> $data->getLayerName(),
	"publiclayer_group"		=> $data->getPublicLayer(),
	"receiptlayer_group"	=> $data->getReceiptLayer(),
	"addattestuser_group"	=> $data->getAddAttestUser(),
	"directlink_group"		=> $data->getDirectLink(),
	"layernote"				=> $data->getLayerNote(),
	"initscale_group"		=> $data->getInitScale(),
	"startx"				=> is_null($x1) ? "" : sprintf("%.6f", $x1),
	"starty"				=> is_null($y1) ? "" : sprintf("%.6f", $y1),
	"endx"					=> is_null($x2) ? "" : sprintf("%.6f", $x2),
	"endy"					=> is_null($y2) ? "" : sprintf("%.6f", $y2),
	"diffx"					=> is_null($data->getDiffX()) ? "" : sprintf("%.6f", $data->getDiffX()),
	"diffy"					=> is_null($data->getDiffY()) ? "" : sprintf("%.6f", $data->getDiffY()),	
	"centerscale_group"		=> $data->getCenterScale()
));

// 項目セット
$o_form->addElement("static",   "layerid",   $label['colTitle01']);
$o_form->addElement("hidden",   "h_layerid", $label['colTitle01']);
$o_form->addElement("text",     "layername", $label['colTitle02'], array("size"=>50, "maxlength"=>32, "autocomplete"=>"off", "class"=>"fs12_black"));
$array_publiclayer[]   =& HTML_QuickForm::createElement("radio", "publiclayer",   null, $label['publiclayerKnd0'], KAKIKOMAP_PUBLICLAYER_GUEST);
$array_publiclayer[]   =& HTML_QuickForm::createElement("radio", "publiclayer",   null, $label['publiclayerKnd1'], KAKIKOMAP_PUBLICLAYER_NORMAL);
$array_publiclayer[]   =& HTML_QuickForm::createElement("radio", "publiclayer",   null, $label['publiclayerKnd9'], KAKIKOMAP_PUBLICLAYER_CLOSED);

$o_form->addGroup($array_publiclayer, "publiclayer_group", $label['colTitle03'], "&nbsp;");
$array_receiptlayer[]  =& HTML_QuickForm::createElement("radio", "receiptlayer",  null, $label['receiptlayerKnd0'], KAKIKOMAP_RECEIPTLAYER_ON);
$array_receiptlayer[]  =& HTML_QuickForm::createElement("radio", "receiptlayer",  null, $label['receiptlayerKnd1'], KAKIKOMAP_RECEIPTLAYER_OFF);
$o_form->addGroup($array_receiptlayer, "receiptlayer_group", $label['colTitle04'], "&nbsp;");
$array_addattestuser[] =& HTML_QuickForm::createElement("radio", "addattestuser", null, $label['addattestuserKnd0'], KAKIKOMAP_ADDATTESTUSER_ON);
$array_addattestuser[] =& HTML_QuickForm::createElement("radio", "addattestuser", null, $label['addattestuserKnd1'], KAKIKOMAP_ADDATTESTUSER_OFF);
$o_form->addGroup($array_addattestuser, "addattestuser_group", $label['colTitle05'], "&nbsp;");
$array_directlink[]    =& HTML_QuickForm::createElement("radio", "directlink",    null, $label['directlinkKnd0'], KAKIKOMAP_DIRECTLINK_PERMIT);
$array_directlink[]    =& HTML_QuickForm::createElement("radio", "directlink",    null, $label['directlinkKnd1'], KAKIKOMAP_DIRECTLINK_NON);
$o_form->addGroup($array_directlink, "directlink_group", $label['colTitle06'], "&nbsp;");
for ($i = 0; $i < count($mapdata); $i++) {
	$array_initscale[]   =& HTML_QuickForm::createElement("radio", "initscale",   null, htmlspecialchars($mapdata[$i]->getListName_MapDetail()), $mapdata[$i]->getMapNumber_MapDetail());
	$array_centerscale[]   =& HTML_QuickForm::createElement("radio", "centerscale",   null, htmlspecialchars($mapdata[$i]->getListName_MapDetail()), $mapdata[$i]->getMapNumber_MapDetail());
}
$o_form->addGroup($array_initscale, "initscale_group", $label['colTitle11']."<br>&nbsp;&nbsp;&nbsp;".$label['colTitle12'], "&nbsp;");
$o_form->addElement("text",     "startx",    $label['colTitle07'], array("size"=>25, "autocomplete"=>"off", "class"=>"fs12_black", "readonly"));
$o_form->addElement("text",     "starty",    $label['colTitle08'], array("size"=>25, "autocomplete"=>"off", "class"=>"fs12_black", "readonly"));
$o_form->addElement("text",     "endx",      $label['colTitle07'], array("size"=>25, "autocomplete"=>"off", "class"=>"fs12_black", "readonly"));
$o_form->addElement("text",     "endy",      $label['colTitle09'], array("size"=>25, "autocomplete"=>"off", "class"=>"fs12_black", "readonly"));
$o_form->addElement("textarea", "layernote", $label['colTitle10'], array("cols"=>40, "rows"=>5, "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addGroup($array_centerscale, "centerscale_group", $label['colTitle13']."<br>&nbsp;&nbsp;&nbsp;".$label['colTitle14'], "&nbsp;");
$o_form->addElement("text",     "diffx",    $label['colTitle15'], array("size"=>25, "autocomplete"=>"off", "class"=>"fs12_black", "readonly"));
$o_form->addElement("text",     "diffy",    $label['colTitle16'], array("size"=>25, "autocomplete"=>"off", "class"=>"fs12_black", "readonly"));
$o_form->addElement("link", "helpInitial", null, "javascript:open_subwindow_nonsubmit('./layergishelper.php?settingmode=0&layerId=".$data->getLayerID()."','subwindow',700,650)", $label['linkTitle01']);
$o_form->addElement("link", "helpCenter",  null, "javascript:open_subwindow_nonsubmit('./layergishelper.php?settingmode=1&layerId=".$data->getLayerID()."','subwindow',700,650)", $label['linkTitle02']);

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

// チェック項目
$o_form->addRule("layername",	$o_resource->getValue("G04025M001"), "required", null);
//$o_form->addRule("layername",	$o_resource->getValue("G04025M002"), "maxlength_valid",	128);
//$o_form->addRule("startx",		$o_resource->getValue("G04025M003"), "required", null);
$o_form->addRule("startx",		$o_resource->getValue("G04025M004"), "numeric",  null);
//$o_form->addRule("starty",		$o_resource->getValue("G04025M005"), "required", null);
$o_form->addRule("starty",		$o_resource->getValue("G04025M006"), "numeric",  null);
//$o_form->addRule("endx",		$o_resource->getValue("G04025M007"), "required", null);
$o_form->addRule("endx",		$o_resource->getValue("G04025M008"), "numeric",  null);
//$o_form->addRule("endy",		$o_resource->getValue("G04025M009"), "required", null);
$o_form->addRule("endy",		$o_resource->getValue("G04025M010"), "numeric",  null);
if ($usegis == KAKIKOMAP_USEGIS_ON) {
	$o_form->addRule("diffx",		$o_resource->getValue("G04025M011"), "numeric",  null);
	$o_form->addRule("diffy",		$o_resource->getValue("G04025M012"), "numeric",  null);
} else {
	$o_form->addRule("initscale_group",	  $o_resource->getValue("G04025M013"), "required", null);
	$o_form->addRule("centerscale_group", $o_resource->getValue("G04025M014"), "required", null);
}

$errorMessage = "";
$pageFlg = 0;

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        if (updateRecode($o_service, $usegis) == true) {
            $pageFlg = 1;
        }
    }
}

// ボタンを表示
if ($pageFlg == 0) {
    $o_form->addElement("header", "header", $label['topTitle']);
    $o_form->addElement("submit", "run", $label['addBtn'], array("class"=>"fs12_black"));
    $o_form->addElement("reset", "reset", $label['rstBtn'], array("class"=>"fs12_black"));
    $o_form->addElement("button", "return", $label['rtnBtn'], array("onclick"=>"location.href='layerlist.php'", "class"=>"fs12_black"));
    $tplarray = array();
    $tplName = DIRECTORY_NAME."/layerset.tpl";
} else {
    // 完了画面
    $listdatas = array();
    $listdatas[] = array("rowname" => $label['colTitle01'], "rowdata" => htmlspecialchars($_POST['h_layerid']));
    $listdatas[] = array("rowname" => $label['colTitle02'], "rowdata" => htmlspecialchars($_POST['layername']));
    $listdatas[] = array("rowname" => $label['colTitle03'], "rowdata" => htmlspecialchars($_POST['publiclayer_group']['publiclayer']==KAKIKOMAP_PUBLICLAYER_GUEST?$label['publiclayerKnd0']:
                                                                           ($_POST['publiclayer_group']['publiclayer']==KAKIKOMAP_PUBLICLAYER_NORMAL?$label['publiclayerKnd1']:$label['publiclayerKnd9'])));
    $listdatas[] = array("rowname" => $label['colTitle04'], "rowdata" => htmlspecialchars($_POST['receiptlayer_group']['receiptlayer']==KAKIKOMAP_RECEIPTLAYER_ON?$label['receiptlayerKnd0']:$label['receiptlayerKnd1']));
    $listdatas[] = array("rowname" => $label['colTitle05'], "rowdata" => htmlspecialchars($_POST['addattestuser_group']['addattestuser']==KAKIKOMAP_ADDATTESTUSER_ON?$label['addattestuserKnd0']:$label['addattestuserKnd1']));
    $listdatas[] = array("rowname" => $label['colTitle06'], "rowdata" => htmlspecialchars($_POST['directlink_group']['directlink']==KAKIKOMAP_DIRECTLINK_PERMIT?$label['directlinkKnd0']:$label['directlinkKnd1']));
	if ($usegis == KAKIKOMAP_USEGIS_OFF) {
		for ($i = 0; $i < count($mapdata); $i++) {
			if ($_POST['initscale_group']['initscale'] == $mapdata[$i]->getMapNumber_MapDetail()) {
				$listdatas[] = array("rowname" => $label['colTitle11']."<br>&nbsp;&nbsp;&nbsp;".$label['colTitle12'], "rowdata" => htmlspecialchars($mapdata[$i]->getListName_MapDetail()));
				break;
			}
		}
	}

	// 座標変換
	if ($_POST['startx'] != "" 
			&& $_POST['starty'] != ""
			&& $_POST['endx'] != ""
			&& $_POST['endy'] != "") {
		list($x1, $y1, $x2, $y2) = getCoordinates(1, $_POST['startx'], $_POST['starty'], $_POST['endx'], $_POST['endy']);
	}
	if ($usegis == KAKIKOMAP_USEGIS_ON) {
	    $listdatas[] = array("rowname" => $label['colTitle08'], "rowdata" => htmlspecialchars($label['x_label'].$x1));
	    $listdatas[] = array("rowname" => $label['colTitle08'], "rowdata" => htmlspecialchars($label['y_label'].$y1));
	    $listdatas[] = array("rowname" => $label['colTitle09'], "rowdata" => htmlspecialchars($label['x_label'].$x2));
	    $listdatas[] = array("rowname" => $label['colTitle09'], "rowdata" => htmlspecialchars($label['y_label'].$y2));
	    $listdatas[] = array("rowname" => $label['colTitle16'], "rowdata" => htmlspecialchars($label['x_label'].$_POST['diffx']));
	    $listdatas[] = array("rowname" => $label['colTitle16'], "rowdata" => htmlspecialchars($label['y_label'].$_POST['diffy']));
	} else {
		for ($i = 0; $i < count($mapdata); $i++) {
			if ($_POST['centerscale_group']['centerscale'] == $mapdata[$i]->getMapNumber_MapDetail()) {
				$listdatas[] = array("rowname" => $label['colTitle13']."<br>&nbsp;&nbsp;&nbsp;".$label['colTitle14'], "rowdata" => htmlspecialchars($mapdata[$i]->getListName_MapDetail()));
				break;
			}
		}
	}
    $listdatas[] = array("rowname" => $label['colTitle10'], "rowdata" => htmlspecialchars($_POST['layernote']));
    $tplarray    = array(
                          "title"         => $label['topTitle2'],
                          "fintype"       => "1",
                          "infomessage"   => $o_resource->getValue("G04025M016"),
                          "tablewidth"    => "550",
                          "tdwidth"       => "150",
                          "listdatas"     => $listdatas,
                          "buttonname"    => $label['lstBtn'],
                          "buttononclick" => "location.href='layerlist.php'"
                         );
    $tplName = DIRECTORY_NAME."/commonfin.tpl";
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("infoMsg01",    $o_resource->getValue("G04025M015"));
$o_smarty->assign("x_label",      $label['x_label']);
$o_smarty->assign("y_label",      $label['y_label']);
$o_smarty->assign("tplarray",     $tplarray);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->assign("usegis",     $usegis);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：レイヤー情報設定表示情報取得
* 処理詳細：レイヤーテーブルより該当の情報を取得する
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： array   DBエラーの場合はnull
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function selectRecode($o_service) {

	$data = $o_service->getLayerInfoData(
							$_SESSION[DIRECTORY_NAME.'_userid'], $_POST['h_layerid']);

	return $data;

}

/**
* 関数概要：マップデータマップ詳細データ情報取得
* 処理詳細：マップテーブル及びマップ詳細テーブルより該当の情報を取得する
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： array   DBエラーの場合はnull
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @更新内容：
*/
function selectMapRecode($o_service) {

	$data = $o_service->getLayerInfoMapDetailData();

	return $data;

}

/**
* 関数概要：レイヤー情報設定内容更新
* 処理詳細：入力された内容をデータベースへ更新する
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) usegis        - GIS使用有無区分
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function updateRecode($o_service, $usegis) {

	// マップ配下のレイヤー管理テーブルデータの更新

	// 条件及びNULL等のターゲット設定
	$targetLayerDataObj = new LayerData();

	// 条件
	$targetLayerDataObj->setUserID(WHERE_KEY);
	$targetLayerDataObj->setLayerID(WHERE_KEY);

	// 更新項目ターゲット設定
	$targetLayerDataObj->setLayerName(VAL_TARGET);
	$targetLayerDataObj->setLayerNote(VAL_TARGET);
	$targetLayerDataObj->setPublicLayer(VAL_TARGET);
	$targetLayerDataObj->setReceiptLayer(VAL_TARGET);
	$targetLayerDataObj->setAddAttestUser(VAL_TARGET);
	$targetLayerDataObj->setDirectLink(VAL_TARGET);
	$targetLayerDataObj->setStartX(VAL_TARGET);
	$targetLayerDataObj->setStartY(VAL_TARGET);
	$targetLayerDataObj->setEndX(VAL_TARGET);
	$targetLayerDataObj->setEndY(VAL_TARGET);
	if ($usegis == KAKIKOMAP_USEGIS_ON) {
		$targetLayerDataObj->setDiffX(VAL_TARGET);
		$targetLayerDataObj->setDiffY(VAL_TARGET);
	} else if ($usegis == KAKIKOMAP_USEGIS_OFF) {
		$targetLayerDataObj->setInitScale(VAL_TARGET);
		$targetLayerDataObj->setCenterScale(VAL_TARGET);
	}
	$targetLayerDataObj->setUpdateDateTime(VAL_TARGET);

	// 更新項目設定
	$valLayerDataObj = new LayerData();

	// ユーザID(キー)
	$valLayerDataObj->setUserID($_SESSION[DIRECTORY_NAME.'_userid']);
	// レイヤーID(キー)
	$valLayerDataObj->setLayerID($_POST['h_layerid']);
	// レイヤー名称
	$valLayerDataObj->setLayerName($_POST['layername']);
	// レイヤーの説明
    if ($_POST['layernote'] != "") {
	    $valLayerDataObj->setLayerNote($_POST['layernote']);
	} else {
	    $valLayerDataObj->setLayerNote(NULL_CHAR);
	}
	// レイヤー公開区分
	$valLayerDataObj->setPublicLayer($_POST['publiclayer_group']['publiclayer']);
	// レイヤー受付区分
	$valLayerDataObj->setReceiptLayer($_POST['receiptlayer_group']['receiptlayer']);
	// ユーザ登録認証区分
	$valLayerDataObj->setAddAttestUser($_POST['addattestuser_group']['addattestuser']);
	// ダイレクトリンク区分
	$valLayerDataObj->setDirectLink($_POST['directlink_group']['directlink']);

    // 座標変換
    if ($_POST['startx'] != ""
    		&& $_POST['starty'] != ""
    		&& $_POST['endx'] != ""
    		&& $_POST['endy'] != "") {
    	list($_POST['startx'], $_POST['starty'], $_POST['endx'], $_POST['endy']) = getCoordinates(0, $_POST['startx'], $_POST['starty'], $_POST['endx'], $_POST['endy']);

		// 始点X
		$valLayerDataObj->setStartX($_POST['startx']);
		// 始点Y
		$valLayerDataObj->setStartY($_POST['starty']);
		// 終点X
		$valLayerDataObj->setEndX($_POST['endx']);
		// 終点Y
		$valLayerDataObj->setEndY($_POST['endy']);
    } else {
		// 始点X
		$valLayerDataObj->setStartX(NULL_CHAR);
		// 始点Y
		$valLayerDataObj->setStartY(NULL_CHAR);
		// 終点X
		$valLayerDataObj->setEndX(NULL_CHAR);
		// 終点Y
		$valLayerDataObj->setEndY(NULL_CHAR);    
    }

	if ($usegis == KAKIKOMAP_USEGIS_ON) {
		if ($_POST['diffx'] != "" && $_POST['diffy'] != "") {
			// 差分X
			$valLayerDataObj->setDiffX($_POST['diffx']);
			// 差分Y
			$valLayerDataObj->setDiffY($_POST['diffy']);
		} else {
			// 差分X
			$valLayerDataObj->setDiffX(NULL_CHAR);
			// 差分Y
			$valLayerDataObj->setDiffY(NULL_CHAR);
		}

	} else if ($usegis == KAKIKOMAP_USEGIS_OFF) {
		// 初期スケール
		$valLayerDataObj->setInitScale($_POST['initscale_group']['initscale']);
		// 中心スケール
		$valLayerDataObj->setCenterScale($_POST['centerscale_group']['centerscale']);
	}

	// 更新日時
	$valLayerDataObj->setUpdateDateTime(date('Y/m/d H:i:s'));

	// レイヤーデータ更新処理
	$rtn = $o_service->updateLayerDataByKey($targetLayerDataObj, $valLayerDataObj);

    return $rtn;

}

?>
