<?php
/**
* layeruserlist.php 処理概要：レイヤーユーザ一覧
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/

require_once("../DefineDirectryName.php");                          // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/db/tabledata/LayerUserData.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"     => $o_resource->getValue("G04037L001"),
    "subTitle"     => $o_resource->getValue("G04037L002"),
    "colTitleA01"  => $o_resource->getValue("G04037L003"),
    "colTitleA02"  => $o_resource->getValue("G04037L004"),
    "colTitleA03"  => $o_resource->getValue("G04037L005"),
    "colTitleA04"  => $o_resource->getValue("G04037L006"),
    "colTitleB01"  => $o_resource->getValue("G04037L007"),
    "colTitleB02"  => $o_resource->getValue("G04037L008"),
    "colTitleB03"  => $o_resource->getValue("G04037L009"),
    "colTitleB04"  => $o_resource->getValue("G04037L010"),
    "colTitleB05"  => $o_resource->getValue("G04037L011"),
    "colTitleC01"  => $o_resource->getValue("G04037L012"),
    "colTitleC02"  => $o_resource->getValue("G04037L013"),
    "colTitleC03"  => $o_resource->getValue("G04037L014"),
    "colTitleC04"  => $o_resource->getValue("G04037L015"),
    "addUser"      => $o_resource->getValue("G04037L016"),
    "addMemo"      => $o_resource->getValue("G04037L017"),
    "stsKnd00"     => $o_resource->getValue("G04037L018"),
    "stsKnd01"     => $o_resource->getValue("G04037L019"),
    "stsKnd02"     => $o_resource->getValue("G04037L020"),
    "listTitle1"   => $o_resource->getValue("G04037L021"),
    "listTitle2"   => $o_resource->getValue("G04037L022"),
    "newBtn"       => $o_resource->getValue("G04037L023"),
    "delBtn"       => $o_resource->getValue("G04037L024"),
    "athBtn"       => $o_resource->getValue("G04037L025"),
    "layerList"    => $o_resource->getValue("G04037L026"),
    "setupEnd"     => $o_resource->getValue("G04037L027")
);

// 日付クラス
$o_date = new Date();

// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// 状態の変更
if (isset($_POST['chgBtn'])) {
    $rtn = chengeStatus($o_service, 
    		$_POST['h_sts'] == KAKIKOMAP_STATUSFLG_ON 
    			? KAKIKOMAP_STATUSFLG_OFF : KAKIKOMAP_STATUSFLG_ON);
    if ($rtn != true) {
    	exit();
    }
}
if (isset($_POST['athBtn'])) {
    $rtn = chengeStatus($o_service, 0);
    if ($rtn != true) {
    	exit();
    }
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("userlist", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "layerid"   => $_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'],
    "layername" => $_SESSION[DIRECTORY_NAME.'_newlayer']['layername'],
    "layernote" => nl2br($_SESSION[DIRECTORY_NAME.'_newlayer']['layernote']),
    "statusflg" => $_SESSION[DIRECTORY_NAME.'_newlayer']['statusflg']==KAKIKOMAP_STATUSFLG_ON?$label['stsKnd00']:$label['stsKnd02']
));

// 項目セット
$o_form->addElement("static", "layerid",   $label['colTitleA01'], array("size"=>"16", "maxlength"=>"16",  "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("static", "layername", $label['colTitleA02'], array("size"=>"50", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("static", "layernote", $label['colTitleA03'], array("cols"=>"40", "rows"=>"5",        "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("static", "statusflg", $label['colTitleA04'], array("value"=>$statusflg==KAKIKOMAP_STATUSFLG_ON?$label['stsKnd00']:$label['stsKnd02'], "class"=>"fs12_black"));

$errorMessage = "";

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // このページはチェックがありません
    }
}

// POSTで渡って来た内容を破棄
$_myPOST = $_POST;
unset($_POST['h_userid'],
      $_POST['h_sts'], 
      $_POST['h_page1'], 
      $_POST['h_page2'], 
      $_POST['chgBtn'],
      $_POST['athBtn']
      );

//-----------------------------//
//* 認証済みリストのPeger処理 *//
//-----------------------------//

if (isset($_myPOST['h_page1'])) {
    $nowpage1 = $_myPOST['h_page1'];
    $nowpage1 = $nowpage1==0?1:$nowpage1;
    $chgsts1 = TRUE;
} else {
    $nowpage1 = 1;
    $chgsts1 = FALSE;
}

// ユーザ一覧データ取得(認証済み)
$data_array = getUserListData($o_service, 0);
if (is_null($data_array)) {
	exit();
}

// Pager
$rowNum1 = count($data_array);
$params1 = array(
    "perPage"=>LAYERUSERLIST1_ROW,
    "urlVar"=>"list1",
    "mode"=>"Jumping",
    "totalItems"=>$rowNum1,
    "prevImg"=>$o_resource->getValue("G04037L028"),
    "nextImg"=>$o_resource->getValue("G04037L029"),
    "httpMethod"=>"POST"
);

$o_page1 = Pager::factory($params1);
if ($nowpage1 > $o_page1->numPages()){
    $nowpage1 = $o_page1->numPages();
}
if ($chgsts1) {
    $navi1 = $o_page1->getlinks($nowpage1);
} else {
    $navi1 = $o_page1->getlinks();
    $nowpage1 = $o_page1->getCurrentPageID();
}
$listData1 = getListData($data_array, $o_date, ($nowpage1 - 1) * LAYERUSERLIST1_ROW, LAYERUSERLIST1_ROW, $rowNum1);

//-----------------------------//
//* 許可待ちリストのPeger処理 *//
//-----------------------------//

if (isset($_myPOST['h_page2'])) {
    $nowpage2 = $_myPOST['h_page2'];
    $nowpage2 = $nowpage2==0?1:$nowpage2;
    $chgsts2 = TRUE;            // ステータスを変更するボタンが押された
} else {
    $nowpage2 = 1;
    $chgsts2 = FALSE;
}

// ユーザ一覧データ取得(許可待ち)
$data_array = getUserListData($o_service, 1);
if (is_null($data_array)) {
	exit();
}

// Pager
$rowNum2 = count($data_array);
$params2 = array(
    "perPage"=>LAYERUSERLIST2_ROW,
    "urlVar"=>"list2",
    "mode"=>"Jumping",
    "totalItems"=>$rowNum2,
    "prevImg"=>$o_resource->getValue("G04037L030"),
    "nextImg"=>$o_resource->getValue("G04037L031"),
    "httpMethod"=>"POST"
);

$o_page2 = Pager::factory($params2);
if ($nowpage2 > $o_page2->numPages()){
    $nowpage2 = $o_page2->numPages();
}
if ($chgsts2) {
    $navi2 = $o_page2->getlinks($nowpage2);
} else {
    $navi2 = $o_page2->getlinks();
    $nowpage2 = $o_page2->getCurrentPageID();
}
$listData2 = getListData($data_array, $o_date, ($nowpage2 - 1) * LAYERUSERLIST2_ROW, LAYERUSERLIST2_ROW, $rowNum2);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("listDatas1",   $listData1);
$o_smarty->assign("listDatas2",   $listData2);
$o_smarty->assign("labels",       $label);
$o_smarty->assign("infoMsg01",    $o_resource->getValue("G04037M001"));
$o_smarty->assign("pager1",       $navi1["all"]);
$o_smarty->assign("pager2",       $navi2["all"]);
$o_smarty->assign("nowpage1",     $nowpage1);
$o_smarty->assign("nowpage2",     $nowpage2);
$o_smarty->assign("serchUser",    $serchUser);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display(DIRECTORY_NAME."/layeruserlist.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：ユーザ一覧表示情報取得
* 処理詳細：レイヤーユーザ管理テーブルより情報を取得するクエリーをセット
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) knd			- integer 取得区分(0:認証済み,1:許可待ち)
* @戻値： object レコードセット
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getUserListData($o_service, $knd) {

	$data = $o_service->getUserDataList($_SESSION[DIRECTORY_NAME.'_userid'], 
				$_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'], $knd, "");

	return $data;
}

/**
* 関数概要：ユーザ一覧表示情報取得
* 処理詳細：一覧表示用データの抽出処理
*
* @引数： (I) data		- object  データオブジェクト型配列
*         (I) o_date	- object  日付クラス
*         (I) start		- integer 開始抽出データ
*         (I) cnt		- integer 抽出データ数
*         (I) rowNum	- integer データ件数* @戻値： array 一覧情報(連想配列)
* @戻値： 一覧情報配列
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getListData($data, $o_date, $start, $cnt, $rowNum) {

	$ret_array = array();

	if (count($data) <> 0) {

		for ($i = $start; $i < $start + $cnt; $i++) {
    
			if ($i == $rowNum) break;

			if (is_null($data[$i]))	break;

			$o_date->setDate($data[$i]->getAddDateTime());

			$recode_array = array(
				"userid"=>$data[$i]->getUserID(),
				"username"=>$data[$i]->getUserName(),
				"mailaddress"=>$data[$i]->getMailAddress(),
				"adddatetime"=>$o_date->format("%Y/%m/%d"),
				"statusflg"=>$data[$i]->getStatusFlg()
			);
			$ret_array[] = $recode_array;
		}
	}
	return $ret_array;
}

/**
* 関数概要：レイヤーユーザ管理テーブル状態更新
* 処理詳細：レイヤーユーザ管理テーブルの状態フラグを変更する
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) status		- integer 更新する値
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function chengeStatus($o_service, $status) {

	// マップ配下のレイヤーユーザ管理テーブルデータの更新

	// 条件及びNULL等のターゲット設定
	$targetLayerUserDataObj = new LayerUserData();

	// 条件
	$targetLayerUserDataObj->setUserID(WHERE_KEY);
	$targetLayerUserDataObj->setLayerID(WHERE_KEY);

	// 更新項目ターゲット設定
	$targetLayerUserDataObj->setStatusFlg(VAL_TARGET);

	// 更新項目設定
	$valLayerUserDataObj = new LayerUserData();

	// ユーザID(キー)
	$valLayerUserDataObj->setUserID($_POST['h_userid']);
	// レイヤーID(キー)
	$valLayerUserDataObj->setLayerID($_SESSION[DIRECTORY_NAME.'_newlayer']['layerid']);
	// 状態フラグ
	$valLayerUserDataObj->setStatusFlg($status);

	// レイヤーユーザデータ更新処理
	$rtn = $o_service->updateLayerUserDataByKey($targetLayerUserDataObj, $valLayerUserDataObj);

    return $rtn;
}

?>
