<?php
/**
* userregist.php 処理概要：ユーザ登録
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");                          // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}

require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/db/tabledata/LayerUserData.class.php");
require_once("class/db/tabledata/UserData.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

require_once("class/common/KakikoPassword.class.php");
require_once("class/mail/KakikoMail.class.php");                   // メール送信クラス

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"    => $o_resource->getValue("G04018L001"),
    "colTitle01"  => $o_resource->getValue("G04018L002"),
    "colTitle02"  => $o_resource->getValue("G04018L003"),
    "colTitle03"  => $o_resource->getValue("G04018L004"),
    "colTitle04"  => $o_resource->getValue("G04018L005"),
    "addBtn"      => $o_resource->getValue("G04018L006"),
    "rstBtn"      => $o_resource->getValue("G04018L007"),
    "clsBtn"      => $o_resource->getValue("G04018L008")
);

// SESSION内容取得
$session_layerid   = isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid'])  ?$_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid']  :$_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'];
$session_layername = isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layername'])?$_SESSION[DIRECTORY_NAME.'_mntlayer']['layername']:$_SESSION[DIRECTORY_NAME.'_newlayer']['layername'];


// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("userregist", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "layername"    => $session_layername,
    "userid"       => "",
    "mailaddress"  => "",
    "mailaddress2" => ""
));

// 項目セット
$o_form->addElement("static",   "layername",    $label['colTitle01']);
$o_form->addElement("text",     "userid",       $label['colTitle02'], array("size"=>"16", "maxlength"=>"16",  "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text",     "mailaddress",  $label['colTitle03'], array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text",     "mailaddress2", $label['colTitle04'], array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs12_black"));

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

// チェック項目
$o_form->addRule("userid",			$o_resource->getValue("G04018M001"),	"required");
$o_form->addRule("userid",			$o_resource->getValue("G04018M002"),	"regex", 			"/^[a-zA-Z0-9]+$/");
$o_form->addRule("userid",			$o_resource->getValue("G04018M003"),	"maxlength_valid",	16);
$o_form->addRule("mailaddress",		$o_resource->getValue("G04018M004"),	"required");
$o_form->addRule("mailaddress",		$o_resource->getValue("G04018M005"), 	"email");
$o_form->addRule("mailaddress",		$o_resource->getValue("G04018M006"), 	"maxlength_valid",	128);
$o_form->addRule("mailaddress2",	$o_resource->getValue("G04018M007"), 	"required");
$o_form->addRule("mailaddress2",	$o_resource->getValue("G04018M008"), 	"email");
$o_form->addRule("mailaddress2",	$o_resource->getValue("G04018M009"), 	"maxlength_valid",	128);
$o_form->addRule( array("mailaddress","mailaddress2"), $o_resource->getValue("G04018M010"), "compare", NULL);

$errorMessage = "";
$pageFlg = 0;
$provpass = "";

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // 入力データチェック
        $rtn = checkInputdata($o_service);
        if ($rtn == true) {
            if (insertRecode($o_service) == true) {
                sendMail($o_resource);
                $pageFlg = 1;
            }
        } else if ($rtn == false) {
        	$errorMessage = $o_resource->getValue("G04018M012");
        }
    }
}

// ボタンを表示
if ($pageFlg == 0) {
    // 登録画面
    $o_form->addElement("header",   "header",    $label['topTitle']);
    $o_form->addElement("submit",   "run",       $label['addBtn'],      array("class"=>"fs12_black"));
    $o_form->addElement("reset",    "reset",     $label['rstBtn'],      array("class"=>"fs12_black"));
    $o_form->addElement("button",   "close",     $label['clsBtn'],      array("onclick"=>"close_window();", "class"=>"fs12_black"));
    $tplName = DIRECTORY_NAME."/userregist.tpl";
} else {
    // 完了画面
    $tplName = "windowclose.tpl";
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("infoMsg01",    $o_resource->getValue("G04018M011"));
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：レイヤーユーザ登録前のデータチェック
* 処理詳細：レイヤーユーザテーブルの存在チェック等
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function checkInputdata($o_service) {

	$rtn = $o_service->checkUserDataByKey($_POST['userid']);

    return $rtn;
}

/**
* 関数概要：ユーザ登録処理
* 処理詳細：ユーザ・レイヤーユーザを新規に登録する
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function insertRecode($o_service) {

    global $provpass;        // 仮パスワード

	//SESSION内容格納
	$session_layerid = isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid']) 
								? $_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid'] 
									: $_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'];

	// ユーザデータ作成
	$userdata = new UserData();

	// 仮パスワード発行処理
    $p_obj = new KakikoPassword();
    $p_obj->extension_array = array(".", "-", "_");
    $p_obj->publicate(7, KAKIKO_PASSWORD_NUMBER);

	$userdata->setUserID($_POST['userid']);
	$userdata->setUserType(KAKIKOMAP_USERTYPE_NORMAL);
	$userdata->setMailAddress($_POST['mailaddress']);
	$userdata->setUserName("--");
	$provpass = $p_obj->out_string;
	$userdata->setPassword(md5($p_obj->out_string));
	$userdata->setStatusFlg(KAKIKOMAP_STATUSFLG_ON);
	$userdata->setAddDateTime(date('Y/m/d H:i:s'));
	$userdata->setUpdateDateTime(date('Y/m/d H:i:s'));

	//レイヤーユーザデータ作成
	$layeruserdata = new LayerUserData();

	$layeruserdata->setUserID($_POST['userid']);
	$layeruserdata->setLayerID($session_layerid);
	$layeruserdata->setStatusFlg(KAKIKOMAP_STATUSFLG_ON);
	$layeruserdata->setAddDateTime(date('Y/m/d H:i:s'));

	// ユーザ登録処理
	$rtn = $o_service->insertUser($userdata, $layeruserdata);

    return $rtn;

}

/**
* 関数概要：メール送信処理
* 処理詳細：登録ユーザに対して登録完了メールを送信する
*
* @引数： (I) o_resource   - object リソースクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function sendMail($o_resource) {

    global $provpass;           // 仮パスワード
    global $session_layername;  // レイヤー名称

    // -----------------------
    // メール送信用設定
    // -----------------------
    // メール種類
    $mode        = "smtp";
    // 送信先アドレス
    $toAddress   = $_POST['mailaddress'];
    // 送信先名称
    $toName      = $_POST['userid'].$o_resource->getValue("G04018M014");
    // 送信元アドレス
    $fromAddress = ereg_replace("\n|\r", "", $_SESSION['_auth'.DIRECTORY_NAME.'usersession']['data']['mailaddress']);
    // 送信元名称
    $fromName    = $o_resource->getValue("G04018M015");
    // 件名
    $subject     = $o_resource->getValue("G04018M016");
    // 本文
    $message     = $_POST['userid'].$o_resource->getValue("G04018M017")."\n"
                  ."\n"
                  .str_replace("@@LAYER_NAME@@", $session_layername, $o_resource->getValue("G04018M018"))."\n"
                  .$o_resource->getValue("G04018M019")."\n"
                  ."\n"
                  .$o_resource->getValue("G04018M020").$_POST['userid']."\n"
                  .$o_resource->getValue("G04018M021").$provpass."\n"
                  .$o_resource->getValue("G04018M022").$_POST['mailaddress']."\n"
                  .$o_resource->getValue("G04018M023").$session_layername."\n"
                  ."\n"
                  .$o_resource->getValue("G04018M024")."\n"
                  .$o_resource->getValue("G04018M025")."\n"
                  .getProtocol().$_SERVER["SERVER_NAME"].dirname(dirname($_SERVER["PHP_SELF"]))."/index.php\n"
                  .$o_resource->getValue("G04018M026")."\n"
                  .$o_resource->getValue("G04018M027")."\n"
                  ."\n"
                  ."\n"
                  .$o_resource->getValue("G04018M028")."\n";

    
    // メール送信処理
    $o_email = new KakikoMail();
    $mailitems = array(
                        "ToAddress"   => $toAddress,    //送信先アドレス
                        "ToName"      => $toName,       //送信先名称
                        "FromAddress" => $fromAddress,  //送信元アドレス
                        "FromName"    => $fromName,     //送信元名称
                        "ReplyTo"     => $fromAddress,  //返信先アドレス
                        "Subject"     => $subject,      //件名
                        "Message"     => $message,      //本文
                       );
    $o_email->createMail($mailitems);
    $ret = $o_email->sendEmail($mode);
    if (PEAR::isError($ret)){
        trigger_error($ret->getMessage()."\n".$o_resource->getValue("G04018M013"), E_USER_ERROR);
        return false;
    }

    return true;

}

?>
