<?php
/**
* layerindicateset.php 処理概要：レイヤー表示設定
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/

require_once("./DefineDirectryName.php");                           // マップ別定数定義
require_once("function/KakikoContentsCommon.php");

// 次画面からの遷移で表示されたか?
$return_flg = false;
if (isset($_SESSION[DIRECTORY_NAME.'_layerindicateseqset'])) {
    unset($_SESSION[DIRECTORY_NAME.'_layerindicateseqset']);
    $return_flg = true;
}
// 初期表示の場合はSESSIONの内容を破棄
if (!isset($_POST['nxtBtn']) && $return_flg == false) {
    unset($_SESSION[DIRECTORY_NAME.'_layerindicate']);
    unset($_SESSION[DIRECTORY_NAME.'_layerindicateseq_left']);
    unset($_SESSION[DIRECTORY_NAME.'_layerindicateseq_right']);
}

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsViewService.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

// リソースファイル読込みクラス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"        => $o_resource->getValue("G04015L001"),
    "colTitle01"      => $o_resource->getValue("G04015L002"),
    "colTitle02"      => $o_resource->getValue("G04015L003"),
    "colTitle03"      => $o_resource->getValue("G04015L004"),
    "colTitle04"      => $o_resource->getValue("G04015L005"),
    "publiclayerKnd0" => $o_resource->getValue("G04015L006"),
    "publiclayerKnd1" => $o_resource->getValue("G04015L007"),
    "publiclayerKnd9" => $o_resource->getValue("G04015L008")
);

// 日付クラス
$o_date = new Date();

// DB接続サービス呼び出し
$o_service = new ContentsViewService(DIRECTORY_NAME);

// ＱｕｉｃｋＦｏｒｍクラス
$o_form = new HTML_QuickForm("layerindicateset", "POST", $_SERVER["PHP_SELF"]);

// 項目セット
$o_form->addElement("submit",  "nxtBtn",  $o_resource->getValue("G04015L009"), array("class"=>"fs12_black"));
$o_form->addElement("reset",   "rstBtn",  $o_resource->getValue("G04015L010"), array("class"=>"fs12_black"));
$o_form->addElement("submit",  "rtnBtn",  $o_resource->getValue("G04015L011"), array("class"=>"fs12_black"));

// 意味空間レイヤー表示設定画面遷移パラメータ設定
if(isset($_SESSION[DIRECTORY_NAME.'_imiSpaceId'])){
	$viewMode = "";
	if(isset($_GET['viewMode'])){
		$viewMode = $_GET['viewMode'];
		$_SESSION['viewMode'] = $_GET['viewMode'];
	}elseif(isset($_SESSION['viewMode'])){
		$viewMode = $_SESSION['viewMode'];
	}
	$o_form->addElement("hidden", "viewMode", $viewMode);
	$o_form->addElement("hidden", "imiSpaceId", $_SESSION[DIRECTORY_NAME.'_imiSpaceId']);
}

$errorMessage = "";

// 戻るボタン（意味空間・位置空間のモード切替）
if (isset($_POST['rtnBtn'])) {
	if(isset($_SESSION[DIRECTORY_NAME.'_imiSpaceId'])){
		$getString = "?viewMode=".$_SESSION['viewMode']."&imiSpaceId=".$_SESSION[DIRECTORY_NAME.'_imiSpaceId'];
		unset($_SESSION['viewMode']);
        header("location: ./imiindex.php".$getString);
	}else{
	    header("location: ./index.php");
	}
}

// 次へボタン
if (isset($_POST['nxtBtn'])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // チェックボックスが１つもチェックされていない場合はエラーを表示
        if (!isset($_POST['layerliststate'])) {
            $errorMessage = $o_resource->getValue("G04015M002");
        } else {
            // セッション内容書き換え
            mainte_session();
            // 表示順画面へリダイレクト
            header("location: ./layerindicateseqset.php");
            exit(0);
        }
    }
}

// 次画面の戻るからの遷移か?
if ($return_flg == true) {
    // セッションの内容から復元
    $listData = $_SESSION[DIRECTORY_NAME.'_layerindicate'];
} else {
    // 表示するレイヤー一覧を取得
    if (isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
        // データベースより取得
        $listData = getListData($o_service, $o_date);
    } else {
        // クッキーより取得
        $listData = getListDataGuest($o_service, $o_date);
    }
    // セッションに画面状態を保持
    $_SESSION[DIRECTORY_NAME.'_layerindicate'] = $listData;
}

// ｓｍａｒｔｙクラス
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("listDatas",    $listData);
$o_smarty->assign("labels",       $label);
$o_smarty->assign("infoMsg01",    $o_resource->getValue("G04015M001"));
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display(DIRECTORY_NAME."/layerindicateset.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：レイヤー表示設定表示情報取得
* 処理詳細：レイヤー表示設定に表示する情報をDBより取得(管理者/一般ユーザ)
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) o_date        - object  日付クラス
* @戻値： array 一覧情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getListData($o_service, $o_date) {

    // -----------------------------
    // レイヤー表示設定用の一覧取得
    // -----------------------------

    $data = $o_service->getLayerListData($_SESSION[DIRECTORY_NAME.'_userid']);
    if (is_null($data)) {
		exit();
    }

    $ret_array = array();

    if (count($data) <> 0) {

        for ($i = 0; $i < count($data); $i++) {

			if (is_null($data[$i]))	break;

			$o_date->setDate($data[$i]->getAddDateTime_Layer());

			$recode_array = array(
	               "layerid"=>$data[$i]->getLayerID_Layer(),
	               "layername"=>$data[$i]->getLayerName_Layer(),
	               "adddatetime"=>$o_date->format("%Y/%m/%d"),
	               "username"=>$data[$i]->getUserName_User(),
	               "publiclayer"=>$data[$i]->getPublicLayer_Layer(),
	               "layerliststate"=>$data[$i]->getLayerListState_UserPersonal()
			);
            $ret_array[] = $recode_array;
        }
    }

    // -------------------------------
    // レイヤー表示順設定用の一覧取得
    // -------------------------------

    $data = $o_service->getIndicateLayerData($_SESSION[DIRECTORY_NAME.'_userid']);
    if (is_null($data)) {
		exit();
    }

	$_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'] = array();

    if (count($data) <> 0) {

        for ($i = 0; $i < count($data); $i++) {

			if (is_null($data[$i]))	break;

			$_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'][htmlspecialchars($data[$i]->getLayerID())] = htmlspecialchars($data[$i]->getLayerName());
		}
	}

    return $ret_array;

}

/**
* 関数概要：レイヤー表示設定表示情報取得
* 処理詳細：レイヤー表示設定に表示する情報をDB/COOKIEより取得(ゲスト)
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) o_date        - object  日付クラス
* @戻値： array 一覧情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getListDataGuest($o_service, $o_date) {

    // クッキーより表示順の値を取得
    // 名前：[フォルダ名_layerpriorityorder]
    // 内容：レイヤー表示順でレイヤーIDを格納(「,」区切)
    if (isset($_COOKIE[LAYERPRIORITY])) {
        $pri_array = explode(",", $_COOKIE[LAYERPRIORITY]);
    } else {
        $pri_array = array();
    }

    // -----------------------------
    // レイヤー表示設定用の一覧取得
    // -----------------------------

    $data = $o_service->getLayerListData_Guest();
    if (is_null($data)) {
		exit();
    }

    $ret_array = array();

    if (count($data) <> 0) {

        for ($i = 0; $i < count($data); $i++) {

			if (is_null($data[$i]))	break;

            if (count($pri_array) != 0) {
                // クッキー内に同じレイヤーIDが存在するか
                $seq = array_search($data[$i]->getLayerID_Layer(), $pri_array);
            } else {
                // クッキーが存在しない場合
                $seq = 0;
            }

			$o_date->setDate($data[$i]->getAddDateTime_Layer());

			$recode_array = array(
	               "layerid"=>$data[$i]->getLayerID_Layer(),
	               "layername"=>$data[$i]->getLayerName_Layer(),
	               "adddatetime"=>$o_date->format("%Y/%m/%d"),
	               "username"=>$data[$i]->getUserName_User(),
	               "publiclayer"=>$data[$i]->getPublicLayer_Layer(),
	               "layerliststate"=>((string)$seq != "") ? "0" : "1"
			);
            $ret_array[] = $recode_array;
        }
    }

    // -------------------------------
    // レイヤー表示順設定用の一覧取得
    // -------------------------------

    $_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'] = array();

    $data = $o_service->getIndicateLayerData_Guest($pri_array);
    if (!is_null($data)) {
        foreach ($data as $key=>$value) {
            $_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'][htmlspecialchars($key)] = htmlspecialchars($value);
        }
    }

    return $ret_array;

}

/**
* 関数概要：画面表示データ配列の変更処理
* 処理詳細：画面表示データ配列を入力された内容で書き換える
*
* @引数： なし
* @戻値： なし
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function mainte_session(){

    // -------------------------------------
    // レイヤー表示設定一覧
    // -------------------------------------
    // レイヤー表示状態を全て非表示に変更
    foreach ($_SESSION[DIRECTORY_NAME.'_layerindicate'] as $key=>$value) {
        $_SESSION[DIRECTORY_NAME.'_layerindicate'][$key]['layerliststate'] = "1";
    }
    // 画面にてチェックされたレイヤーを表示に変更
    foreach ($_POST[layerliststate] as $key=>$value) {
        $_SESSION[DIRECTORY_NAME.'_layerindicate'][$key - 1]['layerliststate'] = "0";
    }

    // -------------------------------------
    // レイヤー表示順設定
    // -------------------------------------
    // 左側リスト
    // チェックされた以外のレイヤーを除外
    foreach ($_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'] as $key=>$value) {
        $seq = array_search($key, $_POST[layerliststate]);
        if ($seq == null) {
            unset($_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'][$key]);
        }
    }
    // 右側リスト
    $_SESSION[DIRECTORY_NAME.'_layerindicateseq_right'] = array();
    foreach ($_POST[layerliststate] as $key=>$value) {
        $_SESSION[DIRECTORY_NAME.'_layerindicateseq_right'][$value] = $_SESSION[DIRECTORY_NAME.'_layerindicate'][$key - 1]['layername'];
    }
    // 左側に存在するレイヤーは除外
    foreach ($_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'] as $key=>$value) {
        unset($_SESSION[DIRECTORY_NAME.'_layerindicateseq_right'][$key]);
    }

}

?>
