<?php
/**
* map.php 処理概要：メイン右フレーム表示処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：2007/03/23 (IIS)S.Komukai
* @バージョン：1.1.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");						// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");
require_once("class/common/MapController.class.php");
require_once("class/db/service/ContentsViewService.class.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");


// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

$mapController;	// まっぷコントロールクラスオブジェクト
$scaleString;	// スケール文字列
$mapExt;		// 現在表示されているエリアを表す配列

// セッションからユーザIDを取得
$s_UserId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
}

if(isset($_GET['scale'])){
	$scaleString = $_GET['scale'];
}else{
	if(MAP_TYPE == 0){
		// GISは「初期表示」固定
		$scaleString = "1";
	}else{
		// マップ管理者設定の初期表示マップ番号を取得
		$viewService = new ContentsViewService(DIRECTORY_NAME);
		$mapDetailData = $viewService->getMapDetailInitialImage();
		$scaleString = sprintf("%03d", $mapDetailData->getMapNumber());
	}
}

$layerTableData = null;
if(isset($_GET['mapext']) && (!isset($_GET['reset']))){
	$arr = explode(" ", $_GET['mapext']);
	$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);
}else{
	// 初期表示座標の取得
	$arr = null;
	if($s_UserId == null && isset($_COOKIE[LAYERPRIORITY])){
		// ゲストかつクッキーが存在した場合
        $layer_array = explode(",", $_COOKIE[LAYERPRIORITY]);
        // クッキーに設定されている1番上位のレイヤーテーブル情報を取得する
        if($layer_array != null){
			$service = new ContentsViewService(DIRECTORY_NAME);
			$layerTableData = $service->getLayerOneData($layer_array[0]);
			if(MAP_TYPE == 0){
				if($layerTableData->getStartX() == null && $layerTableData->getStartY() == null
						&& $layerTableData->getEndX() == null && $layerTableData->getEndY() == null){
					// レイヤー管理者によって初期座標が設定されていない場合はデフォルト
					$arr = explode(",", MAP_INITPOSITION);
				}else{
						$arr = array($layerTableData->getStartX(),
										$layerTableData->getStartY(),
										$layerTableData->getEndX(),
										$layerTableData->getEndY()
									);
				}
			}else{
				// レイヤー管理者設定の初期表示マップ設定を構成(スケールは座標算出後に書き換え)
				$mapDetailData = $service->getMapJoinMapDetailData($layerTableData->getCenterScale());
				$arr = getChangeInitialCoordinatesFromScaleNoGis((int)$scaleString, $mapDetailData);	
				$scaleString = sprintf("%03d", $layerTableData->getCenterScale());
			}
        }else{
			$arr = explode(",", MAP_INITPOSITION);
        }
	}else{
		// クッキーが存在しない場合
		$service = new ContentsViewService(DIRECTORY_NAME);
		$layerTableData = $service->getTopPriorityLayerData($s_UserId);
		if($layerTableData == null){
			$arr = explode(",", MAP_INITPOSITION);
		}else{
			if(MAP_TYPE == 0){
				if($layerTableData->getStartX() == null && $layerTableData->getStartY() == null
						&& $layerTableData->getEndX() == null && $layerTableData->getEndY() == null){
					// レイヤー管理者によって初期座標が設定されていない場合はデフォルト
					$arr = explode(",", MAP_INITPOSITION);
				}else{
					$arr = array($layerTableData->getStartX(),
									$layerTableData->getStartY(),
									$layerTableData->getEndX(),
									$layerTableData->getEndY()
								);
				}
			}else{
				// レイヤー管理者設定の初期表示マップ設定を構成(スケールは座標算出後に書き換え)
				$mapDetailData = $service->getMapJoinMapDetailData($layerTableData->getCenterScale());
				$arr = getChangeInitialCoordinatesFromScaleNoGis((int)$scaleString, $mapDetailData);	
				$scaleString = sprintf("%03d", $layerTableData->getCenterScale());
			}
		}
	}
	$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);
}
$mapExt = $mapController->get_minX()." ".$mapController->get_minY()." ".$mapController->get_maxX()." ".$mapController->get_maxY();

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// 
$labelArray = array(
	"windowTitle"    => $o_resource->getValue("G04002L201"),
	"rangeInMap"     => $o_resource->getValue("G04002L202")
);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("kakikoFromMap", "POST", $_SERVER["PHP_SELF"], "_self");

// チェックボックス＆ラジオボタンの設定
$memoDisplay = 0;
$kakikoChecked = "";
if(isset($_GET['memoDisplay']) && $_GET['memoDisplay'] == 1) $memoDisplay = 1;
if(isset($_GET['kakiko'])) $kakikoChecked = "checked";
$o_form->setDefaults(
	array(
		'kakiko' => $kakikoChecked,
		'memoDisplay' => 0,
		'memoDisplay' => $memoDisplay
	)
);

$o_form->addElement("checkbox", "kakiko",      $o_resource->getValue("G04002L203"), "", array("onclick"=>"statOfKakiko();","class"=>"fs12_black"));
$o_form->addElement("radio",    "memoDisplay", $o_resource->getValue("G04002L204"), "", 0, array("onclick"=>"memoRegistRadioChange(0);","checked"=>"checked","class"=>"fs12_black"));
$o_form->addElement("radio",    "memoDisplay", $o_resource->getValue("G04002L205"), "", 1, array("onclick"=>"memoRegistRadioChange(1);","class"=>"fs12_black"));
$o_form->addElement("hidden",   "area_height", MAP_HEIGHT);
$o_form->addElement("hidden",   "area_width",  MAP_WIDTH);
$o_form->addElement("hidden",   "click_x",     "");
$o_form->addElement("hidden",   "click_y",     "");
$o_form->addElement("hidden",   "mapext",      $mapExt);
$o_form->addElement("hidden",   "scale",       $scaleString);

$o_form->addElement("hidden",   "searchNew",      $_GET['searchNew']);
$o_form->addElement("hidden",   "searchFromDate", $_GET['searchFromDate']);
$o_form->addElement("hidden",   "searchToDate",   $_GET['searchToDate']);
$o_form->addElement("hidden",   "searchWord",     $_GET['searchWord']);
$o_form->addElement("hidden",   "mapType",        MAP_TYPE);

// GET文字列の配列
$gisCGIMode = $_SERVER["PHP_SELF"]."?mode=map";
$serchGETString = "&searchNew=".$_GET['searchNew']."&searchFromDate=".$_GET['searchFromDate']."&searchToDate=".$_GET['searchToDate']."&searchWord=".urlencode($_GET['searchWord']);
$getLinkArray = array(
  "leftUp"    => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextLeftUpString().$serchGETString,
  "up"        => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextUpString().$serchGETString,
  "rightUp"   => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextRightUpString().$serchGETString,
  "left"      => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextLeftString().$serchGETString,
  "right"     => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextRightString().$serchGETString,
  "leftDown"  => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextLeftDownString().$serchGETString,
  "down"      => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextDownString().$serchGETString,
  "rightDown" => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextRightDownString().$serchGETString
);
$getLinkImageArray = array(
  "leftUp"    => "<img src=\"./img/left_up.gif\"    alt=\"left_up\"    border=\"0\" align=\"bottom\" >",
  "up"        => "<img src=\"./img/up.gif\"         alt=\"up\"         border=\"0\" align=\"bottom\" >",
  "rightUp"   => "<img src=\"./img/right_up.gif\"   alt=\"right_up\"   border=\"0\" align=\"bottom\" >",
  "left"      => "<img src=\"./img/left.gif\"       alt=\"left\"       border=\"0\" align=\"bottom\" >",
  "right"     => "<img src=\"./img/right.gif\"      alt=\"right\"      border=\"0\" align=\"bottom\" >",
  "leftDown"  => "<img src=\"./img/left_down.gif\"  alt=\"left_down\"  border=\"0\" align=\"bottom\" >",
  "down"      => "<img src=\"./img/down.gif\"       alt=\"down\"       border=\"0\" align=\"bottom\" >",
  "rightDown" => "<img src=\"./img/right_down.gif\" alt=\"right_down\" border=\"0\" align=\"bottom\" >"
);
$strHref = "#";
$o_form->addElement("link", "leftUp",    "", $strHref,  $getLinkImageArray['leftUp'],   array("onclick"=>"mapArrowLink('".$getLinkArray['leftUp']."')","class"=>"fs12_black"));
$o_form->addElement("link", "up",        "", $strHref,  $getLinkImageArray['up'],        array("onclick"=>"mapArrowLink('".$getLinkArray['up']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "rightUp",   "", $strHref,  $getLinkImageArray['rightUp'],  array("onclick"=>"mapArrowLink('".$getLinkArray['rightUp']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "left",      "", $strHref,  $getLinkImageArray['left'],      array("onclick"=>"mapArrowLink('".$getLinkArray['left']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "right",     "", $strHref,  $getLinkImageArray['right'],     array("onclick"=>"mapArrowLink('".$getLinkArray['right']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "leftDown",  "", $strHref,  $getLinkImageArray['leftDown'], array("onclick"=>"mapArrowLink('".$getLinkArray['leftDown']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "down",      "", $strHref,  $getLinkImageArray['down'],      array("onclick"=>"mapArrowLink('".$getLinkArray['down']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "rightDown", "", $strHref,  $getLinkImageArray['rightDown'], array("onclick"=>"mapArrowLink('".$getLinkArray['rightDown']."')","class"=>"fs12_black")   );

// 地図の範囲配列
$rangeArray = $mapController->get_mapextRangeArray($scaleString, $serchGETString);

// 地図の表示サイズ
$dispMapSize = array(
	"width"  => MAP_WIDTH,
	"height" => MAP_HEIGHT
);

$getImageAddress ="";
if(MAP_TYPE == 0){
	$getImageAddress = MAP_SERVER_ADDR."?".MAP_FILE_NAME."&mode=map".$mapController->get_mapextString();

}else{
	$getImageAddress = "./createkakikoimage.php?scale=".$scaleString.$mapController->get_mapextString();
}
// JSON POST文字列
$jsonPostString = "\"&mapext=".$mapExt."&area_width=".MAP_WIDTH."&area_height=".MAP_HEIGHT."&mapType=".MAP_TYPE."&searchNew=".$_GET['searchNew']."&searchFromDate=".$_GET['searchFromDate']."&searchToDate=".$_GET['searchToDate']."&searchWord=".$_GET['searchWord']."\";";

// ユーザID、ユーザ名
$usrinfolabelArray = array(
	"usernameLabel" => $o_resource->getValue("G04002L206"),
	"usernameText"  => $_SESSION[DIRECTORY_NAME.'_username'],
	"userType"    => $_SESSION[DIRECTORY_NAME.'_usertype'],
	"userIdText"    => $_SESSION[DIRECTORY_NAME.'_userid']
);
// リンクURL実装
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	// ログイン後リンク（個人情報設定／情報の整理）
	$o_form->addElement("link", "personalInfo", "", "./userinfo.php",     $o_resource->getValue("G04002L207"), array("target"=>"_top","class"=>"fs12_black"));
	$o_form->addElement("link", "arrangeInfo",  "", "./imispacemenu.php", $o_resource->getValue("G04002L208"), array("target"=>"_top","class"=>"fs12_black","onclick"=>"if(typeof(subWindow) != 'undefined' && !subWindow.closed){subWindow.close();}"));
	$o_form->addElement("link", "logout",       "", "./logout.php",       $o_resource->getValue("G04002L209"), array("target"=>"_top","class"=>"fs12_black"));
}else{
	// ログイン前リンク（ログイン／ユーザ登録）
	$o_form->addElement("link", "login",      "", "./login.php",         $o_resource->getValue("G04002L210"), array("target"=>"_top","class"=>"fs12_black"));
	$o_form->addElement("link", "userRegist", "", "./userregistreq.php", $o_resource->getValue("G04002L211"), array("target"=>"_top","class"=>"fs12_black"));
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// form
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form", $o_renderer->toArray());

$o_smarty->assign("jsonPostString",    $jsonPostString);
$o_smarty->assign("rangeArray",        $rangeArray);
$o_smarty->assign("getImageAddress",   $getImageAddress);
$o_smarty->assign("dispMapSize",       $dispMapSize);
$o_smarty->assign("labelArray",        $labelArray);
$o_smarty->assign("usrinfolabelArray", $usrinfolabelArray);

$o_smarty->display(DIRECTORY_NAME."/map.tpl");

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
?>
