<?php
/**
* memolist.php 処理概要：メモ・コメント一覧表示処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：2007/03/23 (IIS)S.Komukai
* @バージョン：1.1.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("class/db/service/ContentsViewService.class.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// Pager
$s_UserId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
}
// #########################
// 検索条件の設定
$searchKey = null;
$searchNew = null;
$searchWord = null;
$searchFromDate = null;
$searchToDate = null;
$serrchErroFlag = false;
$displayMemoType = null;
if($_GET['searchNew'] != ""){
	$searchNew = $_GET['searchNew'];
}
if($_GET['searchWord'] != ""){
	$searchWord = $_GET['searchWord'];
}
$searchFromDate = convertSearchDate($_GET['searchFromDate']);
if($searchFromDate === false){
	$serrchErroFlag = true;
}
$searchToDate = convertSearchDate($_GET['searchToDate']);
if($searchToDate === false){
	$serrchErroFlag = true;
}
if ($_GET['displayedMemoType'] != ""){
	$displayMemoType = $_GET['displayedMemoType'];
}
$searchMapExt = null;
if(isset($_GET['mapext'])){
	$searchMapExt = explode(" ", $_GET['mapext']);
}
$searchKey = array(
	"limit" => $searchNew,
	"from"  => $searchFromDate,
	"to"    => $searchToDate,
	"word"  => $searchWord,
	"displaymemotype"  => $displayMemoType,
	"minx"  => $searchMapExt[0],
	"maxx"  => $searchMapExt[2],
	"miny"  => $searchMapExt[1],
	"maxy"  => $searchMapExt[3]
);
// #########################

$data_array = array();
if(!$serrchErroFlag){
	if ($displayMemoType != "NoMemo"){
		$data_array = getMemoCommentTreeData($s_UserId, $searchKey);
	}
}


$rowCount = count($data_array);
$params = array(
    "perPage"=>MEMOCOMMENTLIST_ROW,
    "mode"=>"Jumping",
    "itemData"=>$data_array,
    "totalItems"=>$rowCount,
    "prevImg"=>$o_resource->getValue("G04010L006"),
    "nextImg"=>$o_resource->getValue("G04010L007"),
    "httpMethod"=>"GET"
);
$o_page = Pager::factory($params);
$listdata = $o_page->getPageData();
$o_smarty->assign("listData", $listdata);
$navi = $o_page->getlinks();
$o_smarty->assign("navi", $navi["all"]);

$labelArray = array("header"  => $o_resource->getValue("G04010L001"),
				"label1"       => $o_resource->getValue("G04010L002"),
				"label2"       => $o_resource->getValue("G04010L003"),
				"label3"       => $o_resource->getValue("G04010L004"),
				"label4"       => $o_resource->getValue("G04010L005"),
				"rowCount"     => $rowCount,
				"currentStart" => (($o_page->getCurrentPageID() - 1) * MEMOCOMMENTLIST_ROW) + 1 ,
				"currentEnd"   => (($o_page->getCurrentPageID() - 1) * MEMOCOMMENTLIST_ROW) + count($listdata)
			);
$o_smarty->assign("labelArray", $labelArray);

$o_smarty->display(DIRECTORY_NAME."/memolist.tpl");

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：ツリーデータ取得
* 処理詳細：ツリーデータ（スレッド）を取得する
*
* @引数： (I) userId	 - string  ユーザID
*         (I) $searchKey - array   検索条件
*              $searchKey['minx'] - 範囲座標（X緯度最小）
*              $searchKey['maxx'] - 範囲座標（X緯度最大）
*              $searchKey['miny'] - 範囲座標（Y経度最小）
*              $searchKey['maxy'] - 範囲座標（Y経度最大）
* @戻値： array ツリー情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getMemoCommentTreeData($userId, $searchKey){

	$service = new ContentsViewService(DIRECTORY_NAME);
//print_r($searchKey);

	$dataArray = $service->getAllMemoCommentTreeData($userId, $searchKey);

	$treeData = array();
	foreach($dataArray as $record){

		$iconPath = "";
		$ribbonColor = "";
		$linkString = dirname($_SERVER['PHP_SELF'])."/memodetail.php"
				."?memoTypeId=".$record->getMemoTypeID()
				."&memoId=".$record->getMemoID();
		if($record->getCommentID() != ""){
			$linkString = $linkString."&commentId=".$record->getCommentID();
		}else{
			// アイコンタイプでアドレス切り替え
			if($record->getIconType() == 0){
				$iconPath = "../../img/icon/".$record->getIcon();
			}else{
				$iconPath = "./img/icon/".$record->getIcon();
			}
			// リボンカラーの設定
			$ribbonColor = "#".$record->getRibbonColor();
		}

		$dotString = str_repeat("・ ", $record->getNodeLevel() - 1);

		$recordData = array(
			"commentId"	      => $record->getCommentID(),
			"highercommentid" => $record->getHigherCommentID(),
			"dot"             => $dotString,
			"title"	          => $record->getTitle(),
			"username"        => $record->getUserName(),
			"adddatetime"     => $record->getAddDatetime(),
			"link"            => $linkString,
			"icon"            => $iconPath,
			"ribbon"          => $ribbonColor
		);

		array_push($treeData, $recordData);
	}

	return $treeData;

}

?>