<?php
/**
* checkpasswd.php 処理概要:修正・削除パスワードチェック処理
* PHP versions : 4.4.2
* @Package : package_name
* @作者 : (IIS)J.Fujikawa
* @作成日/作成者 : 2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者 :
* @バージョン : 1.0.0
* 
* Copyright (c) 2007 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

require_once("../DefineDirectryName.php");					//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoMobileCommon.php");

require_once("class/db/service/ContentsAdminService.class.php");	//DBアクセスサービスクラス
require_once("class/db/service/ContentsViewService.class.php");	//DBアクセスサービスクラス
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

//initialize
$mode = "0";		//0:memo,1:comment
$doEditAction = "";			//0:memoedit.php,1:commentedit.php
$doDelAction = "";		//memodelete.php?memoId=XX&commnetID=XX
$userMode = "0";		//0:layerAdmin,1:user
$editFlg = TRUE;
$delFlg = TRUE;

$postPwd = "";
$postLayerId = "";
$postMemoId = "";
$postMemoType = "";
$postCommentId = "";

$errorMessage = "";
$backPage = ""; 	//[memodetail.php?memoId=XX] or[memodetail.php?memoId=XX&commentId=XX]
$backLink = "";

if ($_SERVER["REQUEST_METHOD"] == "POST"){

	//ボタンチェック
	if(isset($_POST['update'])){
		$editFlg		=	TRUE;
		$delFlg			=	FALSE;
	}else if(isset($_POST['delete'])){
		$editFlg		=	FALSE;
		$delFlg			=	TRUE;	
	}

	//POST引数取得
	if ((array_key_exists( "updDelPwd",		$_POST)) && 
		(array_key_exists( "layerid", 		$_POST)) && 
		(array_key_exists( "memoId", 		$_POST)) && 
		(array_key_exists( "memoTypeId",	$_POST)) && 
		(array_key_exists( "commentId",		$_POST))){
		$postPwd		=	trim($_POST["updDelPwd"]);
		$postLayerId	=	trim($_POST["layerid"]);
		$postMemoId		=	trim($_POST["memoId"]);
		$postMemoType	=	trim($_POST["memoTypeId"]);
		$postCommentId	=	trim($_POST["commentId"]);
	}else{
		//アクセスエラー（引数なし）
		trigger_error(mbConvertEncoding($o_resource->getValue("G06008M003"),"SJIS"), E_USER_ERROR);
    	exit(-1);
	}
}else{
	//METHODエラー
	trigger_error(mbConvertEncoding($o_resource->getValue("G06008M003"),"SJIS"), E_USER_ERROR);
	exit();
}

//レイヤーIDチェック
if ((empty($postLayerId)) && ($postLayerId == "")){
	//レイヤーID引数エラー
	trigger_error(mbConvertEncoding($o_resource->getValue("G06008M003"),"SJIS"), E_USER_ERROR);
	exit();
}

//メモIDチェック
if ((empty($postMemoId)) && ($postMemoId == "")){
	//メモID引数エラー
	trigger_error(mbConvertEncoding($o_resource->getValue("G06008M003"),"SJIS"), E_USER_ERROR);
	exit();
}

//メモ種類IDチェック
if ((empty($postMemoType)) && ($postMemoType == "")){
	//メモ種別引数エラー
	trigger_error(mbConvertEncoding($o_resource->getValue("G06008M003"),"SJIS"), E_USER_ERROR);
	exit();
}

//コメントIDチェック
if (empty($postCommentId)){
	$mode		=	"0";	//mode=memo
	$doEditAction	=	"./memoedit.php?memoId=" . $postMemoId;
	$doDelAction	=	"./memodelete.php?memoId=" . $postMemoId . "&commentId=" . $postCommentId;
	$backPage = "./memodetail.php?memoId=" . $postMemoId;
}else{
	$mode		=	"1";	//mode=comment
	$doEditAction	=	"./commentedit.php?memoId=" . $postMemoId . "&commentId=" . $postCommentId;
	$doDelAction	=	"./memodelete.php?memoId=" . $postMemoId . "&commentId=" . $postCommentId;
	$backPage = "./memodetail.php?memoId=" . $postMemoId . "&commentId=" . $postCommentId;
}

// レイヤー管理者チェック
if ($s_UserId != ""){
	if (userTypeCheck($s_UserId, $postLayerId)){
		$userMode	=	"0";	//userMode=レイヤー管理者
	}else{
		$userMode	=	"1";	//userMode=一般ユーザ
	}
}else{
	$userMode	=	"1";	//userMode=一般ユーザ
}

if ($userMode == "1"){
	//パスワードチェック
	if (empty($postPwd)){
		//パスワード未入力エラー
		$errorMessage	=	mbConvertEncoding($o_resource->getValue("G06008M004"), "SJIS");
		$editFlg		=	FALSE;
		$delFlg			=	FALSE;
	}
}

// smarty インスタンス化
$o_smarty= new KakikoSmarty();

//メモ管理 or コメント管理テーブル存在チェック
$targetID		=	$mode == "0" ? $postMemoId : $postCommentId;
$dataArray		=	array();

if (getData($mode, $targetID, $dataArray, $userID)){

	if ($dataArray["nodeStatus"] == FALSE){
		$errorMessage	=	mbConvertEncoding($o_resource->getValue("G06008M005"),"SJIS");
		$delFlg			=	FALSE;
	}

	switch ($dataArray["deleteflg"]){
		case null:
		case "0":
			//一般ユーザパスワード判定
			if ($userMode == "1"){
				if ($dataArray["pwd"] != $postPwd){
					$errorMessage	=	mbConvertEncoding($o_resource->getValue("G06008M004"),"SJIS");
					$editFlg		=	FALSE;
					$delFlg			=	FALSE;
				}
			}
			break;
		case "1":
			if ($userMode == "1"){
				$errorMessage	=	mbConvertEncoding($o_resource->getValue("G06008M006"),"SJIS");
				$editFlg		=	FALSE;
				$delFlg			=	FALSE;
			}
			break;
		default:
			trigger_error(mbConvertEncoding($o_resource->getValue("G06008M007"),"SJIS"), E_USER_ERROR);
			exit();
			break;
	}
}else{
	$errorMessage	=	mbConvertEncoding($o_resource->getValue("G06008M006"),"SJIS");
	$editFlg		=	FALSE;
	$delFlg			=	FALSE;
}

//修正
if ($editFlg){
	header("location: ". $doEditAction);
	exit();
}

//削除
if ($delFlg){
	header("location: ". $doDelAction);
	exit();
}

$backLink = "<a href=\"". $backPage . "\">" . mbConvertEncoding($o_resource->getValue("G06008L011"), "SJIS") ."</a>";

$labelArray = array(
	"label02"  => $backLink
);

$o_smarty->assign("errorMessage",$errorMessage);
$o_smarty->assign("labelArray", $labelArray);
$o_smarty->display(DIRECTORY_NAME . "/mobilecommon.tpl");

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要	：レイヤー管理者チェック
* 処理詳細	：一般ユーザ、レイヤー管理者の判定
*
* @引数		：	(I) layerID		- レイヤーID）
*			：	(I) memoID		- メモID
*
* @戻値		：	boolean  TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function userTypeCheck($userid, $layerid){

	$adminService = new ContentsAdminService(DIRECTORY_NAME);

	$layerRecord = $adminService->getLayerInfoData($userid,$layerid);

	if (is_null($layerRecord)){
		return FALSE;
	}else{
		return TRUE;
	}
}


/**
* 関数概要	：対象データ取得
* 処理詳細	：メモ／コメントデータ取得
*
* @引数		：	(I) mode		- 0:メモ or 1:コメント
*				(I) id			- メモID or コメントID
*				(O) dataArray	- データ配列
*				(I) userId		- ユーザID
*
* @戻値		：	boolean  TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getData($mode, $id, &$dataArray, $userId){
	$dataArray	=	array();
	//データ取得処理
	if ($mode == "0"){
		//メモデータ取得
		$dataArray	=	getMemoData($id, $userId);
	}else{
		//コメント取得
		$dataArray	=	getCommentData($id);
	}

	if (is_null($dataArray) == FALSE){
		$dataArray["nodeStatus"] = checkChildNode($mode, $id);
		return TRUE;
	}else{
		return FALSE;
	}
}

/**
* 関数概要	：メモデータ取得
* 処理詳細	：メモデータ取得
*
* @引数		：	(I) memoid	- メモID
*               (I) userId  - ユーザID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getMemoData($memoid, $userId){

	$viewService		=	new ContentsViewService(DIRECTORY_NAME);
	$memoDetailRecord	=	new MemoDetailPositionTypeData;
	$memoDetailRecord	=	$viewService->getOneMemoDetailViewDataAuth($memoid, $userId);
	
	if (is_null($memoDetailRecord)){
		trigger_error("メモ取得エラー。暫定版！！！", E_USER_ERROR);
		return FALSE;
	}

	$memoData	=	array();

	$memoData	=	array(
						"id"			=> $memoDetailRecord->getMemoID(),
						"pwd"			=> $memoDetailRecord->getUpdateDeletePassword_d(),
						"deleteflg"		=> $memoDetailRecord->getDeleteFlg_d(),
						"nodeStatus"	=> ""
					);

	return $memoData;
}

/**
* 関数概要	：コメントデータ取得
* 処理詳細	：コメントデータ取得
*
* @引数		：	(I) memoid	- メモID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getCommentData($commentid){

	$viewService	=	new ContentsViewService(DIRECTORY_NAME);
//	$commentRecord	=	new CommentData;
	$commentRecord	=	new MemoDetailPositionTypeData;
	$commentRecord	=	$viewService->getOneCommentData($commentid);
	
	if (is_null($commentRecord)){
		trigger_error("コメント取得エラー。暫定版！！！", E_USER_ERROR);
		return FALSE;
	}

	$commentData	=	array();

	$commentData	=	array(
							"id"			=> $commentRecord->getCommentID(),
							"pwd"			=> $commentRecord->getUpdateDeletePassword_c(),
							"deleteflg"		=> $commentRecord->getDeleteFlg_c(),
							"nodeStatus"	=> ""
						);

	return $commentData;	
}

/**
* 関数概要	：子ノード存在チェック（メモ）
* 処理詳細	：コメントデータ存在チェック
*
* @引数		：	(I) mode		- 0:メモ or 1:コメント
*				(I) id			- メモID or コメントID
*
* @戻値		：	boolean			- TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function checkChildNode($mode, $id){
	$viewService	=	new ContentsViewService(DIRECTORY_NAME);

	//データ取得処理
	if ($mode == "0"){
		if ($viewService->checkExistChildCommentByMemoId($id)){
			return	FALSE;
		}
	}else{
		if ($viewService->checkExistChildCommentByCommentId($id)){
			return	FALSE;
		}
	}

	return	TRUE;
}

?>