<?php
/**
* combinemap.php 処理概要:地図画像合成処理
* PHP versions : 4.4.2
* @パッケージ : -
* @作者 : (IIS)J.Fujikawa
* @作成日/作成者 : 2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者 :
* @バージョン : 1.0.0
*
* Copyright (c) 2007 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

require_once("../DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");						// リソースファイル読込み
require_once("class/common/MapController.class.php");
require_once("class/db/service/ContentsViewService.class.php");
require_once("function/KakikoMobileCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// セッションからデータ一覧を取得する
if(isset($_SESSION[DIRECTORY_NAME.'_pageData'])){
	$pageData = $_SESSION[DIRECTORY_NAME.'_pageData'];
	// 画像を生成するためだけに使用するので、セッションからは即削除
	unset($_SESSION[DIRECTORY_NAME.'_pageData']);
}
// 呼び元から地図の範囲(mapext)を取得する
if(isset($_GET['mapext']) && ($_GET['mapext'] != "")){
	$arr = explode(" ", $_GET['mapext']);
}

////デバッグ用
//var_dump($arr);
//var_dump($pageData);

$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);

// 画像表示処理
// MapServerへのアドレスを設定(ローカルアドレス)
if(MAP_TYPE == 0){
	// ######要検討###### MAP_FILE_NAMEは、携帯独自のものを用意すべき
	$getImageAddress = MAP_SERVER_ADDR_LOCAL."?".MAP_FILE_NAME."&mode=map".$mapController->get_mapextString();
	$getImageAddress = $getImageAddress."&mapsize=".MAP_WIDTH_MOBILE. "+".MAP_HEIGHT_MOBILE;

}else{
	// カキコエンジンは未対応
}

// 画像ファイル生成
header('Content-type: image/gif');
// MapServerから画像を取得
// 画像サイズを取得し、画像の種類によって呼び出す関数を変更する
// 最終的にはGIF画像として出力する
$imsize = getimagesize($getImageAddress); 
switch ($imsize[2]){
        case 1:		//gif
                $im = @imagecreatefromgif($getImageAddress);
                break;
        case 2:		//jpeg
                $im = @imagecreatefromjpeg($getImageAddress);
                break;
        case 3:		// png
                $im = @imagecreatefrompng($getImageAddress);
                break;
        default:
                break;
}
if (!$im) {
	exit();
}
$count = 0;
if ( !(is_null($pageData)) ){
	foreach($pageData as $data){
		$count++;
		// 地図上の位置座標を算出
		$coordinates = $mapController->get_JsFromCoordinates(MAP_WIDTH_MOBILE, MAP_HEIGHT_MOBILE,
											 $data->getLongitude(), $data->getLatitude());
		// マーカ貼り付け
		$im_num = @imagecreatefromgif("../img/".$count.".gif");
		// imagecopymerge(下絵,上絵,配置X,配置Y,画像開始X,画像開始Y,画像の幅W,画像の高さH,透過率(0～100));
		// 配置X,配置Yは、マーカー幅の半分を減算する。
		imagecopymerge($im,$im_num,$coordinates[0]-10,$coordinates[1]-10,0,0,20,20,50);
		// 画像を破棄
		imagedestroy($im_num);
	}
}

// 結果を出力
imagegif($im);
// 画像を破棄
imagedestroy($im);

?>
