<?php
/**
* G04-007
* memoregist.php 処理概要：コメント修正処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Fujikawa
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2007 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("../DefineDirectryName.php");					//Directory(PREFIX)読み込み

//require_once("class/common/MapController.class.php");
require_once("class/db/service/ContentsViewService.class.php");
require_once("class/db/tabledata/CommentData.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoMobileCommon.php");
require_once("class/xml/RSSController.class.php");			// RSS

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);
// ユーザエージェントチェック
$agent	=	false;

$labelArray = "";
$errorMessage	= "";
$pageFlg		= 0;
$tplName		= "";
$errorFileSize	= "";
$errorFileType	= "";
$filecheck		= TRUE;

/* テスト用
$dmy = "a";
switch($dmy){
*/
switch(user_agent()){
	case "a":
		$tplName = DIRECTORY_NAME."/mobilecommentedit.tpl";
		$agent = true;
		break;
	case "d":
	case "v":
		// 座標情報取得

		$linkTag	=	"";

		$labelArray = array(
			"label01"  => getContName(),
			"label02"  => mbConvertEncoding($o_resource->getValue("G06006M001"), "SJIS"),
			"label03"  => mbConvertEncoding($o_resource->getValue("G06006M002"), "SJIS"),
			"label04"  => mbConvertEncoding($o_resource->getValue("G06006M003"), "SJIS")
		);
		$tplName = DIRECTORY_NAME."/mobilecommon.tpl";
		break;
	default:
    	header("location: ../index.php");
	    break;
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("commentEditForm", "POST", $_SERVER["PHP_SELF"], "_self");

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

if($agent){
	//初期化
	$commentRecord = null;
	$postMemoId		= "";
	$postCommentId	= "";
	$postName		= "";
	$postTitle		= "";
	$postText	    = "";
	$postMail		= "";
	$postUrl		= "";
	$postUpddelpwd	= "";
	$updDate		= "";

	//POST引数取得
	if ($_SERVER["REQUEST_METHOD"] == "POST"){
		if ((array_key_exists( "memoId",	$_POST))
			&& (array_key_exists( "commentId",	$_POST))
			&& (array_key_exists( "name",	$_POST))
			&& (array_key_exists( "title",	$_POST))
			&& (array_key_exists( "text",	$_POST))
			&& (array_key_exists( "mail",	$_POST))
			&& (array_key_exists( "url",	$_POST))
			&& (array_key_exists( "updDelPwd",	$_POST))){
			$postMemoId		=	postInfo("memoId");
			$postCommentId	=	postInfo("commentId");
			$postName		= postInfo("name");
			$postTitle		= postInfo("title");
			$postText	    = postInfo("text");
			$postMail		= postInfo("mail");
			$postUrl		= postInfo("url");
			$postUpddelpwd	= postInfo("updDelPwd");
	
			// 詳細情報を取得
			$commentRecord = new MemoDetailPositionTypeData;
			$commentRecord = getCommentData($postCommentId);
			if ($commentRecord == FALSE){
				//対象データなし
				trigger_error($o_resource->getValue("G06007M020"), E_USER_ERROR);
				exit();
			}
		}else{
			//アクセスエラー（引数なし）
			trigger_error($o_resource->getValue("G06007M019"), E_USER_ERROR);
	    	exit(-1);
		}
	}else if ($_SERVER["REQUEST_METHOD"] == "GET"){
		if ((array_key_exists( "memoId",	$_GET)) && 
			(array_key_exists( "commentId",	$_GET))){
			$postMemoId		=	getInfo("memoId");
			$postCommentId	=	getInfo("commentId");
	
			// 詳細情報を取得
			$commentRecord = new MemoDetailPositionTypeData;
			$commentRecord = getCommentData($postCommentId);
			if ($commentRecord == FALSE){
				//対象データなし
				trigger_error($o_resource->getValue("G06007M020"), E_USER_ERROR);
				exit();
			}
		}else{
			//アクセスエラー（引数なし）
			trigger_error($o_resource->getValue("G06007M019"), E_USER_ERROR);
	    	exit(-1);
		}
	}else{
		//METHODエラー
		trigger_error($o_resource->getValue("G06007M019"), E_USER_ERROR);
		exit();
	}
	
	// 項目セット
	$o_form->addElement("header",   "header",    mbConvertEncoding($o_resource->getValue("G06007L018"),"SJIS"));
	$o_form->addElement("text",     "name",      mbConvertEncoding($o_resource->getValue("G06007L002"),"SJIS"), array("size"=>"20", "maxlength"=>"32", "autocomplete"=>"off", "class"=>"fs16_black"));
	$o_form->addElement("text",     "title",     mbConvertEncoding($o_resource->getValue("G06007L003"),"SJIS"), array("size"=>"20", "maxlength"=>"20", "autocomplete"=>"off", "class"=>"fs16_black"));
	$o_form->addElement("textarea", "text",      mbConvertEncoding($o_resource->getValue("G06007L004"),"SJIS"), array("maxlength"=>"500", "autocomplete"=>"off", "class"=>"fs16_black", "cols"=>"20", "rows"=>"5"));
	$o_form->addElement("text",     "mail",      mbConvertEncoding($o_resource->getValue("G06007L005"),"SJIS"), array("size"=>"20", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs16_black"));
	$o_form->addElement("text",     "url",       mbConvertEncoding($o_resource->getValue("G06007L006"),"SJIS"), array("size"=>"20", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs16_black"));
	
	$o_form->addElement("text",     "imgFile",   mbConvertEncoding($o_resource->getValue("G06007L007"),"SJIS"));
	$o_form->addElement("password", "updDelPwd", mbConvertEncoding($o_resource->getValue("G06007L008"),"SJIS"), array("size"=>"4", "maxlength"=>"4", "autocomplete"=>"off", "class"=>""));
	//画像ファイルありなしラベル作成
	if ($commentRecord->getImageFile_c() != ""){
		$o_form->addElement("text",     "currentImg",mbConvertEncoding($o_resource->getValue("G06007L012"),"SJIS"));
	}else{
		$o_form->addElement("text",     "currentImg",mbConvertEncoding($o_resource->getValue("G06007L013"),"SJIS"));
	}
	
	// 独自チェックルールの定義
	$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');
	
	// チェック項目
	$o_form->addRule("name",      mbConvertEncoding($o_resource->getValue("G06007M001"),"SJIS"), "required");
	$o_form->addRule("name",  	  mbConvertEncoding($o_resource->getValue("G06007M002"),"SJIS"), "maxlength_valid",   32);
	$o_form->addRule("title",     mbConvertEncoding($o_resource->getValue("G06007M003"),"SJIS"), "required");
	$o_form->addRule("title",  	  mbConvertEncoding($o_resource->getValue("G06007M004"),"SJIS"), "maxlength_valid",	20);
	$o_form->addRule("text",  	  mbConvertEncoding($o_resource->getValue("G06007M005"),"SJIS"), "maxlength_valid",	500);
	$o_form->addRule("mail",  	  mbConvertEncoding($o_resource->getValue("G06007M006"),"SJIS"), "email",	null);
	$o_form->addRule("mail",	  mbConvertEncoding($o_resource->getValue("G06007M007"),"SJIS"), "maxlength_valid",	128);
	$o_form->addRule("url",  	  mbConvertEncoding($o_resource->getValue("G06007M008"),"SJIS"), "regex",	"/^(http|https)?(:\/\/([\w-]+\.)+[\w-]+(\/[\w- .\/?%&=]*)?)/");
	$o_form->addRule("url",	      mbConvertEncoding($o_resource->getValue("G06007M009"),"SJIS"), "maxlength_valid",	128);
	$o_form->addRule("updDelPwd", mbConvertEncoding($o_resource->getValue("G06007M010"),"SJIS"), "regex", "/^[a-zA-Z0-9]+$/");
	$o_form->addRule("updDelPwd", mbConvertEncoding($o_resource->getValue("G06007M011"),"SJIS"), "maxlength_valid",	4);
	
	// 登録ボタン
	if (array_key_exists( "commentEdit", $_POST)){
	
	    // チェックOK
	    if (($o_form->validate()) && ($filecheck)) {
			$pageFlg = 1;
	
			$uploadDir = "../img/memo/";
			$uploadfileName	=	"";
	
	        // **************************
	        // DB登録処理実装部
	        // **************************
	
			//更新時刻
			$curDate = date('Y/m/d H:i:s');
			
			//更新列の設定
			// コメント情報
			$targetComment = new CommentData();
			$targetComment->setCommentID(WHERE_KEY);
			$targetComment->setUserName(VAL_TARGET);
			$targetComment->setCommentTitle(VAL_TARGET);
			$targetComment->setCommentText(VAL_TARGET);
			$targetComment->setMailAddress(VAL_TARGET);
			$targetComment->setReleteURL(VAL_TARGET);
			//imageFileは更新対象としない
//			$targetComment->setImageFile(VAL_TARGET);
			$targetComment->setUpdateDeletePassword(VAL_TARGET);
			$targetComment->setAccessCount(VAL_TARGET);
			$targetComment->setUpdateDateTime(VAL_TARGET);
	
			$comment = new CommentData();
			$comment->setCommentID($postCommentId);
			$comment->setUserName($postName);
			$comment->setCommentTitle($postTitle);
			$comment->setCommentText($postText);
			$comment->setMailAddress($postMail);
			$comment->setReleteURL($postUrl);
			$comment->setImageFile($uploadfileName);
			$comment->setUpdateDeletePassword($postUpddelpwd);
			$comment->setAccessCount($commentRecord->getAccessCount_c() + 1);
			$comment->setUpdateDateTime($curDate);
	
			// UPDATE
			$viewService = new ContentsViewService(DIRECTORY_NAME);
	
			if ($viewService->updateCommentDataByKey($targetComment, $comment) == FALSE){
				trigger_error("Comment Error", E_USER_ERROR);
				exit(-1);
			}

			// メール本文内の更新時刻を設定
			$updDate = $curDate;
	 
	 		// RSS出力(携帯は、第３引数にTRUEを入れること)
			$rss = new RSSController($commentRecord->getLayerID(), DIRECTORY_NAME, TRUE);
			if(!$rss->writeRssFile()){
				trigger_error("RSS Error!!", E_USER_ERROR);
			    exit(-1);
			}
	    }
	}else{
	
		// 入力項目のデフォルトをセット
		//SJIS一括置換
		$o_form->setDefaults(
			arrayToSJIS(
				array(
			    	"name"      => $commentRecord->getUserName_c(),
			    	"title"     => $commentRecord->getCommentTitle(),
			    	"text"      => $commentRecord->getCommentText(),
			    	"mail"      => $commentRecord->getMailAddress_c(),
			    	"url"       => $commentRecord->getReleteURL_c(),
			    	"imgFile"   => $commentRecord->getImageFile_c(),
			    	"updDelPwd" => $commentRecord->getUpdateDeletePassword_c()
				)
			)
		);
	}
	
	// ボタンを表示
	if ($pageFlg == 0) {
	    // 登録画面
	 	$o_form->addElement("hidden", "memoId", $postMemoId);
	 	$o_form->addElement("hidden", "commentId", $postCommentId);
	    $o_form->addElement("submit", "commentEdit", mbConvertEncoding($o_resource->getValue("G06007L010"),"SJIS"), array("class"=>"fs12_black"));
	
		$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
		$o_form->accept($o_renderer);
		$o_smarty->assign("form", $o_renderer->toArray());
		$labelArray = array(
	      "label01"  => $o_resource->getValue("G06007M012"),
	      "label02"  => $o_resource->getValue("G06007M013"),
	      "label03"  => $o_resource->getValue("G06007M014"),
	      "errorFileSize" => $errorFileSize,
	      "errorFileType" => $errorFileType,
	      "contName" => getContName(),
	      "layerName" => "(" . $commentRecord->getLayerName() . "/" . $commentRecord->getMemoTypeName().")"
		);
		
		//SJIS一括置換
		$labelArray = arrayToSJIS($labelArray);
	
		$o_smarty->assign("radioArray", $radioArray);
		
	} else {
	    // 完了画面
	    //フォームを作成
		$edit_form = new HTML_QuickForm("imageEditForm", "POST", "./getmail.php", "_self");
		// 項目セット
		$edit_form->addElement("checkbox", "delete",   "", mbConvertEncoding($o_resource->getValue("G06007M038"),"SJIS"));
	 	$edit_form->addElement("hidden",   "memoId",   $postMemoId);
	 	$edit_form->addElement("hidden",   "commentId",   $postCommentId);
	    $edit_form->addElement("submit",   "imgEdit", mbConvertEncoding($o_resource->getValue("G06007M039"),"SJIS"), array("class"=>"fs12_black"));

		//アンカーラベルを設定(nc:変更なし upd:変更あり add:追加 del:削除)
		$anchorName		= array(
						"nc"	=> "submit",
						"upd"	=> "send",
						"add"	=> "add",
						"del"	=> "del"
						);
		//アンカータグ(href属性, name属性)
		$aTagHref	= array(
						"pre_bef"	=> "<a href='#",
						"pre_af"	=> "'>",
						"suf"		=> "</a>"
						);
		$aTagName	= array(
						"pre"	=> "<a name='",
						"suf"	=> "'/>"
						);
		//アンカーリンク先のタイトル記号
		$titleBar		= "---";
		
	    $mailTo		= MOBILE_MAIL_ADDR;
	    $mailBody	= "layerId="	. $layerId		. "\n"
	    			. "memoId="		. $postMemoId		. "\n"
	    			. "commentId="	. $postCommentId	. "\n"
	    			. "accessKey="	. md5(str_replace("/", "-", $updDate))	. "\n";
	    $mailStr	= "<a href='mailto:" 
	    			. $mailTo 
	    			. "?subject=KakikoMap Image"
	    			. "&body=" . $mailBody . "'>"
	    			. mbConvertEncoding($o_resource->getValue("G06007M033"), "SJIS")
	    			. "</a>";

	    $returnStr	= "<a name='" . $anchorName["nc"] . "' href='getmail.php'>"
	    			. mbConvertEncoding($o_resource->getValue("G06007M039"), "SJIS")
	    			. "</a>";

		//画像ファイルありなしでラベルを変更
		if ($commentRecord->getImageFile_c() != ""){
			//画像あり
			$labelArray = array(
				"imgFile"  => mbConvertEncoding($commentRecord->getImageFile_c(), "SJIS"),
				"label01"  => mbConvertEncoding($o_resource->getValue("G06007M022"), "SJIS"),
				"label02"  => mbConvertEncoding($o_resource->getValue("G06007M023"), "SJIS"),
				"label03"  => $aTagHref["pre_bef"] . $anchorName["nc"] . $aTagHref["pre_af"] . mbConvertEncoding($o_resource->getValue("G06007M025"), "SJIS") . $aTagHref["suf"],
				"label04"  => $aTagHref["pre_bef"] . $anchorName["upd"] . $aTagHref["pre_af"] . mbConvertEncoding($o_resource->getValue("G06007M026"), "SJIS") . $aTagHref["suf"],
				"label05"  => $aTagHref["pre_bef"] . $anchorName["del"] . $aTagHref["pre_af"] . mbConvertEncoding($o_resource->getValue("G06007M027"), "SJIS") . $aTagHref["suf"],
				"label06"  => $aTagName["pre"] . $anchorName["upd"] . $aTagName["suf"] . $titleBar . mbConvertEncoding($o_resource->getValue("G06007M026"), "SJIS") . $titleBar,
				"label07"  => mbConvertEncoding($o_resource->getValue("G06007M030"), "SJIS"),
				"label08"  => mbConvertEncoding($o_resource->getValue("G06007M031"), "SJIS"),
				"label09"  => mbConvertEncoding($o_resource->getValue("G06007M032"), "SJIS"),
				"label10"  => $mailStr,
				"label11"  => mbConvertEncoding($o_resource->getValue("G06007M034"), "SJIS"),
				"label12"  => mbConvertEncoding($o_resource->getValue("G06007M035"), "SJIS"),
				"label13"  => $aTagName["pre"] . $anchorName["del"] . $aTagName["suf"] . $titleBar . mbConvertEncoding($o_resource->getValue("G06007M027"), "SJIS") . $titleBar,
				"label14"  => mbConvertEncoding($o_resource->getValue("G06007M036"), "SJIS"),
				"label15"  => mbConvertEncoding($o_resource->getValue("G06007M037"), "SJIS"),
				"label16"  => $aTagName["pre"] . $anchorName["nc"] . $aTagName["suf"]
			);
		}else{
			//画像なし
			$labelArray = array(
				"imgFile"  => mbConvertEncoding($commentRecord->getImageFile_c(), "SJIS"),
				"label01"  => mbConvertEncoding($o_resource->getValue("G06007M022"), "SJIS"),
				"label02"  => mbConvertEncoding($o_resource->getValue("G06007M024"), "SJIS"),
				"label03"  => $aTagHref["pre_bef"] . $anchorName["nc"] . $aTagHref["pre_af"] . mbConvertEncoding($o_resource->getValue("G06007M028"), "SJIS") . $aTagHref["suf"],
				"label04"  => $aTagHref["pre_bef"] . $anchorName["add"] . $aTagHref["pre_af"] . mbConvertEncoding($o_resource->getValue("G06007M029"), "SJIS") . $aTagHref["suf"],
				"label05"  => "",
				"label06"  => $aTagName["pre"] . $anchorName["add"] . $aTagName["suf"] . $titleBar . mbConvertEncoding($o_resource->getValue("G06007M029"), "SJIS") . $titleBar,
				"label07"  => mbConvertEncoding($o_resource->getValue("G06007M030"), "SJIS"),
				"label08"  => mbConvertEncoding($o_resource->getValue("G06007M031"), "SJIS"),
				"label09"  => "",
				"label10"  => $mailStr,
				"label11"  => mbConvertEncoding($o_resource->getValue("G06007M034"), "SJIS"),
				"label12"  => mbConvertEncoding($o_resource->getValue("G06007M035"), "SJIS"),
				"label13"  => "",
				"label14"  => "",
				"label15"  => "",
				"label16"  => $returnStr
			);
		}

		$edit_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
		$edit_form->accept($edit_renderer);
		$o_smarty->assign("form", $edit_renderer->toArray());

		$tplName	=	DIRECTORY_NAME."/mobileeditcommon.tpl";
	}
}

$o_smarty->assign("labelArray", $labelArray);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display($tplName);

unset($_POST);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要	：メモデータ取得
* 処理詳細	：メモデータ取得
*
* @引数		：	(I) memoid	- メモID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getCommentData($commentid){
 	$viewService	=	new ContentsViewService(DIRECTORY_NAME);
	$commentRecord	=	new MemoDetailPositionTypeData;
	$commentRecord	=	$viewService->getOneCommentData($commentid);
	
	if (is_null($commentRecord)){
		trigger_error("コメント取得エラー。暫定版！！！", E_USER_ERROR);
		return FALSE;
	}

	return $commentRecord;

}

/**
* 関数概要：コンテンツ名取得(SJIS版)
* 処理詳細：コンテンツ名を取得する(文字コードはSJIS)
*
* @引数： なし
* @戻値： 				- コンテンツ名  (encode : SJIS)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function getContName(){
	$contName = null;

	//コンテンツ名を設定
	$viewService = new ContentsViewService(DIRECTORY_NAME);
	$mapData = $viewService->getContentsName();
	$contName = mbConvertEncoding($mapData->getContentsName(), "SJIS");
	
	return $contName;
}

/**
* 関数概要：連想配列の文字列をSJIS変換
* 処理詳細：連想配列の文字列をSJISに変換する
*
* @引数： (I) arrayData	- array  連想配列
* @戻値： array SJIS変換後の配列(連想配列)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function arrayToSJIS($arrayData){
	$tmpArray = array();
	
	foreach($arrayData as $key => $value){
		if(is_array($value)){
			$value = arrayToSJIS($value);
			$tmpArray[$key] = $value;
		}else{
			$tmpArray[$key] = mbConvertEncoding($value,"SJIS");
		}
	}
	
	return $tmpArray;
}

/**
* 関数概要：GET引数取得
* 処理詳細：GET引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function getInfo($arg){
	$returnData	=	null;
	$getData	=	null;
	if (array_key_exists($arg, $_GET)){
		$getData	=	trim($_GET[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要：POSTT引数取得
* 処理詳細：POST引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function postInfo($arg){
	$returnData	=	null;
	$getData	=	null;

	if (array_key_exists($arg, $_POST)){
		$getData	=	trim($_POST[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

?>