<?php
/**
* commentregist.php 処理概要：携帯電話用コメント投稿処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Fujikawa
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("../DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/db/service/ContentsViewService.class.php");
require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("class/xml/RSSController.class.php");			// RSS
require_once("function/KakikoMobileCommon.php");


require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ユーザエージェントチェック
$agent	=	false;

//初期化
$tplName		= "";
$errorMessage = "";
$pageFlg = 0;
$errorRadio = "";
$filecheck = TRUE;

/* テスト用
$dmy = "a";
switch($dmy){
*/
switch(user_agent()){
	case "a":
		$tplName	=	DIRECTORY_NAME."/mobilecommentregist.tpl";
		$agent	=	true;
		break;
	case "d":
	case "v":
		// 座標情報取得

		$linkTag	=	"";

		$labelArray = array(
			"label01"  => getContName(),
			"label02"  => mbConvertEncoding($o_resource->getValue("G06005M001"), "SJIS"),
			"label03"  => mbConvertEncoding($o_resource->getValue("G06005M002"), "SJIS"),
			"label04"  => mbConvertEncoding($o_resource->getValue("G06005M003"), "SJIS")
		);
		$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
		break;
	default:
    	header("location: ../index.php");
	    break;
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

if ($agent){
	
	//初期化
	$layerId = "";
	$memoId = "";
	$commentId = "";
	$newCommentId = "";
	$memoTypeId = "";
	$name = "";
	$title = "";
	$text = "";
	$mail = "";
	$url = "";
	$updDelPwd = "";
	$dataArray = null;
	$updDate = "";
		
	// POST,GET引数取得
	if ($_SERVER["REQUEST_METHOD"] == "POST"){
		// コメント投稿時
		$layerId = postInfo("layerId");
		$memoId = postInfo("memoId");
		$commentId = postInfo("commentId");
		$memoTypeId = postInfo("memoTypeId");
		$name = postInfo("name");
		$title = postInfo("title");
		$text = postInfo("text");
		$mail = postInfo("mail");
		$url = postInfo("url");
		$updDelPwd = postInfo("updDelPwd");
	}else if ($_SERVER["REQUEST_METHOD"] == "GET"){
		// コメント画面に遷移してきた時
		$layerId = getInfo("layerId");
		$memoId = getInfo("memoId");
		$commentId = getInfo("commentId");
		$memoTypeId = getInfo("memoTypeId");
	}
	
	// QuickForm インスタンス化
	$o_form = new HTML_QuickForm("commentRegistForm", "POST", $_SERVER["PHP_SELF"], "_self");

	//情報取得
	if ($memoId != "" && $commentId != "") {
		// コメント情報を取得
		$dataArray = getCommntData($commentId);
	}else{
		// メモ情報を取得
		$dataArray = getMemoData($memoId, $s_UserId);
	}
	
	//SJISに一括置換
	$dataArray = arrayToSJIS($dataArray);
	
	// 入力項目のデフォルトをセット
	$contributor = mbConvertEncoding($o_resource->getValue("G06009L011"), "SJIS");
	if($s_UserName != null){
		$contributor = mbConvertEncoding($s_UserName, "SJIS");
	}
	$o_form->setDefaults(array(
	    "name"      => $contributor,
	    "title"     => "Re:".$dataArray['title'],
	    "text"      => ">".preg_replace("/\n/","\n>", $dataArray['text']),
	    "mail"      => "",
	    "url"       => "",
	    "imgFile"   => "",
	    "updDelPwd" => ""
	));
	
	// 項目セット
	$o_form->addElement("header",   "header",     mbConvertEncoding($o_resource->getValue("G06009L001"), "SJIS"));
	$o_form->addElement("text",     "name",       mbConvertEncoding($o_resource->getValue("G06009L002"), "SJIS"), array("size"=>"20", "maxlength"=>"32", "autocomplete"=>"off", "class"=>"fs16_black"));
	$o_form->addElement("text",     "title",      mbConvertEncoding($o_resource->getValue("G06009L003"), "SJIS"), array("size"=>"20", "maxlength"=>"20", "autocomplete"=>"off", "class"=>"fs16_black"));
	$o_form->addElement("textarea", "text",       mbConvertEncoding($o_resource->getValue("G06009L004"), "SJIS"), array("maxlength"=>"500", "autocomplete"=>"off", "class"=>"fs16_black", "cols"=>"20", "rows"=>"5"));
	$o_form->addElement("text",     "mail",       mbConvertEncoding($o_resource->getValue("G06009L005"), "SJIS"), array("size"=>"20", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs16_black"));
	$o_form->addElement("text",     "url",        mbConvertEncoding($o_resource->getValue("G06009L006"), "SJIS"), array("size"=>"20", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs16_black"));
	$o_form->addElement("password", "updDelPwd",  mbConvertEncoding($o_resource->getValue("G06009L008"), "SJIS"), array("size"=>"4", "maxlength"=>"4", "autocomplete"=>"off", "class"=>"fs16_black"));
	$o_form->addElement("hidden",   "layerId",     $layerId);
	$o_form->addElement("hidden",   "memoId",     $memoId);
	$o_form->addElement("hidden",   "memoTypeId", $memoTypeId);
	$o_form->addElement("hidden",   "commentId",  $commentId);
	
	// 独自チェックルールの定義
	$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');
	
	// チェック項目
	$o_form->addRule("name",      mbConvertEncoding($o_resource->getValue("G06009M001"), "SJIS"), "required");
	$o_form->addRule("name",  	  mbConvertEncoding($o_resource->getValue("G06009M002"), "SJIS"), "maxlength_valid", 32);
	$o_form->addRule("title",     mbConvertEncoding($o_resource->getValue("G06009M003"), "SJIS"), "required");
	$o_form->addRule("title",  	  mbConvertEncoding($o_resource->getValue("G06009M004"), "SJIS"), "maxlength_valid",	20);
	$o_form->addRule("text",  	  mbConvertEncoding($o_resource->getValue("G06009M005"), "SJIS"), "maxlength_valid",	500);
	$o_form->addRule("mail",  	  mbConvertEncoding($o_resource->getValue("G06009M006"), "SJIS"), "email",	null);
	$o_form->addRule("mail",	  mbConvertEncoding($o_resource->getValue("G06009M007"), "SJIS"), "maxlength_valid",	128);
	$o_form->addRule("url",  	  mbConvertEncoding($o_resource->getValue("G06009M008"), "SJIS"), "regex",	"/^(http|https)?(:\/\/([\w-]+\.)+[\w-]+(\/[\w- .\/?%&=]*)?)/");
	$o_form->addRule("url",	      mbConvertEncoding($o_resource->getValue("G06009M009"), "SJIS"), "maxlength_valid",	128);
	$o_form->addRule("updDelPwd", mbConvertEncoding($o_resource->getValue("G06009M010"), "SJIS"), "regex", "/^[a-zA-Z0-9]+$/");
	$o_form->addRule("updDelPwd", mbConvertEncoding($o_resource->getValue("G06009M011"), "SJIS"), "maxlength_valid",	4);
	
	// 登録ボタン
	if (isset($_POST[commentRegist])) {
		
	    // チェックOK
	    if ($o_form->validate() && $filecheck) {
	        $pageFlg = 1;
	        $uploadfileName = "";
			
	        // **************************
	        // DB登録処理実装部
	        // **************************
	        if($commentId == ""){
		        $commentId = 0;        	
	        }
	
			$curDate = date('Y/m/d H:i:s');
			
			// コメント詳細情報
			$detail = new CommentData();
			$detail->setMemoTypeID($memoTypeId);
			$detail->setMemoID($memoId);
			$detail->setCommentID("");
			$detail->setHigherCommentID($commentId);
			$detail->setUserName($name);
			$detail->setCommentTitle($title);
			$detail->setCommentText($text);
			$detail->setMailAddress($mail);
			$detail->setReleteURL($url);
			$detail->setImageFile($uploadfileName);
			$detail->setUpdateDeletePassword($updDelPwd);
			$detail->setAccessCount("0");
			$detail->setDeleteFlg("0");
			$detail->setAddDateTime($curDate);
			$detail->setUpdateDateTime($curDate);
			
			// INSERT
			$service = new ContentsViewService(DIRECTORY_NAME);
			if(!$service->insertCommnetMobile($detail, $newCommentId)){
				trigger_error("DB Error!!", E_USER_ERROR);
			    exit(-1);
			}

			// メール本文内の更新時刻を設定
			$updDate = $curDate;
			
			// RSS出力(携帯は、第３引数にTRUEを入れること)
			$rss = new RSSController($dataArray['layerid'], DIRECTORY_NAME, TRUE);
			if(!$rss->writeRssFile()){
				trigger_error("RSS Error!!", E_USER_ERROR);
			    exit(-1);
			}
	    }
	}
	
	
	// ボタンを表示
	if ($pageFlg == 0) {
	    // 登録画面
	    $o_form->addElement("submit", "commentRegist", mbConvertEncoding($o_resource->getValue("G06009L009"), "SJIS"), array("class"=>"fs12_black"));
	
		$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
		$o_form->accept($o_renderer);
		$o_smarty->assign("form", $o_renderer->toArray());
		$labelArray = array(
	      "label01"  => $o_resource->getValue("G06009M013"),
	      "label02"  => $o_resource->getValue("G06009M014"),
	      "errorFileSize" => $errorFileSize,
	      "errorFileType" => $errorFileType
		);
		//SJISに一括置換
		$labelArray = arrayToSJIS($labelArray);
		
	    $tplName = DIRECTORY_NAME."/mobilecommentregist.tpl";
	
	} else {
	    // 完了画面
	    $mailTo		= MOBILE_MAIL_ADDR;
	    $mailBody	= "layerId="	. $layerId		. "\n"
	    			. "memoId="		. $memoId		. "\n"
	    			. "commentId="	. $newCommentId	. "\n"
	    			. "accessKey="	. md5(str_replace("/", "-", $updDate))	. "\n";
	    $mailStr	= "<a href='mailto:" 
	    			. $mailTo 
	    			. "?subject=KakikoMap Image"
	    			. "&body=" . $mailBody . "'>"
	    			. mbConvertEncoding($o_resource->getValue("G06005M021"), "SJIS")
	    			. "</a>";

	    $returnStr	= "<a href='getmail.php'>"
	    			. mbConvertEncoding($o_resource->getValue("G06005M024"), "SJIS")
	    			. "</a>";

		$labelArray = array(
			"label01"  => mbConvertEncoding($o_resource->getValue("G06005M019"), "SJIS"),
			"label02"  => mbConvertEncoding($o_resource->getValue("G06005M020"), "SJIS"),
			"label03"  => $mailStr,
			"label04"  => mbConvertEncoding($o_resource->getValue("G06005M022"), "SJIS"),
			"label05"  => mbConvertEncoding($o_resource->getValue("G06005M023"), "SJIS"),
			"label06"  => $returnStr
		);
		$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
	}
}

$o_smarty->assign("labelArray", $labelArray);
$o_smarty->assign("errorMessage", $errorMessage);	

$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：コンテンツ名取得(SJIS版)
* 処理詳細：コンテンツ名を取得する(文字コードはSJIS)
*
* @引数： なし
* @戻値： 				- コンテンツ名  (encode : SJIS)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function getContName(){
	$contName = null;

	//コンテンツ名を設定
	$viewService = new ContentsViewService(DIRECTORY_NAME);
	$mapData = $viewService->getContentsName();
	$contName = mbConvertEncoding($mapData->getContentsName(), "SJIS");
	
	return $contName;
}

/**
* 関数概要：連想配列の文字列をSJIS変換
* 処理詳細：連想配列の文字列をSJISに変換する
*
* @引数： (I) arrayData	- array  連想配列
* @戻値： array SJIS変換後の配列(連想配列)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function arrayToSJIS($arrayData){
	$tmpArray = array();
	
	foreach($arrayData as $key => $value){
		if(is_array($value)){
			$value = arrayToSJIS($value);
			$tmpArray[$key] = $value;
		}else{
			$tmpArray[$key] = mbConvertEncoding($value,"SJIS");
		}
	}
	
	return $tmpArray;
}
/**
* 関数概要：GET引数取得
* 処理詳細：GET引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function getInfo($arg){
	$returnData	=	null;
	$getData	=	null;
	if (array_key_exists($arg, $_GET)){
		$getData	=	trim($_GET[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要：POSTT引数取得
* 処理詳細：POST引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function postInfo($arg){
	$returnData	=	null;
	$getData	=	null;

	if (array_key_exists($arg, $_POST)){
		$getData	=	trim($_POST[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}
/**
* 関数概要：メモ引用データ取得
* 処理詳細：メモ引用データを取得する
*
* @引数： (I) memoid	- string  メモID
*         (I) userId    - string  ユーザID
* @戻値： array 詳細情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getMemoData($memoid, $userId){

	$service    = new ContentsViewService(DIRECTORY_NAME);
	$dataObject = $service->getOneMemoDetailViewDataAuth($memoid, $userId);

	$memoData = array(
		"title"	=> $dataObject->getMemoTitle(),
		"text"	=> $dataObject->getMemoText(),
		"layerid"	=> $dataObject->getLayerID()
	);

	return $memoData;
}

/**
* 関数概要：コメント引用データ取得
* 処理詳細：コメント引用データを取得する
*
* @引数： (I) $commentid	- string  コメントID
* @戻値： array 詳細情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getCommntData($commentid){

	$service    = new ContentsViewService(DIRECTORY_NAME);
	$dataObject = $service->getOneCommentData($commentid);

	$commentData = array(
		"title"	=> $dataObject->getCommentTitle(),
		"text"	=> $dataObject->getCommentText(),
		"layerid"	=> $dataObject->getLayerID()
	);
	
	return $commentData;	
}

?>