<?php
/**
* G06-001
* index.php 処理概要：携帯電話用トップページ
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：2007/03/01 (IIS)J.Fujikawa
* @バージョン：1.1.0
*
* Copyright (c) 2006-2007 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

// 前回のセッションが残っている場合があるので、削除
session_start();
$_SESSION = array();
session_destroy();

require_once("../DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");					// リソースファイル読込み
require_once("function/KakikoMobileCommon.php");
require_once("class/db/service/ContentsViewService.class.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// マップ公開区分が非公開(9)の場合公開停止画面へリダイレクト
if(MAP_PUBLIC == 9){
	header("location: ".dirname($_SERVER['PHP_SELF'])."/mobileclosed.html");
	exit(-1);
}
// KAKIKOエンジン使用(非GIS)の場合は携帯から閲覧は不可能とする
if(MAP_TYPE == 1){
	header("location: ".dirname($_SERVER['PHP_SELF'])."/mobileclosed.html");
	exit(-1);
}

$mobileSts = TRUE;

//携帯電話使用可能判定
if (popCheck() == FALSE){
	$labelArray = array(
		"label01"  => getContName(),
		"label02"  => mbConvertEncoding($o_resource->getValue("G06001M013"), "SJIS"),
		"label03"  => mbConvertEncoding($o_resource->getValue("G06001M014"), "SJIS"),
		"label04"  => "",
		"label05"  => "",
		"label06"  => $linkTag
	);

	$mobileSts = FALSE;
	$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
}

if ($mobileSts){
	header("location: ./selectlayer.php");
	exit(-1);
}


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：POP3接続判定
* 処理詳細：メール取得不可の場合、携帯電話機能を使用不可とする
*
* @引数： (I)
* @戻値： bool		- TRUE	正常
*					- FALSE	異常
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function popCheck(){

	$popSts = TRUE;

	if ((POP_SERVER_ADDR == "") || (POP_USER == "") || (POP_PASS == "")){
		return 	FALSE;
	}
		
	// POPサーバ接続・取得
	$sockRes = fsockopen(POP_SERVER_ADDR, 110, $errNo, $errStr, 10);
	if ($sockRes == FALSE){
		return 	FALSE;
	}
	
	$RetCode = fgets($sockRes, 512);
	if(substr($RetCode, 0, 3) != '+OK'){
		$popSts = FALSE;
	}
	
	if (popConnect($sockRes, "USER ".POP_USER) == FALSE){
		$popSts = FALSE;
	}
	if (popConnect($sockRes, "PASS ".POP_PASS) == FALSE){
		$popSts = FALSE;
	}

	// 終了
	popConnect($sockRes, "QUIT");
	fclose($sockRes);

	return 	$popSts;

}
/**
* 関数概要	：POP3コマンド送信
* 処理詳細	：POP3コマンド送信
*
* @引数		：	(I) resource	- ユーザID
*					cmd			- コマンド
*
* @戻値		：	string/bool		- string	正常
*								- FALSE		異常
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function popConnect($resource, $cmd) {
	fputs($resource, $cmd."\r\n");
	$result = fgets($resource, 512);
	if(substr($result, 0, 3) == '+OK') {
		return $result;
	}

	return false;
}

/**
* 関数概要：コンテンツ名取得(SJIS版)
* 処理詳細：コンテンツ名を取得する(文字コードはSJIS)
*
* @引数： なし
* @戻値： 				- コンテンツ名  (encode : SJIS)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function getContName(){
	$contName = null;

	//コンテンツ名を設定
	$viewService = new ContentsViewService(DIRECTORY_NAME);
	$mapData = $viewService->getContentsName();
	$contName = mbConvertEncoding($mapData->getContentsName(), "SJIS");
	
	return $contName;
}

?>