<?php
/**
* main.php 処理概要:携帯用メイン画面処理
* PHP versions : 4.4.2
* @パッケージ : -
* @作者 : (IIS)J.Fujikawa
* @作成日/作成者 : 2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者 :
* @バージョン : 1.0.0
*
* Copyright (c) 2007 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

require_once("../DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");						// リソースファイル読込み
require_once("class/common/MapController.class.php");
require_once("class/db/service/ContentsViewService.class.php");
require_once("function/KakikoMobileCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// セッションから緯度(lat)、経度(lon)、レイヤー選択情報を取得
$s_lat = null;
$s_lon = null;
$s_layerItem = array();
if(isset($_GET['lat']) && isset($_GET['lon'])
		&& ($_GET['lat'] != "") && ($_GET['lon'] != "")){
	$s_lat = $_GET['lat'];
	$s_lon = $_GET['lon'];
	$_SESSION[DIRECTORY_NAME.'_lat'] = $_GET['lat'];
	$_SESSION[DIRECTORY_NAME.'_lon'] = $_GET['lon']; 
}
else if(isset($_SESSION[DIRECTORY_NAME.'_lat']) && isset($_SESSION[DIRECTORY_NAME.'_lon'])){
	$s_lat = $_SESSION[DIRECTORY_NAME.'_lat'];
	$s_lon = $_SESSION[DIRECTORY_NAME.'_lon'];
}
if(isset($_SESSION[DIRECTORY_NAME.'_layerItem'])){
	$s_layerItem = $_SESSION[DIRECTORY_NAME.'_layerItem'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ユーザエージェントチェック
$agent	=	false;
// 初期化
$mapController		= null;		// まっぷコントロールクラスオブジェクト
$scaleString		= null;		// スケール文字列
$mapExt				= null;		// 現在表示されているエリアを表す配列
$layerTableData 	= null;		// 初期位置座標 取得用
$arr				= null;		// 初期位置座標
$memoDataList		= null;		// 表示範囲内のメモ情報一覧
$getImageAddress	= null;		// MapServer要求用アドレス(地図画像取得用)
$tplName			= null;		// テンプレートファイル名
$labelArray			= null;		// ラベル用配列

/* テスト用
$dmy = "a";
switch($dmy){
*/
switch(user_agent()){
	case "a":
		$tplName	=	DIRECTORY_NAME."/mobilemain.tpl";
		$agent	=	true;
		break;
	case "d":
	case "v":
		// 座標情報取得

		$linkTag	=	"";

		$labelArray = array(
			"label01"  => getContName(),
			"label02"  => mbConvertEncoding($o_resource->getValue("G06003M001"), "SJIS"),
			"label03"  => mbConvertEncoding($o_resource->getValue("G06003M002"), "SJIS"),
			"label04"  => mbConvertEncoding($o_resource->getValue("G06003M003"), "SJIS")
		);
		$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
		break;
	default:
    	header("location: ../index.php");
	    break;
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

if ($agent){
	// スケール取得(0:縮小 1:移動(等倍) 2:拡大)
	if(isset($_GET['scale'])){
		$scaleString = $_GET['scale'];
	}else{
		if(MAP_TYPE == 0){
			// GISは「初期表示」固定
			$scaleString = "1";
		}else{
			// カキコエンジンは未対応
		}
	}
	
	// 表示座標の範囲を取得
	// 位置情報が取得できた場合、その位置から表示範囲を求める
	if(isset($_GET['lat']) && isset($_GET['lon'])
		&& ($_GET['lat'] != "") && ($_GET['lon'] != "")){
		$arr = getCenterCoordinate($s_lon, $s_lat, $s_UserId); 
	}
	// 移動とか拡大とかの場合は、GETでmapextを取得する
	elseif(isset($_GET['mapext']) && (!isset($_GET['reset']))){
		$arr = explode(" ", $_GET['mapext']);
	}	
	// セッションに緯度経度が存在する場合は、その座標を使用
	elseif(isset($_SESSION[DIRECTORY_NAME.'_lat'])){
		$arr = getCenterCoordinate($s_lon, $s_lat, $s_UserId);
	}
	// 位置情報が取得できなかった場合、初期座標(設定されていない場合はデフォルト)
	else{
		if($s_UserId == null){
			// ゲストの場合
			$arr = explode(",", MAP_INITPOSITION);
		}else{
			// それ以外	
			$service = new ContentsViewService(DIRECTORY_NAME);
			$layerTableData = $service->getTopPriorityLayerData($s_UserId);
			if($layerTableData == null){
				$arr = explode(",", MAP_INITPOSITION);
			}else{
				if(MAP_TYPE == 0){
					if($layerTableData->getStartX() == null && $layerTableData->getStartY() == null
							&& $layerTableData->getEndX() == null && $layerTableData->getEndY() == null){
						// レイヤー管理者によって初期座標が設定されていない場合はデフォルト
						$arr = explode(",", MAP_INITPOSITION);
					}else{
						$arr = array($layerTableData->getStartX(),
										$layerTableData->getStartY(),
										$layerTableData->getEndX(),
										$layerTableData->getEndY()
									);
					}
				}else{
					//カキコエンジンは未対応
				}
			}
		}
	}
		
	$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);

	// メモ情報取得
	$memoDataList = getMemoInRange($arr, $s_layerItem, $s_UserId);

	// メモを日付の新しい順(降順)にソート
	if(!sortMemoByDate($memoDataList)){
		// エラー処理
	}
	
	// ページング処理
	$rowCount = count($memoDataList);
	$params = array(
	    "perPage"=>MEMOLIST_ROW_MOBILE,
	    "mode"=>"Jumping",
	    "itemData"=>$memoDataList,
	    "totalItems"=>$rowCount,
	    "prevImg"=>mbConvertEncoding($o_resource->getValue("G06003L007"), "SJIS"),
	    "nextImg"=>mbConvertEncoding($o_resource->getValue("G06003L008"), "SJIS"),
	    "httpMethod"=>"GET"
	);
	// PEAR:Pagerを利用
	$o_page = Pager::factory($params);
	// ページ内のデータのみを抽出
	$pageData = $o_page->getPageData();
	// ページ遷移用リンク作成
	$navi = $o_page->getlinks();

	// 画像生成処理に渡すデータ
	$_SESSION[DIRECTORY_NAME.'_pageData'] = $pageData;
	// 画像作成先アドレス
	$getImageAddress="./combinemap.php?pageID=".$o_page->getCurrentPageID().$mapController->get_mapextString();
	
	// リンクタグ
	$aTagHref	= array(
					"pre_bef"	=> "<a href='",
					"pre_af"	=> "'>",
					"suf"		=> "</a>"
					);
	// 地図移動用ラベル
	$moveLabelArray	= array(
					"up"	=> "↑",
					"left"	=> "←",
					"right"	=> "→",
					"down"	=> "↓"
					);
	// 地図縮尺用ラベル
	$scaleLabelArray	= array(
					"zoomIn"	=> "＋",
					"zoomOut"	=> "－"
					);
	// 画面表示用ラベル
	$labelArray = array(
					"mapWidth"	=> MAP_WIDTH_MOBILE,
					"mapHeight"	=> MAP_HEIGHT_MOBILE,
					"loginName"	=> $s_UserName,
					"login"		=> $aTagHref["pre_bef"]."./login.php".$aTagHref["pre_af"].$o_resource->getValue("G06003L001").$aTagHref["suf"],
					"logout"	=> $aTagHref["pre_bef"]."./logout.php".$aTagHref["pre_af"].$o_resource->getValue("G06003L002").$aTagHref["suf"],
					"move"		=> $o_resource->getValue("G06003L003"),
					"scale"		=> $o_resource->getValue("G06003L004"),
					"contName"	=> getContName()
					);
	// ラベル、SJIS変換
	$moveLabelArray		= arrayToSJIS($moveLabelArray);
	$scaleLabelArray	= arrayToSJIS($scaleLabelArray);
	$labelArray			= arrayToSJIS($labelArray);
	
	// GET文字列の配列
	$gisCGIMode = $_SERVER["PHP_SELF"]."?mode=map";
	// 移動リンク作成
	$moveLinkArray = array(
	  "up"        => $aTagHref["pre_bef"].$gisCGIMode."&scale=".$scaleString.$mapController->get_mapextUpString().$aTagHref["pre_af"].$moveLabelArray["up"].$aTagHref["suf"],
	  "left"      => $aTagHref["pre_bef"].$gisCGIMode."&scale=".$scaleString.$mapController->get_mapextLeftString().$aTagHref["pre_af"].$moveLabelArray["left"].$aTagHref["suf"],
	  "right"     => $aTagHref["pre_bef"].$gisCGIMode."&scale=".$scaleString.$mapController->get_mapextRightString().$aTagHref["pre_af"].$moveLabelArray["right"].$aTagHref["suf"],
	  "down"      => $aTagHref["pre_bef"].$gisCGIMode."&scale=".$scaleString.$mapController->get_mapextDownString().$aTagHref["pre_af"].$moveLabelArray["down"].$aTagHref["suf"]
	);
	// 縮尺リンク作成
	$scaleLinkArray = array(
		"zoomIn"	=> $aTagHref["pre_bef"].$gisCGIMode."&scale=".$scaleString.$mapController->get_mapextZoomInStringGIS().$aTagHref["pre_af"].$scaleLabelArray["zoomIn"].$aTagHref["suf"],
		"zoomOut"	=> $aTagHref["pre_bef"].$gisCGIMode."&scale=".$scaleString.$mapController->get_mapextZoomOutStringGIS().$aTagHref["pre_af"].$scaleLabelArray["zoomOut"].$aTagHref["suf"]
		);
	// 投稿リンク作成
	// 本番用
	$registLink = $aTagHref["pre_bef"]."./autogps.php?url=./memoregist.php".$aTagHref["pre_af"].mbConvertEncoding($o_resource->getValue("G06003L009"), "SJIS").$aTagHref["suf"];
//	// テスト用
//	$registLink = $aTagHref["pre_bef"]."./memoregist.php?lat=35.693&lon=139.753".$aTagHref["pre_af"].mbConvertEncoding($o_resource->getValue("G06003L009"), "SJIS").$aTagHref["suf"];

	//レイヤー再選択リンク作成
	$reselectLayerLink = $aTagHref["pre_bef"]."./selectlayer.php".$aTagHref["pre_af"].mbConvertEncoding($o_resource->getValue("G06003L010"), "SJIS").$aTagHref["suf"];
	
	// メモ一覧用データ変換
	$memoArray = getMemoArray($pageData);
	
	$o_smarty->assign("navi", $navi["all"]);
	$o_smarty->assign("getImageAddress", $getImageAddress);
	$o_smarty->assign("labelArray", $labelArray);
	$o_smarty->assign("moveLinkArray", $moveLinkArray);
	$o_smarty->assign("scaleLinkArray", $scaleLinkArray);
	$o_smarty->assign("registLink", $registLink);
	$o_smarty->assign("reselectLayerLink", $reselectLayerLink);
	$o_smarty->assign("memoArray", $memoArray);
	
}

$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################

/**
* 関数概要：連想配列の文字列をSJIS変換
* 処理詳細：連想配列の文字列をSJISに変換する
*
* @引数： (I) arrayData	- array  連想配列
* @戻値： array SJIS変換後の配列(連想配列)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function arrayToSJIS($arrayData){
	$tmpArray = array();
	
	foreach($arrayData as $key => $value){
		if(is_array($value)){
			$value = arrayToSJIS($value);
			$tmpArray[$key] = $value;
		}else{
			$tmpArray[$key] = mbConvertEncoding($value,"SJIS");
		}
	}
	
	return $tmpArray;
}
/**
* 関数概要：GET引数取得
* 処理詳細：GET引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function getInfo($arg){
	$returnData	=	null;
	$getData	=	null;
	if (array_key_exists($arg, $_GET)){
		$getData	=	trim($_GET[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要：POSTT引数取得
* 処理詳細：POST引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function postInfo($arg){
	$returnData	=	null;
	$getData	=	null;

	if (array_key_exists($arg, $_POST)){
		$getData	=	trim($_POST[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要：中心表示情報取得処理
* 処理詳細：指定された座標を中心とする表示範囲の座標(4点)を取得する
*
* @引数： (I) $center_x	- float  中心X座標(経度)
*      ： (I) $center_y	- float  中心Y座標(緯度)
*      ： (I) $userId	- String  ユーザーID
* @戻値： 				- array  四隅の座標の配列
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function getCenterCoordinate ($center_x, $center_y, $userId){
	
	$minx = null;	// 左端
	$miny = null;	// 下端
	$maxx = null;	// 右端
	$maxy = null;	// 上端

	$returnExt = array();
	
	// 中心座標からのX,Y表示幅( = [実際の表示幅/2] ) 単位:度？
	// centerArray[0]=X
	// centerArray[1]=Y	
	$centerArray = null;
	// 表示順で最上位のレイヤーIDを取得する
	$service = new ContentsViewService(DIRECTORY_NAME);
	$layerTableData = null;
	$layerTableData = $service->getTopPriorityLayerData($userId);

	if(MAP_TYPE == 0){
		if($layerTableData->getDiffx() == null && $layerTableData->getDiffy() == null){
			// レイヤー管理者によって初期座標が設定されていない場合はデフォルト
			
			 $centerArray = explode(",", MAP_CENTER_MOBILE);
		}else{
			// 最上位レイヤーの中心表示情報が存在する場合はそちらを取得
			$centerArray = array($layerTableData->getDiffx(), $layerTableData->getDiffy());
		}
	}else{
		// カキコエンジンは未対応
	}

	$minx = round((floatval($center_x) - ($centerArray[0] - 0))*1000000)/1000000;
	$miny = round((floatval($center_y) - ($centerArray[1] - 0))*1000000)/1000000;
	$maxx = round((floatval($center_x) + ($centerArray[0] - 0))*1000000)/1000000;
	$maxy = round((floatval($center_y) + ($centerArray[1] - 0))*1000000)/1000000;

	$returnExt = array(
				$minx,
				$miny,
				$maxx,
				$maxy				
				);
				
	return $returnExt;

}

/**
* 関数概要：指定範囲内のメモ情報取得
* 処理詳細：指定範囲内に存在するメモ情報を取得する
*
* @引数： (I) $mapExt	- array  四隅の座標の配列
*      ： (I) $layerIdList	- array 選択レイヤーID一覧
*      ： (I) $userId	- string ユーザーID(指定なしの場合 null)
* @戻値： 				- array  メモ情報
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function getMemoInRange ($mapExt, $layerIdList, $userId=null){

	$recordData = null;
	$dataList = array();
	$searchArray = array(
		"limit" => null,
		"from"  => null,
		"to"    => null,
		"word"  => null,
		"minx"  => $mapExt[0],
		"miny"  => $mapExt[1],
		"maxx"  => $mapExt[2],
		"maxy"  => $mapExt[3]
	);

	$service = new ContentsViewService(DIRECTORY_NAME);
	
	if($userId == null){
		$recordData = $service->getMapViewMemoDataByGuest($searchArray);
	}else{
		$recordData = $service->getMapViewMemoDataByUser($userId, $searchArray);
	}
	
	// 選択されたレイヤー内のデータのみを配列に格納
	foreach($layerIdList as $layerId){
		foreach($recordData as $data){
			if($data->getLayerID() == $layerId){
				array_push($dataList, $data);
			}
		}
	}
	return $dataList;
}

/**
* 関数概要：画面表示用メモ一覧作成(SJIS版)
* 処理詳細：画面表示用のメモ一覧を作成する(文字コードはSJIS)
*
* @引数： (I) $mapExt	- array  メモデータ
* @戻値： 				- array  表示用メモデータ(encode : SJIS)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function getMemoArray ($memoData){
	$returnArray = array();
	$memoArray = null;
	$count = 0;
	foreach($memoData as $data){
		$count++;
		$memoArray = array(
						"num"		=> $count.":",
						"title"		=> "<a href='./memodetail.php?memoId=".$data->getMemoID()."&commentId=".$data->getCommentID()."'>".$data->getMemoTitle()."</a>",
						"layerName"	=> "(".$data->getLayerName().")",
						"userName"	=> $data->getUserName_d(),
						"date"		=> $data->getAddDateTime_d(),
						);
		// SJIS変換
		$memoArray = arraytoSJIS($memoArray);
		array_push($returnArray,$memoArray);
	}
	
	return $returnArray;
}

/**
* 関数概要：コンテンツ名取得(SJIS版)
* 処理詳細：コンテンツ名を取得する(文字コードはSJIS)
*
* @引数： なし
* @戻値： 				- コンテンツ名  (encode : SJIS)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function getContName(){
	$contName = null;

	//コンテンツ名を設定
	$viewService = new ContentsViewService(DIRECTORY_NAME);
	$mapData = $viewService->getContentsName();
	$contName = mbConvertEncoding($mapData->getContentsName(), "SJIS");
	
	return $contName;
}
// ****************ソート関数**START****************************************
/**
* 関数概要：メモデータを日付順ソート
* 処理詳細：メモデータを日付順にソートする。昇順、降順指定可能(デフォルト:降順)
*
* @引数： (I/O) $object	- array  メモデータ配列
*      ： (I)   $order	- string ソート方法(デフォルト:降順desc) 日付新しい順"desc"、日付古い順"asc"
* @戻値： 				- bool   正常:TRUE 異常:FALSE
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function sortMemoByDate(&$object, $order="desc"){
	return quickSortMemoByDate($object,0,count($object)-1, $order);
}
/**
* 関数概要：クイックソート
* 処理詳細：メモデータを日付順にクイックソートする。昇順、降順指定可能(デフォルト:降順)
*
* @引数： (I/O) $object	- array	メモデータ配列
*      ： (I)   $minIdx	- int	配列の最小インデックス 
*      ： (I)   $maxIdx	- int	配列の最大インデックス
*      ： (I)   $order	- string ソート方法(デフォルト:降順desc) 日付新しい順"desc"、日付古い順"asc"
* @戻値： 				- bool   正常:TRUE (最小と最大インデックスの指定がイコールならnull)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function quickSortMemoByDate(&$object,$minIdx,$maxIdx, $order){
	if($minIdx==$maxIdx){
		return null;
	} 
	$pivotIdx = getPivotMemoByDate($object,$minIdx,$maxIdx, $order);
	if($pivotIdx!=-1){
		if($order == "asc"){
			$partIdx=devideMemoPartitionByDateASC($object,$minIdx,$maxIdx,$object[$pivotIdx]->getAddDateTime_d());
		}else{
			$partIdx=devideMemoPartitionByDateDESC($object,$minIdx,$maxIdx,$object[$pivotIdx]->getAddDateTime_d());
		}
		quickSortMemoByDate($object,$minIdx,$partIdx-1, $order);
		quickSortMemoByDate($object,$partIdx,$maxIdx, $order);
	}
	return TRUE;
}
/**
* 関数概要：ピボット取得
* 処理詳細：クイックソートで使用する基準点(ピボット)を取得する
*
* @引数： (I/O) $object	- array	メモデータ配列
*      ： (I)   $minIdx	- int	配列の最小インデックス 
*      ： (I)   $maxIdx	- int	配列の最大インデックス
*      ： (I)   $order	- string ソート方法(デフォルト:降順desc) 日付新しい順"desc"、日付古い順"asc"
* @戻値： 				- int	ピボット値(配列のインデックス値)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function getPivotMemoByDate(&$object, $minIdx, $maxIdx, $order){
	$pivotIdx = $minIdx + 1;
	while($pivotIdx <= $maxIdx
		&& ($object[$minIdx]->getAddDateTime_d() == $object[$pivotIdx]->getAddDateTime_d())){
		$pivotIdx++;
	} 
	if($pivotIdx > $maxIdx){
		return -1;
	} 
	
	// 以下、配列の最初の方の値を比較し、ピボットを決定する
	if($object[$minIdx]->getAddDateTime_d() >= $object[$pivotIdx]->getAddDateTime_d()){
		// 昇順の場合、日付の新しい方のインデックスをピボットとする
		if($order == "asc"){
			$pivotIdx = $minIdx;
		}
	}
	if($object[$minIdx]->getAddDateTime_d() <= $object[$pivotIdx]->getAddDateTime_d()){
		// 降順の場合、日付の古い方のインデックスをピボットとする
		if($order == "desc"){
			$pivotIdx = $minIdx;    		
		}
	}
	return $pivotIdx;
}
/**
* 関数概要：パーティション分割(昇順)
* 処理詳細：クイックソートで使用。基準となる日付を軸として、それより古い日付と新しい日付に分割する。
* 			基準日付より古い日付は配列の前の方、新しい日付は後ろの方に移動する。
*
* @引数： (I/O) $object	- array		メモデータ配列
*      ： (I)   $minIdx	- int		配列の最小インデックス 
*      ： (I)   $maxIdx	- int		配列の最大インデックス
*      ： (I)   $targetDate	- Date	基準となる日付
* @戻値： 				- int		新しい日付の要素の開始インデックス
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function devideMemoPartitionByDateASC(&$object,$minIdx,$maxIdx,$targetDate){
	$small = $minIdx;
	$big=$maxIdx;

	// 検索が交差するまで繰り返します
	while($small <= $big){

		// 軸要素以上のデータを探します
		while($small <= $maxIdx && $object[$small]->getAddDateTime_d() < $targetDate){
			$small++;
		} 
	
		// 軸要素未満のデータを探します
		while($big >= $minIdx && $object[$big]->getAddDateTime_d() >= $targetDate){
			$big--;
		} 
	
		if($small > $big){
			break;
		} 
		$tmpObj		= $object[$small];
		$object[$small]	= $object[$big];
		$object[$big]	= $tmpObj;
	      
		$small++;
		$big--;
	}
	return $small;
}
/**
* 関数概要：パーティション分割(降順)
* 処理詳細：クイックソートで使用。基準となる日付を軸として、それより古い日付と新しい日付に分割する。
* 			基準日付より新しい日付は配列の前の方、古い日付は後ろの方に移動する。
*
* @引数： (I/O) $object	- array		メモデータ配列
*      ： (I)   $minIdx	- int		配列の最小インデックス 
*      ： (I)   $maxIdx	- int		配列の最大インデックス
*      ： (I)   $targetDate	- Date	基準となる日付
* @戻値： 				- int		古い日付の要素の開始インデックス
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function devideMemoPartitionByDateDESC(&$object,$minIdx,$maxIdx,$targetDate){
	$small = $minIdx;
	$big=$maxIdx;

	// 検索が交差するまで繰り返します
	while($small <= $big){
	
		// 軸要素以上のデータを探します
		while($small <= $maxIdx && $object[$small]->getAddDateTime_d() > $targetDate){
			$small++;
		} 
	
		// 軸要素未満のデータを探します
		while($big >= $minIdx && $object[$big]->getAddDateTime_d() <= $targetDate){
			$big--;
		} 
	
		if($small > $big){
			break;
		} 
		$tmpObj		= $object[$small];
		$object[$small]	= $object[$big];
		$object[$big]	= $tmpObj;
	      
		$small++;
		$big--;
	}
	return $small;
}

// ****************ソート関数**END****************************************
?>
