<?php
/**
* memodetail.php 処理概要：メモ・コメント詳細表示処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Fujikawa
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2007 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("../DefineDirectryName.php");					//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoMobileCommon.php");

require_once("class/db/service/ContentsViewService.class.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}
// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);
// ユーザエージェントチェック
$agent	=	false;

$tplName="";
$labelArray="";
$getMemoId = "";
$getCommentId = "";

/* テスト用
$dmy = "a";
switch($dmy){
*/
switch(user_agent()){
	case "a":
		$tplName = DIRECTORY_NAME."/mobilememodetail.tpl";
		$agent = true;
		break;
	case "d":
	case "v":
		// 座標情報取得

		$linkTag	=	"";

		$labelArray = array(
			"label01"  => "Contents Name",
			"label02"  => mbConvertEncoding($o_resource->getValue("G06006M001"), "SJIS"),
			"label03"  => mbConvertEncoding($o_resource->getValue("G06006M002"), "SJIS"),
			"label04"  => mbConvertEncoding($o_resource->getValue("G06006M003"), "SJIS")
		);
		$tplName = DIRECTORY_NAME."/mobilecommon.tpl";
		break;
	default:
    	header("location: ../index.php");
	    break;
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("memoDetailForm", "POST", "./checkpasswd.php", "_self");
// smarty インスタンス化
$o_smarty = new KakikoSmarty();

if ($agent){
	if($_SERVER["REQUEST_METHOD"] == "GET"){
		$getMemoId		=	getInfo("memoId");
		$getCommentId	=	getInfo("commentId");
	}
	// 入力項目のデフォルトをセット
	$o_form->setDefaults(array(
	    "updDelPwd" => ""
	));

	// input 項目セット
	$o_form->addElement("password", "updDelPwd", mbConvertEncoding($o_resource->getValue("G06006L001"),"SJIS"), array("size"=>"4", "maxlength"=>"4", "format"=>"4x", "class"=>"fs14_black"));

	// チェック項目
	$o_form->addRule("updDelPwd", mbConvertEncoding($o_resource->getValue("G06006M004"),"SJIS"), "regex", "/^[a-zA-Z0-9]+$/");
	$o_form->addRule("updDelPwd", mbConvertEncoding($o_resource->getValue("G06006M005"),"SJIS"), "maxlength_valid",	4);
	
	// 独自チェックルールの定義
	$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

	// 一時変数初期化
	$errorMessage = "";
	$pageFlg = 0;
	
	// ボタンを表示
	if ($pageFlg == 0) {
	    // メモ表示画面
	
		$dataArray = null;
		// 詳細情報を取得
		if(!empty($getCommentId)){
			$dataArray = getCommentDetailData($getCommentId);
		}else{
			$dataArray = getMemoDetailData($getMemoId, $s_UserId);
		}
		//SJIS変換
		$dataArray = arraytoSJIS($dataArray);

		$labelArray = array("header"     => mbConvertEncoding($o_resource->getValue("G06006L002"),"SJIS"),
				          "addDateTime"   => mbConvertEncoding($o_resource->getValue("G06006L003"),"SJIS").$dataArray['addDateTime'],
				          "layerMemoType" => "(" . $dataArray['layerName']." / ".$dataArray['memoTypeName'].")",
				          "memoIcon"      => $dataArray['icon'],
				          "memoColor"     => "#".$dataArray['ribbon'],
				          "memoName"      => $dataArray['memoTitle'],
				          "userName"      => $dataArray['userName'],
				          "mailAddress"   => $dataArray['mailAddress'],
				          "releteUrl"     => $dataArray['url'],
				          "labelUrl"     => mbConvertEncoding($o_resource->getValue("G06006L004"),"SJIS"),
				          "memoText"      => explode("\n", $dataArray['text']),
				          "imgFile"       => $dataArray['imgFile'],
				          "mapmove"		  => mbConvertEncoding($o_resource->getValue("G06006L005"),"SJIS"),
				          "comment"		  => mbConvertEncoding($o_resource->getValue("G06006L006"),"SJIS"),
				          "contName"	  => getContName()
				         );
	    $o_smarty->assign("labelArray", $labelArray);
	    $o_smarty->assign("dataArray", $dataArray);
	
		// スレッドを取得
		$tplCommentArray = getTreeData($getMemoId,$getCommentId);
		
	    $o_smarty->assign("tplCommentArray", $tplCommentArray);
	
		$o_form->addElement("hidden", "layerid",    $dataArray['layerid']);
		$o_form->addElement("hidden", "memoId",     $getMemoId);
		$o_form->addElement("hidden", "memoTypeId", $dataArray['memoTypeId']);
		$o_form->addElement("hidden", "commentId",  $getCommentId);
	    $o_form->addElement("submit", "update",     mbConvertEncoding($o_resource->getValue("G06006L007"),"SJIS"));
	    $o_form->addElement("submit", "delete",     mbConvertEncoding($o_resource->getValue("G06006L008"),"SJIS"));

		$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
		$o_form->accept($o_renderer);
		$o_smarty->assign("form", $o_renderer->toArray());
	
		$o_smarty->assign("errorMessage", $errorMessage);
	
	} else {
	    // 修正画面へPOST
		
		// POST
	
	}
}

$o_smarty->display($tplName);



//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ詳細データ取得
* 処理詳細：メモ詳細データを取得する
*
* @引数： (I) memoid	- string  メモID
*         (I) userId    - string  ユーザID
* @戻値： array 詳細情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getMemoDetailData($memoid, $userId){

	$service = new ContentsViewService(DIRECTORY_NAME);
	$dataObject = $service->getOneMemoDetailViewDataAuth($memoid, $userId);

	// アイコンタイプでアドレス切り替え
	$iconPath = "";
	if($dataObject->getIconType() == 0){
		$iconPath = "../../../img/icon/".$dataObject->getIcon();
	}else{
		$iconPath = "../img/icon/".$dataObject->getIcon();
	}
	// イメージパス
	$imgPath = "";
	if($dataObject->getImageFile_d() != ""){
		//createthumbnail.phpから見た画像パスを記述する。
		$imgPath = "./img/memo/".$dataObject->getImageFile_d();
	}

	$memoData = array(
		"longitude"    => $dataObject->getLongitude(),
		"latitude"     => $dataObject->getLatitude(),
		"addDateTime"  => $dataObject->getAddDateTime_d(),
		"layerid"      => $dataObject->getLayerID(),
		"layerName"    => $dataObject->getLayerName(),
		"memoTypeId"   => $dataObject->getMemoTypeID(),
		"memoTypeName" => $dataObject->getMemoTypeName(),
		"icon"         => $iconPath,
		"ribbon"       => $dataObject->getRibbonColor(),
		"userName"     => $dataObject->getUserName_d(),
		"memoTitle"	   => $dataObject->getMemoTitle(),
		"text"         => $dataObject->getMemoText(),
		"mailAddress"  => $dataObject->getMailAddress_d(),
		"url"          => $dataObject->getReleteURL_d(),
		"imgFile"      => $imgPath,
		"updDelPwd"    => $dataObject->getUpdateDeletePassword_d()
	);

	return $memoData;
}

/**
* 関数概要：コメント詳細データ取得
* 処理詳細：コメント詳細データを取得する
*
* @引数： (I) commentid	- string  コメントID
* @戻値： array 詳細情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getCommentDetailData($commentid){

	$service = new ContentsViewService(DIRECTORY_NAME);
	$dataObject = $service->getOneCommentData($commentid);

	// アイコンタイプでアドレス切り替え
	$iconPath = "";
	if($dataObject->getIconType() == 0){
		$iconPath = "../../../img/icon/".$dataObject->getIcon();
	}else{
		$iconPath = "../img/icon/".$dataObject->getIcon();
	}

	// イメージパス
	$imgPath = "";
	if($dataObject->getImageFile_c() != ""){
		//createthumbnail.phpから見た画像パスを記述する。
		$imgPath = "./img/memo/".$dataObject->getImageFile_c();
	}

	$commentData = array(
		"longitude"    => $dataObject->getLongitude(),
		"latitude"     => $dataObject->getLatitude(),
		"addDateTime"  => $dataObject->getAddDateTime_c(),
		"layerid"      => $dataObject->getLayerID(),
		"layerName"    => $dataObject->getLayerName(),
		"memoTypeId"   => $dataObject->getMemoTypeID(),
		"memoTypeName" => $dataObject->getMemoTypeName(),
		"icon"         => $iconPath,
		"ribbon"       => $dataObject->getRibbonColor(),
		"userName"     => $dataObject->getUserName_c(),
		"memoTitle"	   => $dataObject->getCommentTitle(),
		"text"         => $dataObject->getCommentText(),
		"mailAddress"  => $dataObject->getMailAddress_c(),
		"url"          => $dataObject->getReleteURL_c(),
		"imgFile"      => $imgPath,
		"updDelPwd"    => $dataObject->getUpdateDeletePassword_c()
	);
	
	return $commentData;
}

/**
* 関数概要：ツリーデータ取得
* 処理詳細：ツリーデータ（スレッド）を取得する
*
* @引数： (I) memoId	- string  メモID
*  　　　 (I) commentId - string  コメントID
* @戻値： array ツリー情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：2007/03/01 (IIS)J.Fujikawa
* @更新内容：
*/
function getTreeData($memoId,$commentId){

	$service = new ContentsViewService(DIRECTORY_NAME);
	$dataArray = $service->getAllMemoCommentTreeDataByKey($memoId);

	$treeData = array();
	foreach($dataArray as $record){

		$linkString = "";
		if(($commentId == "" && $record->getNodeLevel() != 1) 
					|| ($record->getCommentID() != $commentId)){
			if($record->getNodeLevel() == 1){
				$linkString = $_SERVER["PHP_SELF"]
						."?memoId=".$record->getMemoID();
			}else{
				$linkString = $_SERVER["PHP_SELF"]
						."?memoId=".$record->getMemoID()
						."&commentId=".$record->getCommentID();
			}
		}
		$dotString = str_repeat("・ ", $record->getNodeLevel() - 1);

		$recordData = array(
			"commentId"	      => $record->getCommentID(),
			"highercommentid" => $record->getHigherCommentID(),
			"dot"             => $dotString,
			"title"	          => $record->getTitle(),
			"username"        => $record->getUserName(),
			"adddatetime"     => $record->getAddDatetime(),
			"link"            => $linkString
		);

		//SJIS変換
		$recordData = arrayToSJIS($recordData);
		
		array_push($treeData, $recordData);
	}

	return $treeData;

}

/**
* 関数概要：コンテンツ名取得(SJIS版)
* 処理詳細：コンテンツ名を取得する(文字コードはSJIS)
*
* @引数： なし
* @戻値： 				- コンテンツ名  (encode : SJIS)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function getContName(){
	$contName = null;

	//コンテンツ名を設定
	$viewService = new ContentsViewService(DIRECTORY_NAME);
	$mapData = $viewService->getContentsName();
	$contName = mbConvertEncoding($mapData->getContentsName(), "SJIS");
	
	return $contName;
}

/**
* 関数概要：連想配列の文字列をSJIS変換
* 処理詳細：連想配列の文字列をSJISに変換する
*
* @引数： (I) arrayData	- array  連想配列
* @戻値： array SJIS変換後の配列(連想配列)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function arrayToSJIS($arrayData){
	$tmpArray = array();
	
	foreach($arrayData as $key => $value){
		if(is_array($value)){
			$value = arrayToSJIS($value);
			$tmpArray[$key] = $value;
		}else{
			$tmpArray[$key] = mbConvertEncoding($value,"SJIS");
		}
	}
	
	return $tmpArray;
}

/**
* 関数概要：GET引数取得
* 処理詳細：GET引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function getInfo($arg){
	$returnData	=	null;
	$getData	=	null;
	if (array_key_exists($arg, $_GET)){
		$getData	=	trim($_GET[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要：POSTT引数取得
* 処理詳細：POST引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function postInfo($arg){
	$returnData	=	null;
	$getData	=	null;

	if (array_key_exists($arg, $_POST)){
		$getData	=	trim($_POST[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

?>