<?php
/**
* memoregist.php 処理概要：メモ修正処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Fujikawa
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2007 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("../DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/db/service/ContentsViewService.class.php");
require_once("class/db/tabledata/MemoDetailData.class.php");
require_once("class/db/tabledata/MemoPositionData.class.php");
require_once("class/db/tabledata/CommentData.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoMobileCommon.php");
require_once("class/xml/RSSController.class.php");			// RSS

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// レイヤー選択情報を取得
$s_layerItem = null;
if(isset($_SESSION[DIRECTORY_NAME.'_layerItem'])){
	$s_layerItem = array();
	$s_layerItem = $_SESSION[DIRECTORY_NAME.'_layerItem'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);
// ユーザエージェントチェック
$agent	=	false;

$labelArray = "";
$errorMessage	= "";
$pageFlg		= 0;
$tplName		= "";
$errorFileSize	= "";
$errorFileType	= "";
$filecheck		= TRUE;

$targetTypeId	=	"";

/* テスト用
$dmy = "a";
switch($dmy){
*/
switch(user_agent()){
	case "a":
		$tplName = DIRECTORY_NAME."/mobilememoedit.tpl";
		$agent = true;
		break;
	case "d":
	case "v":
		// 座標情報取得

		$linkTag	=	"";

		$labelArray = array(
			"label01"  => getContName(),
			"label02"  => mbConvertEncoding($o_resource->getValue("G06006M001"), "SJIS"),
			"label03"  => mbConvertEncoding($o_resource->getValue("G06006M002"), "SJIS"),
			"label04"  => mbConvertEncoding($o_resource->getValue("G06006M003"), "SJIS")
		);
		$tplName = DIRECTORY_NAME."/mobilecommon.tpl";
		break;
	default:
    	header("location: ../index.php");
	    break;
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("memoEditForm", "POST", $_SERVER["PHP_SELF"], "_self");

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

if($agent){
	//初期化
	$memoDetailRecord = null;
	$postMemoId		= "";
	$postName		= "";
	$postTitle		= "";
	$postText	    = "";
	$postMail		= "";
	$postUrl		= "";
	$postUpddelpwd	= "";
	$updDate		= "";
	
	//POST引数取得
	if ($_SERVER["REQUEST_METHOD"] == "POST"){
		if ((array_key_exists( "memoId",	$_POST))
			&& (array_key_exists( "name",	$_POST))
			&& (array_key_exists( "title",	$_POST))
			&& (array_key_exists( "text",	$_POST))
			&& (array_key_exists( "mail",	$_POST))
			&& (array_key_exists( "url",	$_POST))
			&& (array_key_exists( "updDelPwd",	$_POST))){
			$postMemoId		= postInfo("memoId");
			$postName		= postInfo("name");
			$postTitle		= postInfo("title");
			$postText	    = postInfo("text");
			$postMail		= postInfo("mail");
			$postUrl		= postInfo("url");
			$postUpddelpwd	= postInfo("updDelPwd");
	
			// 詳細情報を取得
			$memoDetailRecord = new MemoDetailPositionTypeData;
			$memoDetailRecord = getMemoData($postMemoId, $s_UserId);
			if ($memoDetailRecord == FALSE){
				//対象データなし
				trigger_error($o_resource->getValue("G06007M020"), E_USER_ERROR);
				exit();
			}
		}else{
			//アクセスエラー（引数なし）
			trigger_error(mbConvertEncoding($o_resource->getValue("G06007M019"),"SJIS"), E_USER_ERROR);
	    	exit(-1);
		}
	}else if ($_SERVER["REQUEST_METHOD"] == "GET"){
		if ((array_key_exists( "memoId",	$_GET))){
			$postMemoId		=	getInfo("memoId");
	
			// 詳細情報を取得
			$memoDetailRecord = new MemoDetailPositionTypeData;
			$memoDetailRecord = getMemoData($postMemoId, $s_UserId);
			if ($memoDetailRecord == FALSE){
				//対象データなし
				trigger_error(mbConvertEncoding($o_resource->getValue("G06007M020"),"SJIS"), E_USER_ERROR);
				exit();
			}
		}else{
			//アクセスエラー（引数なし）
			trigger_error(mbConvertEncoding($o_resource->getValue("G06007M019"),"SJIS"), E_USER_ERROR);
	    	exit(-1);
		}
	}else{
		//METHODエラー
		trigger_error(mbConvertEncoding($o_resource->getValue("G06007M019"),"SJIS"), E_USER_ERROR);
		exit();
	}
		
	// 項目セット
	$o_form->addElement("header",   "header",    mbConvertEncoding($o_resource->getValue("G06007L001"),"SJIS"));
	$o_form->addElement("text",     "name",      mbConvertEncoding($o_resource->getValue("G06007L002"),"SJIS"), array("size"=>"20", "maxlength"=>"32", "autocomplete"=>"off", "class"=>"fs16_black"));
	$o_form->addElement("text",     "title",     mbConvertEncoding($o_resource->getValue("G06007L003"),"SJIS"), array("size"=>"20", "maxlength"=>"20", "autocomplete"=>"off", "class"=>"fs16_black"));
	$o_form->addElement("textarea", "text",      mbConvertEncoding($o_resource->getValue("G06007L004"),"SJIS"), array("maxlength"=>"500", "autocomplete"=>"off", "class"=>"fs16_black", "cols"=>"20", "rows"=>"5"));
	$o_form->addElement("text",     "mail",      mbConvertEncoding($o_resource->getValue("G06007L005"),"SJIS"), array("size"=>"20", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs16_black"));
	$o_form->addElement("text",     "url",       mbConvertEncoding($o_resource->getValue("G06007L006"),"SJIS"), array("size"=>"20", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs16_black"));
	
	$o_form->addElement("text",     "imgFile",   mbConvertEncoding($o_resource->getValue("G06007L007"),"SJIS"));
	$o_form->addElement("password", "updDelPwd", mbConvertEncoding($o_resource->getValue("G06007L008"),"SJIS"), array("size"=>"4", "maxlength"=>"4", "autocomplete"=>"off", "class"=>""));
	$o_form->addElement("text",     "selectMemoType",mbConvertEncoding($o_resource->getValue("G06007L009"),"SJIS"));
	//画像ファイルありなしラベル作成
	if ($memoDetailRecord->getImageFile_d() != ""){
		$o_form->addElement("text",     "currentImg",mbConvertEncoding($o_resource->getValue("G06007L012"),"SJIS"));
	}else{
		$o_form->addElement("text",     "currentImg",mbConvertEncoding($o_resource->getValue("G06007L013"),"SJIS"));
	}
	
	// 独自チェックルールの定義
	$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');
	
	// チェック項目
	$o_form->addRule("name",      mbConvertEncoding($o_resource->getValue("G06007M001"),"SJIS"), "required");
	$o_form->addRule("name",  	  mbConvertEncoding($o_resource->getValue("G06007M002"),"SJIS"), "maxlength_valid",   32);
	$o_form->addRule("title",     mbConvertEncoding($o_resource->getValue("G06007M003"),"SJIS"), "required");
	$o_form->addRule("title",  	  mbConvertEncoding($o_resource->getValue("G06007M004"),"SJIS"), "maxlength_valid",	20);
	$o_form->addRule("text",  	  mbConvertEncoding($o_resource->getValue("G06007M005"),"SJIS"), "maxlength_valid",	500);
	$o_form->addRule("mail",  	  mbConvertEncoding($o_resource->getValue("G06007M006"),"SJIS"), "email",	null);
	$o_form->addRule("mail",	  mbConvertEncoding($o_resource->getValue("G06007M007"),"SJIS"), "maxlength_valid",	128);
	$o_form->addRule("url",  	  mbConvertEncoding($o_resource->getValue("G06007M008"),"SJIS"), "regex",	"/^(http|https)?(:\/\/([\w-]+\.)+[\w-]+(\/[\w- .\/?%&=]*)?)/");
	$o_form->addRule("url",	      mbConvertEncoding($o_resource->getValue("G06007M009"),"SJIS"), "maxlength_valid",	128);
	$o_form->addRule("updDelPwd", mbConvertEncoding($o_resource->getValue("G06007M010"),"SJIS"), "regex", "/^[a-zA-Z0-9]+$/");
	$o_form->addRule("updDelPwd", mbConvertEncoding($o_resource->getValue("G06007M011"),"SJIS"), "maxlength_valid",	4);
	
	// 登録ボタン
	if (array_key_exists( "memoEdit", $_POST)){
	
	    // 妥当性チェック
		if (array_key_exists( "memoType", $_POST)) {
	    	$targetTypeId	=	postInfo("memoType");
	    }else{
			$errorMemoType = mbConvertEncoding($o_resource->getValue("G06007M015"), "SJIS");
	    }
	
	    // チェックOK
	    if (($o_form->validate()) && $errorMemoType =="") {
	
			$uploadDir = "../img/memo/";
			$uploadfileName	=	"";
		
	        // **************************
	        // DB登録処理実装部
	        // **************************
	
			$idArray = explode("_", postInfo("memoType"));
	
			$setArray	=	array(
								"memoid"		=> $postMemoId,
								"memotypeid"	=> $idArray[1],
								"name"			=> $postName,
								"title"			=> $postTitle,
								"memotext"		=> $postText,
								"mail"			=> $postMail,
								"url"			=> $postUrl,
								"filename"		=> $uploadfileName,
								"upddelpwd"		=> $postUpddelpwd,
								"count"			=> $memoDetailRecord->getAccessCount_d() + 1
							);
	
			// UPDATE
			$viewService = new ContentsViewService(DIRECTORY_NAME);
	
			//更新列の設定
			// メモ詳細情報
			$targetDetail = new MemoDetailData();
			$targetDetail->setMemoID(WHERE_KEY);
			$targetDetail->setMemoTypeID(VAL_TARGET);
			$targetDetail->setUserName(VAL_TARGET);
			$targetDetail->setMemoTitle(VAL_TARGET);
			$targetDetail->setMemoText(VAL_TARGET);
			$targetDetail->setMailAddress(VAL_TARGET);
			$targetDetail->setReleteURL(VAL_TARGET);
			//imageFileは更新対象としない
//			$targetDetail->setImageFile(VAL_TARGET);
			$targetDetail->setUpdateDeletePassword(VAL_TARGET);
			$targetDetail->setAccessCount(VAL_TARGET);
			$targetDetail->setUpdateDateTime(VAL_TARGET);
	
			// メモ位置情報
			$targetPosition = new MemoPositionData();
			$targetPosition->setMemoID(WHERE_KEY);
			$targetPosition->setMemoTypeID(VAL_TARGET);
			$targetPosition->setUpdateDateTime(VAL_TARGET);
	
			// コメント情報
			$targetComment = new CommentData();
			$targetComment->setMemoID(WHERE_KEY);
			$targetComment->setMemoTypeID(VAL_TARGET);
			$targetComment->setUpdateDateTime(VAL_TARGET);
	
	
			if ($viewService->updateMemoCommentDataByKeyMobile($targetDetail, $targetPosition, $targetComment, $setArray, $updDate) == FALSE){
				trigger_error("Update Error", E_USER_ERROR);
				exit(-1);
			}
			// RSS出力(携帯は、第３引数にTRUEを入れること)
			$rss = new RSSController($idArray[0], DIRECTORY_NAME, TRUE);
			if(!$rss->writeRssFile()){
				trigger_error("RSS Error!!", E_USER_ERROR);
			    exit(-1);
			}
	
			$pageFlg = 1;
	    }
	}else{
	
		// 入力項目のデフォルトをセット
		//SJIS一括置換
		$o_form->setDefaults(
			arrayToSJIS(
				array(
			    	"name"      => $memoDetailRecord->getUserName_d(),
			    	"title"     => $memoDetailRecord->getMemoTitle(),
			    	"text"      => $memoDetailRecord->getMemoText(),
			    	"mail"      => $memoDetailRecord->getMailAddress_d(),
			    	"url"       => $memoDetailRecord->getReleteURL_d(),
			    	"imgFile"   => $memoDetailRecord->getImageFile_d(),
			    	"updDelPwd" => $memoDetailRecord->getUpdateDeletePassword_d()
				)
			)
		);
	
		//メモ種類の初期値設定
		$targetTypeId	=	$memoDetailRecord->getLayerID() . "_" . $memoDetailRecord->getMemoTypeID();
	
	}
	
	// ボタンを表示
	if ($pageFlg == 0) {
	    // 登録画面
	 	$o_form->addElement("hidden", "memoId", $postMemoId);
	    $o_form->addElement("submit", "memoEdit", mbConvertEncoding($o_resource->getValue("G06007L010"),"SJIS"), array("class"=>"fs12_black"));
	
		$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
		$o_form->accept($o_renderer);
		$o_smarty->assign("form", $o_renderer->toArray());
		$labelArray = array(
	      "label01"  => $o_resource->getValue("G06007M012"),
	      "label02"  => $o_resource->getValue("G06007M013"),
	      "label03"  => $o_resource->getValue("G06007M014"),
	      "errorFileSize" => $errorFileSize,
	      "errorFileType" => $errorFileType,
	      "contName" => getContName(),
	      "layerName" => "(" . $memoDetailRecord->getLayerName() . "/" . $memoDetailRecord->getMemoTypeName().")"
		);
		
		//SJIS一括変換
		$labelArray = arrayToSJIS($labelArray);
		
		$o_smarty->assign("radioArray", $radioArray);
	    $o_smarty->assign("radioId", $targetTypeId);
	
		// メモ種類ラジオボタン取得
		$layerMemoTypeArray = getLayerMemoTypeData($s_UserId, $s_layerItem);
		$o_smarty->assign("layerMemoTypeArray", $layerMemoTypeArray);
		
	} else {
	    // 完了画面
	    //フォームを作成
		$edit_form = new HTML_QuickForm("imageEditForm", "POST", "./getmail.php", "_self");
		// 項目セット
		$edit_form->addElement("checkbox", "delete",   "", mbConvertEncoding($o_resource->getValue("G06007M038"),"SJIS"));
	 	$edit_form->addElement("hidden",   "memoId",   $postMemoId);
	    $edit_form->addElement("submit",   "imgEdit", mbConvertEncoding($o_resource->getValue("G06007M039"),"SJIS"), array("class"=>"fs12_black"));

		//アンカーラベルを設定(nc:変更なし upd:変更あり add:追加 del:削除)
		$anchorName		= array(
						"nc"	=> "submit",
						"upd"	=> "send",
						"add"	=> "add",
						"del"	=> "del"
						);
		//アンカータグ(href属性, name属性)
		$aTagHref	= array(
						"pre_bef"	=> "<a href='#",
						"pre_af"	=> "'>",
						"suf"		=> "</a>"
						);
		$aTagName	= array(
						"pre"	=> "<a name='",
						"suf"	=> "'/>"
						);
		//アンカーリンク先のタイトル記号
		$titleBar		= "---";
		
	    $mailTo		= MOBILE_MAIL_ADDR;
	    $mailBody	= "layerId="	. $layerId		. "\n"
	    			. "memoId="		. $postMemoId		. "\n"
	    			. "commentId="	. $commentId	. "\n"
	    			. "accessKey="	. md5(str_replace("/", "-", $updDate))	. "\n";
	    $mailStr	= "<a href='mailto:" 
	    			. $mailTo 
	    			. "?subject=KakikoMap Image"
	    			. "&body=" . $mailBody . "'>"
	    			. mbConvertEncoding($o_resource->getValue("G06007M033"), "SJIS")
	    			. "</a>";

	    $returnStr	= "<a name='" . $anchorName["nc"] . "' href='getmail.php'>"
	    			. mbConvertEncoding($o_resource->getValue("G06007M039"), "SJIS")
	    			. "</a>";
		
		//画像ファイルありなしでラベルを変更
		if ($memoDetailRecord->getImageFile_d() != ""){
			//画像あり
			$labelArray = array(
				"imgFile"  => mbConvertEncoding($memoDetailRecord->getImageFile_d(), "SJIS"),
				"label01"  => mbConvertEncoding($o_resource->getValue("G06007M021"), "SJIS"),
				"label02"  => mbConvertEncoding($o_resource->getValue("G06007M023"), "SJIS"),
				"label03"  => $aTagHref["pre_bef"] . $anchorName["nc"] . $aTagHref["pre_af"] . mbConvertEncoding($o_resource->getValue("G06007M025"), "SJIS") . $aTagHref["suf"],
				"label04"  => $aTagHref["pre_bef"] . $anchorName["upd"] . $aTagHref["pre_af"] . mbConvertEncoding($o_resource->getValue("G06007M026"), "SJIS") . $aTagHref["suf"],
				"label05"  => $aTagHref["pre_bef"] . $anchorName["del"] . $aTagHref["pre_af"] . mbConvertEncoding($o_resource->getValue("G06007M027"), "SJIS") . $aTagHref["suf"],
				"label06"  => $aTagName["pre"] . $anchorName["upd"] . $aTagName["suf"] . $titleBar . mbConvertEncoding($o_resource->getValue("G06007M026"), "SJIS") . $titleBar,
				"label07"  => mbConvertEncoding($o_resource->getValue("G06007M030"), "SJIS"),
				"label08"  => mbConvertEncoding($o_resource->getValue("G06007M031"), "SJIS"),
				"label09"  => mbConvertEncoding($o_resource->getValue("G06007M032"), "SJIS"),
				"label10"  => $mailStr,
				"label11"  => mbConvertEncoding($o_resource->getValue("G06007M034"), "SJIS"),
				"label12"  => mbConvertEncoding($o_resource->getValue("G06007M035"), "SJIS"),
				"label13"  => $aTagName["pre"] . $anchorName["del"] . $aTagName["suf"] . $titleBar . mbConvertEncoding($o_resource->getValue("G06007M027"), "SJIS") . $titleBar,
				"label14"  => mbConvertEncoding($o_resource->getValue("G06007M036"), "SJIS"),
				"label15"  => mbConvertEncoding($o_resource->getValue("G06007M037"), "SJIS"),
				"label16"  => $aTagName["pre"] . $anchorName["nc"] . $aTagName["suf"]
			);
		}else{
			//画像なし
			$labelArray = array(
				"imgFile"  => mbConvertEncoding($memoDetailRecord->getImageFile_d(), "SJIS"),
				"label01"  => mbConvertEncoding($o_resource->getValue("G06007M021"), "SJIS"),
				"label02"  => mbConvertEncoding($o_resource->getValue("G06007M024"), "SJIS"),
				"label03"  => $aTagHref["pre_bef"] . $anchorName["nc"] . $aTagHref["pre_af"] . mbConvertEncoding($o_resource->getValue("G06007M028"), "SJIS") . $aTagHref["suf"],
				"label04"  => $aTagHref["pre_bef"] . $anchorName["add"] . $aTagHref["pre_af"] . mbConvertEncoding($o_resource->getValue("G06007M029"), "SJIS") . $aTagHref["suf"],
				"label05"  => "",
				"label06"  => $aTagName["pre"] . $anchorName["add"] . $aTagName["suf"] . $titleBar . mbConvertEncoding($o_resource->getValue("G06007M029"), "SJIS") . $titleBar,
				"label07"  => mbConvertEncoding($o_resource->getValue("G06007M030"), "SJIS"),
				"label08"  => mbConvertEncoding($o_resource->getValue("G06007M031"), "SJIS"),
				"label09"  => "",
				"label10"  => $mailStr,
				"label11"  => mbConvertEncoding($o_resource->getValue("G06007M034"), "SJIS"),
				"label12"  => mbConvertEncoding($o_resource->getValue("G06007M035"), "SJIS"),
				"label13"  => "",
				"label14"  => "",
				"label15"  => "",
				"label16"  => $returnStr
			);
		}

		$edit_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
		$edit_form->accept($edit_renderer);
		$o_smarty->assign("form", $edit_renderer->toArray());

		$tplName	=	DIRECTORY_NAME."/mobileeditcommon.tpl";

	}
}

$o_smarty->assign("labelArray", $labelArray);
$o_smarty->assign("errorMessage", $errorMemoType);

$o_smarty->display($tplName);

unset($_POST);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ種類データ取得
* 処理詳細：メモ種類データを取得・整形する
*
* @引数： (I) userid	- string  ユーザID
* @戻値： array メモ種類情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：2007/03/01 (IIS)J.Fujikawa
* @更新内容：チェックボックスで選択されたレイヤーIDの中から、リストを取得する。
*/
function getLayerMemoTypeData($userid, $selLayer) {

	$service = new ContentsViewService(DIRECTORY_NAME);
	
	$recordData = null;
	if($userid == null){
		$recordData = $service->getMapControllDataByGuest(2);
	}else{
		$recordData = $service->getMapControllDataByUser($userid, 2);
	}

	$layerMemoTypeList = array();
	$memoArrayList = array();
	$layerId = "";
	$layerName ="";

	//チェックボックスで選択されたレイヤーIDの中から、リストを取得する。
	foreach($selLayer as $lay){
		foreach($recordData as $data){
			if($data->getLayerID() == $lay){
				// レイヤーIDごとのリストを生成する
				if($layerId != "" && $layerId != $data->getLayerID()){
					$layerArray = array(
									'layerid'  => mbConvertEncoding($layerId , "SJIS") , 
									'layername'  => mbConvertEncoding($layerName , "SJIS"),
									$memoArrayList);
					array_push($layerMemoTypeList, $layerArray);
					$memoArrayList = array();
				}
				$layerId = mbConvertEncoding($data->getLayerID() , "SJIS");
				$layerName = mbConvertEncoding($data->getLayerName() , "SJIS");
				
				// アイコンタイプでアドレス切り替え
				$iconPath = "";
				if($data->getIconType() == 0){
					$iconPath = "../../../img/icon/".$data->getIcon();
				}else{
					$iconPath = "../img/icon/".$data->getIcon();
				}
				$memoArray = array(
					'typeid'   => mbConvertEncoding($data->getMemoTypeID() , "SJIS"),
					'typename' => mbConvertEncoding($data->getMemoTypeName() , "SJIS"),
					'ico'       => mbConvertEncoding($iconPath , "SJIS"),
					'ribbon'   => mbConvertEncoding($data->getRibbonColor() , "SJIS")
				);
				array_push($memoArrayList, $memoArray);						
			}
		}
	}
	if($layerId != ""){
		$layerArray = array(
						'layerid'  => $layerId, 
						'layername'  => $layerName,
					$memoArrayList);
		array_push($layerMemoTypeList, $layerArray);
	}			
	return $layerMemoTypeList;	
}

/**
* 関数概要	：メモデータ取得
* 処理詳細	：メモデータ取得
*
* @引数		：	(I) memoid	- メモID
*               (I) userId  - ユーザID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getMemoData($memoid, $userId){
 	$viewService		=	new ContentsViewService(DIRECTORY_NAME);
	$memoDetailRecord	=	new MemoDetailPositionTypeData;
	$memoDetailRecord	=	$viewService->getOneMemoDetailViewDataAuth($memoid, $userId);
	
	if (is_null($memoDetailRecord)){
		trigger_error("Memo Data Invalid Error!!", E_USER_ERROR);
		return FALSE;
	}

	return $memoDetailRecord;

}

/**
* 関数概要：コンテンツ名取得(SJIS版)
* 処理詳細：コンテンツ名を取得する(文字コードはSJIS)
*
* @引数： なし
* @戻値： 				- コンテンツ名  (encode : SJIS)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function getContName(){
	$contName = null;

	//コンテンツ名を設定
	$viewService = new ContentsViewService(DIRECTORY_NAME);
	$mapData = $viewService->getContentsName();
	$contName = mbConvertEncoding($mapData->getContentsName(), "SJIS");
	
	return $contName;
}

/**
* 関数概要：連想配列の文字列をSJIS変換
* 処理詳細：連想配列の文字列をSJISに変換する
*
* @引数： (I) arrayData	- array  連想配列
* @戻値： array SJIS変換後の配列(連想配列)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function arrayToSJIS($arrayData){
	$tmpArray = array();
	
	foreach($arrayData as $key => $value){
		if(is_array($value)){
			$value = arrayToSJIS($value);
			$tmpArray[$key] = $value;
		}else{
			$tmpArray[$key] = mbConvertEncoding($value,"SJIS");
		}
	}
	
	return $tmpArray;
}

/**
* 関数概要：GET引数取得
* 処理詳細：GET引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function getInfo($arg){
	$returnData	=	null;
	$getData	=	null;
	if (array_key_exists($arg, $_GET)){
		$getData	=	trim($_GET[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要：POSTT引数取得
* 処理詳細：POST引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function postInfo($arg){
	$returnData	=	null;
	$getData	=	null;

	if (array_key_exists($arg, $_POST)){
		$getData	=	trim($_POST[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

?>