<?php
/**
* G06-002
* selectlayer.php 処理概要：携帯電話用レイヤー選択
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：2006/03/01 (IIS)J.Fujikawa
* @バージョン：1.1.0
*
* Copyright (c) 2006-2007 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("../DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");					// リソースファイル読込み
require_once("function/KakikoMobileCommon.php");
require_once("class/db/service/ContentsViewService.class.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// ログイン処理
if(!isset($_SESSION['LOGINMODE'])){
	if(MAP_AUTOLOGIN == 1){
		require_once("./userauth.php");
	}
	// SESSIONに「LOGINMODE」を設定
	$_SESSION['LOGINMODE'] = MAP_AUTOLOGIN;
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
	
// ユーザエージェントチェック
$agent	=	false;

/* テスト用
$dmy = "a";
switch($dmy){
*/
switch(user_agent()){
	case "a":
		$labelArray = array(
			"label01"  => getContName(),
			"label02"  => mbConvertEncoding($o_resource->getValue("G06002L001"), "SJIS"),
			"label03"  => mbConvertEncoding($o_resource->getValue("G06002L002"), "SJIS"),
			"label04"  => mbConvertEncoding($o_resource->getValue("G06002L003"), "SJIS")
		);
		$tplName	=	DIRECTORY_NAME."/mobileselectlayer.tpl";
		$agent	=	true;
		break;
	case "d":
	case "v":
		// 座標情報取得

		$linkTag	=	"";

		$labelArray = array(
			"label01"  => getContName(),
			"label02"  => mbConvertEncoding($o_resource->getValue("G06002M001"), "SJIS"),
			"label03"  => mbConvertEncoding($o_resource->getValue("G06002M002"), "SJIS"),
			"label04"  => mbConvertEncoding($o_resource->getValue("G06002M003"), "SJIS")
		);
		$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
		break;
	default:
    	header("location: ../index.php");
	    break;
}

if ($agent){
	if ($_SERVER["REQUEST_METHOD"] == "GET"){
	}else{
//		// テスト用にセッションに固定座標を設定(本番では、lat,lon取得は不要)
//		$_SESSION[DIRECTORY_NAME.'_lat'] = 35.693;
//		$_SESSION[DIRECTORY_NAME.'_lon'] = 139.753;
		$_SESSION[DIRECTORY_NAME.'_layerItem'] = $_POST["layerItem"];
	}

	// QuickForm インスタンス化
	$o_form = new HTML_QuickForm("selectForm", "post", $_SERVER['PHP_SELF'], "_self");
	$o_form->addRule("layerItem",  mbConvertEncoding($o_resource->getValue("G06002M005"), "SJIS"), "required");

	// 決定ボタン
	if (array_key_exists( "sendBtn", $_POST)){

		if ($_POST[layerItem] == ""){
			$errorMessage = mbConvertEncoding($o_resource->getValue("G06002M005"), "SJIS");
		}else{
			// Redirect
// テスト用と本番(autogps.php)を切り替えて使用
			$redireUrl = "./autogps.php?url=./main.php";
//			$redireUrl = "./main.php?lat=&lon=";
			header("location: " . $redireUrl);
			exit();
		}
	}

	// レイヤー情報取得
	$layerArray	=	getLayerList($s_UserId);

	if (is_null($layerArray)){
		$errorMessage = mbConvertEncoding($o_resource->getValue("G06002M006"), "SJIS");
	}else{
		$o_form->addElement("submit", "sendBtn", mbConvertEncoding($o_resource->getValue("G06002L004"), "SJIS"), array("class"=>"fs12_black"));

		$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
		$o_form->accept($o_renderer);
		$o_smarty->assign("layer_checkboxes", $layerArray);
		$o_smarty->assign("layer_id", $layerItem);
		$o_smarty->assign("form", $o_renderer->toArray());
	}
}
$o_smarty->assign("errormessage", $errorMessage);
$o_smarty->assign("labelArray", $labelArray);
$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：コンテンツ名取得(SJIS版)
* 処理詳細：コンテンツ名を取得する(文字コードはSJIS)
*
* @引数： なし
* @戻値： 				- コンテンツ名  (encode : SJIS)
* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
* @更新日/更新者：
* @更新内容：
*/
function getContName(){
	$contName = null;

	//コンテンツ名を設定
	$viewService = new ContentsViewService(DIRECTORY_NAME);
	$mapData = $viewService->getContentsName();
	$contName = mbConvertEncoding($mapData->getContentsName(), "SJIS");
	
	return $contName;
}

/**
* 関数概要：GET引数取得
* 処理詳細：GET引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function getInfo($arg){
	$returnData	=	null;
	$getData	=	null;
	if (array_key_exists($arg, $_GET)){
		$getData	=	trim($_GET[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
/*
			$getData	=	trim($_GET[$arg]);

			if (preg_match("/^\d{1,3}\.\d{1,2}\.\d{1,2}\.\d{1,2}$/", $getData)){
				$dataArray = explode(".", $getData);
				if (count($dataArray) == 4){
					$returnData = 
						$dataArray[0] + $dataArray[1]/60 + $dataArray[2]/3600 + $dataArray[3]/360000;
				}
			}
*/
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要：POSTT引数取得
* 処理詳細：POST引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function postInfo($arg){
	$returnData	=	null;
	$getData	=	null;

	if (array_key_exists($arg, $_POST)){
		$getData	=	trim($_POST[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要	：レイヤーデータ取得
* 処理詳細	：レイヤーデータ取得
*
* @引数		：	(I) userid	- ユーザID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：2007/03/01 (IIS)J.Fujikawa
* @更新内容	：
*/
function getLayerList($userid){
 
  	$viewService		=	new ContentsViewService(DIRECTORY_NAME);

	if($userid == null){
		$layerRecord = $viewService->getMapControllDataByGuest(1);
	}else{
		$layerRecord = $viewService->getMapControllDataByUser($userid, 1);
	}
	if (is_null($layerRecord)){
		$retArray = null;
	}else{
		$retArray = array();
		for($i=0; $i<count($layerRecord);$i++){
			$retArray[$layerRecord[$i]->getlayerID()] = 
				mbConvertEncoding($layerRecord[$i]->getLayerName(), "SJIS"); 
		}
	}

	return $retArray;

}

/**
* 関数概要：POP3接続判定
* 処理詳細：メール取得不可の場合、携帯電話機能を使用不可とする
*
* @引数： (I)
* @戻値： bool		- TRUE	正常
*					- FALSE	異常
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function popCheck(){

	$popSts = TRUE;

	if ((POP_SERVER_ADDR == "") || (POP_USER == "") || (POP_PASS == "")){
		return 	FALSE;
	}
		
	// POPサーバ接続・取得
	$sockRes = fsockopen(POP_SERVER_ADDR, 110, $errNo, $errStr, 10);
	if ($sockRes == FALSE){
		return 	FALSE;
	}
	
	$RetCode = fgets($sockRes, 512);
	if(substr($RetCode, 0, 3) != '+OK'){
		$popSts = FALSE;
	}
	
	if (popConnect($sockRes, "USER ".POP_USER) == FALSE){
		$popSts = FALSE;
	}
	if (popConnect($sockRes, "PASS ".POP_PASS) == FALSE){
		$popSts = FALSE;
	}

	// 終了
	popConnect($sockRes, "QUIT");
	fclose($sockRes);

	return 	$popSts;

}
/**
* 関数概要	：POP3コマンド送信
* 処理詳細	：POP3コマンド送信
*
* @引数		：	(I) resource	- ユーザID
*					cmd			- コマンド
*
* @戻値		：	string/bool		- string	正常
*								- FALSE		異常
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function popConnect($resource, $cmd) {
	fputs($resource, $cmd."\r\n");
	$result = fgets($resource, 512);
	if(substr($result, 0, 3) == '+OK') {
		return $result;
	}

	return false;
}

?>