<?php
/**
* G05-001
* userrequest.php 処理概要：ゲスト参加要求
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)j.hashimoto
* @作成日/作成者：2006/09/01 (IIS)j.hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/

require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");					// リソースファイル読込み
require_once("function/Common.php");
require_once("function/KakikoContentsCommon.php");
require_once("class/mail/KakikoMail.class.php");					// メール送信クラス

require_once("class/db/service/ContentsAdminService.class.php");	//DBアクセスサービスクラス
//require_once("class/db/service/ContentsViewService.class.php");	//DBアクセスサービスクラス

require_once("class/db/tabledata/LayerData.class.php");			//TABLE DATAクラス
require_once("class/db/tabledata/LayerUserData.class.php");		//TABLE DATAクラス
require_once("class/db/tabledata/UserData.class.php");				//TABLE DATAクラス

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
		trigger_error($o_resource->getValue("G05001M009"), E_USER_ERROR);
    	exit(-1);
}

//initialize
$paramLayer	=	"";

//引数取得
// LayerID
//GET引数取得
if ($_SERVER["REQUEST_METHOD"] == "GET"){
	if (array_key_exists( "layerID", $_GET)){
		$paramLayer	=	$_GET["layerID"];
	}else{
		//異常アクセス（引数なし）
		trigger_error($o_resource->getValue("G05001M009"), E_USER_ERROR);
    	exit(-1);
	}
}else{
	//POST引数取得
	if ($_SERVER["REQUEST_METHOD"] == "POST"){
		if (array_key_exists( "layerID", $_POST)){
			$paramLayer	=	$_POST["layerID"];
		}else{
			//異常アクセス（引数なし）
			trigger_error($o_resource->getValue("G05001M009"), E_USER_ERROR);
	    	exit(-1);
		}
	}
}

//LayerID Check
if ($paramLayer != ""){
	if (selectLayerName($paramLayer, $layerLbl, $addUserSts) == FALSE){
		trigger_error($o_resource->getValue("G05001M007"), E_USER_ERROR);
		$o_db->disconnect();
		exit();
	}
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("requestguest", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(
			array(
				"layerName"				=>	$layerLbl,
				"mailAddress"			=>	"",
				"confirmMailAddress"	=>	""
			)
);

// 項目セット
$o_form->addElement("static", "layerName",			$o_resource->getValue("G05001L002"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text", "mailAddress",			$o_resource->getValue("G05001L003"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text", "confirmMailAddress",	$o_resource->getValue("G05001L004"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("hidden",	"layerID",			$paramLayer);

// チェック項目
$o_form->addRule("mailAddress",			$o_resource->getValue("G05001M002"), "required");
$o_form->addRule("mailAddress",			$o_resource->getValue("G05001M003"), "email");
$o_form->addRule("confirmMailAddress",	$o_resource->getValue("G05001M004"), "required");
$o_form->addRule("confirmMailAddress",	$o_resource->getValue("G05001M005"), "email");
$o_form->addRule( array("mailAddress","confirmMailAddress"), $o_resource->getValue("G05001M006"), "compare", NULL);

$errorMessage = "";
$pageFlg = 0;

// 登録ボタン
if (isset($_POST[sendButton])) {
	// 妥当性チェック
	if ($o_form->validate()) {
		// 管理者情報取得
		$adminService = new ContentsAdminService(DIRECTORY_NAME);
		if ($adminService->getMailUserInfo(null, $userName, $adminMailAddress, $contentsName) == FALSE){
			// 管理者情報取得エラー
			trigger_error($o_resource->getValue("G05001M015"), E_USER_ERROR);
			exit();
		}else{
			if ($adminMailAddress == ""){
				// 管理者情報取得エラー
				trigger_error($o_resource->getValue("G05001M015"), E_USER_ERROR);
				exit();
			}
		}
		
		// メール送信用定数
		$sendMode               =  "smtp";     //phpmail,sendmail,smtp

		//本登録用URL生成
		$mailUrl = getProtocol()	.	$_SERVER["SERVER_NAME"]
								.	dirname($_SERVER["PHP_SELF"])
								.	"/userregistreqfix.php?id="	.	$paramLayer
								.	"&key="	.	md5($_POST["mailAddress"]);
		//処理
		$userregistreqMessage	= "\n" 
								. $_POST["mailAddress"] . $o_resource->getValue("G05001M010")
								. "\n\n" 
								. $o_resource->getValue("G05001M013")
								. "\n" 
								. $o_resource->getValue("G05001M014")
								. "\n\n" 
								. $mailUrl;

		$mailitems = array(
						'ToAddress'		=> $_POST["mailAddress"],		//送信先アドレス
						'ToName'			=> $_POST["mailAddress"] . $o_resource->getValue("G05001M010"),			//送信先名称
						'FromAddress'		=> $adminMailAddress,			//送信元アドレス
						'FromName'			=> $contentsName . $o_resource->getValue("G05001M011"),					//送信元名称
						'ReplyTo' 			=> $adminMailAddress,			//返信先アドレス
						'Subject' 			=> $o_resource->getValue("G05001M012"),		//件名
						'Message' 			=> $userregistreqMessage,		//本文
					);

		//メール送信
		$o_email = new KakikoMail();
		$o_email->createMail($mailitems);

/*
print_r($mailitems);
print("<br>");
print "送信先アドレス: ".$o_email->toAddress."<br>";
print "送信先名称: ".$o_email->toName."<br>";
print "送信元アドレス: ".$o_email->fromAddress."<br>";
print "送信元名称: ".$o_email->fromName."<br>";
print "返信先アドレス: ".$o_email->replyTo."<br>";
print "件名: ".$o_email->subject."<br>";
print "本文: ".$o_email->message."<br>";
*/

		$ret = $o_email->sendEmail($sendMode);
		if (PEAR::isError($ret)){
			trigger_error($o_resource->getValue("G05001M016"), E_USER_ERROR);
			exit();
		}

		//処理
		$pageFlg = 1;
	}
}

// ボタンを表示
if ($pageFlg == 0) {
    // 参加要求画面
    $o_form->addElement("submit",	"sendButton",	$o_resource->getValue("G05001L005"),	array("class"=>"fs12_black"));
    $o_form->addElement("reset",	"resetButton",	$o_resource->getValue("G05001L006"),	array("class"=>"fs12_black"));
    $o_form->addElement("button",	"backButton",	$o_resource->getValue("G05001L007"),	array("onclick"=>"history.back();", "class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
    $o_smarty->assign("header",		$o_resource->getValue("G05001L001"));
	$o_smarty->assign("form"        , $o_renderer->toArray());
	$o_smarty->assign("errorMessage", $errorMessage);

    $o_smarty->assign("messeage",		$o_resource->getValue("G05001M001"));

   	$tplName = DIRECTORY_NAME . "/requestguest.tpl";
} else {
     // 完了画面
    $o_smarty->assign("header",			$o_resource->getValue("G05002L001"));
    $o_smarty->assign("backButton",		$o_resource->getValue("G05002L002"));
    $o_smarty->assign("layerNameLbl",	$o_resource->getValue("G05002L003"));
    $o_smarty->assign("mailAddressLbl",	$o_resource->getValue("G05002L004"));
    $o_smarty->assign("layerName",		$layerLbl);
    $o_smarty->assign("mailAddress",	htmlspecialchars($_POST["mailAddress"]));
    $o_smarty->assign("message1",		htmlspecialchars($_POST["mailAddress"]) . $o_resource->getValue("G05002M001"));
    $o_smarty->assign("message2",		$o_resource->getValue("G05002M002"));
//    $o_smarty->assign("backButton",				$o_resource->getValue("G05004L002"),	array("onclick"=>"location.href='index.php'", "class"=>"fs12_black"));
 
    $tplName = DIRECTORY_NAME . "/requestguestfin.tpl";
}

// DB 開放
//$o_db->disconnect();


$o_smarty->display($tplName);

unset($_POST);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要	：レイヤー名称取得
* 処理詳細	：レイヤー名称取得
*
* @引数		：	(I) layerID	- レイヤーID）
*			：	(O) name	- レイヤー名称
*			：	(O) userSts	- ユーザ登録認証区分
*
* @戻値		：	boolean  TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function selectLayerName($layerid, &$name, &$userSts){

	$adminService = new ContentsAdminService(DIRECTORY_NAME);
	$layerRecord = new LayerData;

	$layerRecord = $adminService->getLayerDataFindByLayerID($layerid);

	if (is_null($layerRecord)  == false){
		$name = $layerRecord->getLayerName();
		if ($layerRecord->getAddAttestUser() == KAKIKOMAP_ADDATTESTUSER_ON){;
			$userSts = KAKIKOMAP_ADDATTESTUSER_ON;	//認証なし
		}else{
			$userSts = KAKIKOMAP_ADDATTESTUSER_OFF;	//認証あり
		}
	}else{
		return FALSE;
	}
		
	return TRUE;

}

?>
