<?php
/**
* G04-011
* userrequest.php 処理概要：ユーザ参加要求
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)j.hashimoto
* @作成日/作成者：2006/09/01 (IIS)j.hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/

require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");					// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("class/db/service/ContentsAdminService.class.php");	//DBアクセスサービスクラス
//require_once("class/db/service/ContentsViewService.class.php");	//DBアクセスサービスクラス

require_once("class/db/tabledata/LayerData.class.php");			//TABLE DATAクラス
require_once("class/db/tabledata/LayerUserData.class.php");		//TABLE DATAクラス
require_once("class/db/tabledata/UserData.class.php");				//TABLE DATAクラス

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

//initialize
$errorMessage	=	"";
$pageFlg		=	0;
$paramLayer		=	"";
$paramUser		=	"";
$paramMail		=	"";

//ユーザID取得
if (array_key_exists(DIRECTORY_NAME."_userid", $_SESSION)){
	$paramUser	=	$_SESSION[DIRECTORY_NAME.'_userid'];
}else{
	//ゲストユーザ
   header("location: ./index.php");
}

//引数取得
// LayerID
//GET引数取得
if ($_SERVER["REQUEST_METHOD"] == "GET"){
	if (array_key_exists( "layerID", $_GET)){
		$paramLayer	=	$_GET["layerID"];
	}else{
		//異常アクセス（引数なし）
		trigger_error($o_resource->getValue("G04011M003"), E_USER_ERROR);
    	exit(-1);
	}
}else{
	//POST引数取得
	if ($_SERVER["REQUEST_METHOD"] == "POST"){
		if (array_key_exists( "layerID", $_POST)){ 
			$paramLayer	=	$_POST["layerID"];
		}else{
			//異常アクセス（引数なし）
			trigger_error($o_resource->getValue("G04011M003"), E_USER_ERROR);
	    	exit(-1);
		}
	}
}

//LayerID Check
if ($paramLayer != ""){
	if (selectLayerName($paramLayer, $layerLbl, $addUserSts) == FALSE){
		trigger_error($o_resource->getValue("G04011M004"), E_USER_ERROR);
		exit();
	}
}

//UserId Check
if ($paramUser != ""){
	if (checkUserID($paramUser, $paramMail) == FALSE){
		trigger_error($o_resource->getValue("G04011M001"), E_USER_ERROR);
		exit();
	}

	if (checkLayerUser($paramUser, $paramLayer) == FALSE){
		$errorMessage	=	$o_resource->getValue("G04011M005");
	}
}else{
	trigger_error($o_resource->getValue("G04011M001"), E_USER_ERROR);
	exit();
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
// QuickForm インスタンス化
$o_form = new HTML_QuickForm("requestmember", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(
			array(
				"layerName"		=>	$layerLbl,
				"userId"		=>	$paramUser,
				"mailAddress"	=>	$paramMail,
				"note"			=>	""
			)
);

// 項目セット
$o_form->addElement("hidden",	"layerID",	$paramLayer);
//$o_form->addElement("hidden",	"userID",	$paramUser);
//$o_form->addElement("hidden",	"mail",		$paramMail);


// 登録ボタン
if ((isset($_POST[sendButton])) && ($errorMessage == "")){

	// 登録処理
	if (insertRecord($addUserSts, $paramLayer, $paramUser)){
		//処理
		$pageFlg = 1;
	}else{
		trigger_error($o_resource->getValue("G04011M006"), E_USER_ERROR);
		exit();
	}
}

// ボタンを表示
if ($pageFlg == 0) {
    // 参加要求画面
	$o_form->addElement("static",	"layerName",	$o_resource->getValue("G04011L002"),	array("class"=>"fs12_black"));
	$o_form->addElement("static",	"userId",		$o_resource->getValue("G04011L003"),	array("class"=>"fs12_black"));
	$o_form->addElement("static",	"mailAddress",	$o_resource->getValue("G04011L004"),	array("class"=>"fs12_black"));
	$o_form->addElement("hidden",	"mailAddr",	$paramMail);
	$o_form->addElement("textarea",	"note",			$o_resource->getValue("G04011L005"), array("cols"=>"40", "rows"=>"5", "autocomplete"=>"off", "class"=>"fs12_black"));

	if ($errorMessage == ""){
		$o_form->addElement("submit",	"sendButton",	$o_resource->getValue("G04011L006"),	array("class"=>"fs12_black"));
		$o_form->addElement("reset",	"resetButton",	$o_resource->getValue("G04011L007"),	array("class"=>"fs12_black"));
	}
	$o_form->addElement("button",	"backButton",	$o_resource->getValue("G04011L008"),	array("onclick"=>"history.back();", "class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
    $o_smarty->assign("header",		$o_resource->getValue("G04011L001"));
	$o_smarty->assign("form",		$o_renderer->toArray());
	$o_smarty->assign("errorMessage", $errorMessage);

   	$tplName = DIRECTORY_NAME . "/requestmember.tpl";
} else {
     // 完了画面
    $o_smarty->assign("header",		$o_resource->getValue("G04012L001"));
    $o_smarty->assign("message1",	htmlspecialchars($_POST["mailAddr"]) . $o_resource->getValue("G05004M001"));

    $o_smarty->assign("message2",	$o_resource->getValue("G05004M002"),		array("class"=>"fs12_black"));

    $o_smarty->assign("layerNameLbl",	$o_resource->getValue("G04012L002"),	array("class"=>"fs12_black"));
    $o_smarty->assign("userIdLbl",		$o_resource->getValue("G04012L003"),	array("class"=>"fs12_black"));
    $o_smarty->assign("mailAddressLbl",	$o_resource->getValue("G04012L004"),	array("class"=>"fs12_black"));
    $o_smarty->assign("noteLbl",		$o_resource->getValue("G04012L005"),	array("class"=>"fs12_black"));
    $o_smarty->assign("statusLbl",		$o_resource->getValue("G04012L006"),	array("class"=>"fs12_black"));
 
    $o_smarty->assign("layerName",		$paramLayer,	array("class"=>"fs12_black"));
    $o_smarty->assign("userId",			$paramUser,		array("class"=>"fs12_black"));
    $o_smarty->assign("mailAddress",	$paramMail,		array("class"=>"fs12_black"));
    $o_smarty->assign("note",			nl2br($_POST["note"]),	array("class"=>"fs12_black"));
    $o_smarty->assign("status",			$o_resource->getValue("G04012M004"),	array("class"=>"fs12_black"));

    $o_smarty->assign("backButton",	$o_resource->getValue("G04012L007"));
 
    $tplName = DIRECTORY_NAME . "/requestmemberfin.tpl";
}

// DB 開放
//$o_db->disconnect();


$o_smarty->display($tplName);

unset($_POST);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要	：レイヤー名称取得
* 処理詳細	：レイヤー名称、ユーザ登録認証区分取得
*
* @引数		：	(I) layerID	- レイヤーID）
*			：	(O) name	- レイヤー名称
*			：	(O) userSts	- ユーザ登録認証区分
*
* @戻値		：	boolean  TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function selectLayerName($layerid, &$name, &$userSts){

	$adminService = new ContentsAdminService(DIRECTORY_NAME);
	$layerRecord = new LayerData;

	$layerRecord = $adminService->getLayerDataFindByLayerID($layerid);

	if (is_null($layerRecord)  == false){
		$name = $layerRecord->getLayerName();
		if ($layerRecord->getAddAttestUser() == KAKIKOMAP_ADDATTESTUSER_ON){;
			$userSts = KAKIKOMAP_ADDATTESTUSER_ON;	//認証なし
		}else{
			$userSts = KAKIKOMAP_ADDATTESTUSER_OFF;	//認証あり
		}
	}else{
		return FALSE;
	}
		
	return TRUE;

}

/**
* 関数概要	：ユーザID存在チェック
* 処理詳細	：存在チェック、メールアドレス取得
*
* @引数		：	(I) userID	- ユーザID
*				(O) mail	- 取得メールアドレス
*
* @戻値		：	boolean  TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function checkUserID($userid, &$mail){

	$adminService = new ContentsAdminService(DIRECTORY_NAME);

	$result = $adminService->getUserInfoData($userid);

	if (count($result) == 0){
		return	FALSE;
	}
	
	$mail = $result -> getMailAddress();

	return TRUE;

}

/**
* 関数概要	：レイヤーユーザ存在チェック
* 処理詳細	：存在チェック
*
* @引数		：	(I) userID		- ユーザID
*				(I) layerid		- レイヤーID
*
* @戻値		：	boolean  TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/

function checkLayerUser($userid, $layerid){

	$adminService = new ContentsAdminService(DIRECTORY_NAME);

	if ($adminService->checkLayerUserDataByKey($userid, $layerid) == FALSE){
		return FALSE;
	}
	return TRUE;
}

/**
* 関数概要：ユーザ登録処理
* 処理詳細：レイヤーユーザを新規に登録する
*
* @引数		：	(I) userSts	- ユーザ登録認証区分
*			：	(I) layerID	- レイヤーID
*			：	(I) userid	- ユーザID
*
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function insertRecord($userSts, $layerid, $userid){

	$adminService = new ContentsAdminService(DIRECTORY_NAME);

	//LayerUserTable
	$layerUserData = new LayerUserData();
	$layerUserData ->setUserID($userid);
	$layerUserData ->setLayerID($layerid);
	$layerUserData ->setStatusFlg($userSts);
	$layerUserData ->setAddDateTime(date('Y/m/d H:i:s'));

	if ($adminService->insertUser(NULL, $layerUserData) == FALSE){
		return FALSE;
	}

	return TRUE;
}

?>
