<?php
/**
* G05-005
* userregistreqfix.php 処理概要：ユーザ本登録
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)j.hashimoto
* @作成日/作成者：2006/09/01 (IIS)j.hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");					// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("class/db/service/ContentsAdminService.class.php");	//DBアクセスサービスクラス

require_once("class/db/tabledata/LayerUserData.class.php");		//TABLE DATAクラス
require_once("class/db/tabledata/UserData.class.php");				//TABLE DATAクラス
require_once("class/common/KakikoTableName.class.php");			// マップ別テーブル名称取得クラス

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
	// アクセス許可エラー
	trigger_error($o_resource->getValue("G05005M021"), E_USER_ERROR);
	exit();
}

$layerID = "";
$layerLbl = "---";
$compareKey = "";

//引数取得
// LayerID,MailAddressのMD5
// LayerIDがNULL：コンテンツユーザ、NOT NULL：レイヤーユーザ
//GET引数取得
if ($_SERVER["REQUEST_METHOD"] == "GET"){
	if ((array_key_exists( "id", $_GET)) && (array_key_exists( "key", $_GET))){
		//mod	0:コンテンツユーザ、1:レイヤーユーザ
		$layerID	=	trim($_GET["id"]);
		$compareKey	=	trim($_GET["key"]);
	}else{
		//異常アクセス（引数なし）
		trigger_error($o_resource->getValue("G05005M021"), E_USER_ERROR);
    	exit(-1);
	}
}else{
	//POST引数取得
	if ($_SERVER["REQUEST_METHOD"] == "POST"){
		if ((array_key_exists( "idKey", $_POST)) && (array_key_exists( "accessKey", $_POST))){
			//mod	0:コンテンツユーザ、1:レイヤーユーザ
			$layerID	=	trim($_POST["idKey"]);
			$compareKey	=	trim($_POST["accessKey"]);
		}else{
			//異常アクセス（引数なし）
			trigger_error($o_resource->getValue("G05005M021"), E_USER_ERROR);
	    	exit(-1);
		}
	}
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("userregistreqfix", "POST", $_SERVER["PHP_SELF"]);

if ($layerID != ""){
	if (selectLayerName($layerID, $layerLbl, $addUserSts) == FALSE){
		trigger_error($o_resource->getValue("G05005M017"), E_USER_ERROR);
		$o_db->disconnect();
		exit();
	}
}

// 独自チェックルールの定義
$o_form->registerRule('minlength_valid', 'callback', 'check_minlength_valid');
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');
$o_form->registerRule('compare_valid', 'callback', 'check_reqMailAddress_compare_valid');

// 入力項目のデフォルトをセット
$o_form->setDefaults(
			array(
				"layerName"  => $layerLbl,
				"userID"  => "",
				"password"  => "",
				"confirmPassword"  => "",
				"mailAddress" => ""
			)
);

// 項目セット
$o_form->addElement("static", "layerName",			$o_resource->getValue("G05005L002"));
$o_form->addElement("text", "userID",				$o_resource->getValue("G05005L003"), array("size"=>"40", "maxlength"=>"16", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("password", "password",			$o_resource->getValue("G05005L004"), array("size"=>"40", "maxlength"=>"20", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("password", "confirmPassword",	$o_resource->getValue("G05005L005"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("text", "mailAddress",			$o_resource->getValue("G05005L006"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("hidden", "idKey",				$layerID);
$o_form->addElement("hidden", "accessKey",			$compareKey);

// チェック項目
$o_form->addRule("userID",			$o_resource->getValue("G05005M004"), "required");
$o_form->addRule("userID",			$o_resource->getValue("G05005M005"), "regex", "/^[a-zA-Z0-9]+$/");
$o_form->addRule("userID",			$o_resource->getValue("G05005M005"), "maxlength_valid",	16);
$o_form->addRule("password",		$o_resource->getValue("G05005M006"), "required");
$o_form->addRule("password",		$o_resource->getValue("G05005M007"), "regex", "/^[a-zA-Z0-9]+$/");
$o_form->addRule("password",		$o_resource->getValue("G05005M008"), "minlength_valid",	8);
$o_form->addRule("password",		$o_resource->getValue("G05005M008"), "maxlength_valid",	20);
$o_form->addRule("confirmPassword",	$o_resource->getValue("G05005M009"), "required");
$o_form->addRule("confirmPassword",	$o_resource->getValue("G05005M010"), "regex", "/^[a-zA-Z0-9]+$/");
$o_form->addRule("confirmPassword",	$o_resource->getValue("G05005M011"), "minlength_valid",	8);
$o_form->addRule("confirmPassword",	$o_resource->getValue("G05005M011"), "maxlength_valid",	20);
$o_form->addRule( array("password","confirmPassword"), $o_resource->getValue("G05005M012"), "compare", NULL);
$o_form->addRule("mailAddress",		$o_resource->getValue("G05005M013"), "required");
$o_form->addRule("mailAddress",		$o_resource->getValue("G05005M014"), "email");
$o_form->addRule("mailAddress",		$o_resource->getValue("G05005M015"), "compare_valid", $compareKey);

$errorMessage = "";
$pageFlg = 0;

// 登録ボタン
if (isset($_POST[addButton])){
	// 妥当性チェック
	if ($o_form->validate()) {
//		if (($layerID != "") && ($compareKey != "")){
		if ($compareKey != ""){
			// 入力データチェック
			if (checkUserID($_POST["userID"]) == FALSE){
				if (insertRecord($addUserSts, $layerID, 
							$_POST["userID"], $_POST["password"], $_POST["mailAddress"])){
					$pageFlg = 1;
				}else{
					$errorMessage = $o_resource->getValue("G05005M019");
				}
			}else{
				$errorMessage = $o_resource->getValue("G05005M016");
			}
		}else{
			//異常アクセス（引数なし）
			trigger_error($o_resource->getValue("G05005M021"), E_USER_ERROR);
	    	exit(-1);
		}
    }else{
    	$chkPassword		= &$o_form->getElement("password");
    	$chkConfPassword	= &$o_form->getElement("confirmPassword");
    	$chkPassword->setValue("");
    	$chkConfPassword->setValue("");
    }
}

// ボタンを表示
if ($pageFlg == 0) {

    // 登録画面
    $o_form->addElement("submit",	"addButton",	$o_resource->getValue("G05005L007"),	array("class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
    $o_smarty->assign("header",			$o_resource->getValue("G05005L001"));
	$o_smarty->assign("form",			$o_renderer->toArray());
    $o_smarty->assign("idComment",		$o_resource->getValue("G05005M001"),	array("class"=>"fs12_red"));
    $o_smarty->assign("pwdComment",		$o_resource->getValue("G05005M002"),	array("class"=>"fs12_red"));
    $o_smarty->assign("mailComment",	$o_resource->getValue("G05005M003"),	array("class"=>"fs12_red"));
	$o_smarty->assign("errorMessage",	$errorMessage);

	$tplName = DIRECTORY_NAME . "/userregistreqfix.tpl";
} else {

    // 完了画面
	if ($layerID == ""){
		$message1Lbl	=	htmlspecialchars($_POST["userID"]) . $o_resource->getValue("G05006M001");
	}else{
		$message1Lbl	=	$layerLbl . $o_resource->getValue("G05006M002");
	}
	if ($addUserSts == KAKIKOMAP_ADDATTESTUSER_ON){
	    $message2Lbl	=	$o_resource->getValue("G05006M003");
	}else{
	    $message2Lbl	=	"&nbsp;";
	}

	//ログイン状態生成
	session_start();
	
	$_SESSION[DIRECTORY_NAME.'_userid'] = $_POST["userID"];
	// ユーザ名
	$_SESSION[DIRECTORY_NAME.'_username'] = "";
	// ユーザ種別
	$_SESSION[DIRECTORY_NAME.'_usertype'] = KAKIKOMAP_USERTYPE_NORMAL;
	// テーブル名オブジェクト
	$_SESSION[DIRECTORY_NAME.'_tablename'] = serialize(new KakikoTableName("", DIRECTORY_NAME));
	
		
	$o_smarty->assign("header",		$o_resource->getValue("G05006L001"));
	$o_smarty->assign("message1",	$message1Lbl);
    $o_smarty->assign("message2",	$message2Lbl);
	$o_smarty->assign("backButton",	$o_resource->getValue("G05006L002"));

	$tplName = DIRECTORY_NAME . "/userregistreqfin.tpl";
}

// DB 開放
//$o_db->disconnect();

$o_smarty->display($tplName);

unset($_POST);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要	：レイヤー名称取得
* 処理詳細	：レイヤー名称取得
*
* @引数		：	(I) layerID	- レイヤーID）
*			：	(O) name	- レイヤー名称
*			：	(O) userSts	- ユーザ登録認証区分
*
* @戻値		：	boolean  TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function selectLayerName($layerid, &$name, &$userSts){

	$adminService = new ContentsAdminService(DIRECTORY_NAME);

	$layerRecord = $adminService->getLayerDataFindByLayerID($layerid);

	if (is_null($layerRecord)  == false){
		$name = $layerRecord->getLayerName();
		if ($layerRecord->getAddAttestUser() == KAKIKOMAP_ADDATTESTUSER_ON){;
			$userSts = KAKIKOMAP_ADDATTESTUSER_ON;	//認証なし
		}else{
			$userSts = KAKIKOMAP_ADDATTESTUSER_OFF;	//認証あり
		}
	}else{
		return FALSE;
	}
		
	return TRUE;

}

/**
* 関数概要	：一般ユーザ登録前のデータチェック
* 処理詳細	：ユーザID存在チェック
*
* @引数		：	(I) userID	- 入力ユーザID
*
* @戻値		：	boolean  TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function checkUserID($uesrid){

	$adminService = new ContentsAdminService(DIRECTORY_NAME);

	if ($adminService->checkUserDataByKey($uesrid)){
		return FALSE;
	}else{
		return TRUE;
	}

}

/**
* 関数概要：ユーザ登録処理
* 処理詳細：レイヤーユーザを新規に登録する
*
* @引数： (I) userSts		- ユーザ登録認証区分
* @引数： (I) layerid		- レイヤーID
* @引数： (I) userid		- ユーザID
* @引数： (I) pwd			- パスワード
* @引数： (I) mail			- メールアドレス
*
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function insertRecord($userSts, $layerid, $userid, $pwd, $mail){

	$adminService = new ContentsAdminService(DIRECTORY_NAME);

    // -----------------------------------------------
    // ユーザテーブルへ追加
    // -----------------------------------------------
	$curDate = date('Y/m/d H:i:s');

	//UserTable
	$userData = new UserData();
	$userData ->setUserID($userid);
	$userData ->setUserType(KAKIKOMAP_USERTYPE_NORMAL);		//一般ユーザ
	$userData ->setPassword(md5($pwd));
	$userData ->setMailAddress($mail);
	$userData ->setStatusFlg(KAKIKOMAP_STATUSFLG_ON);
	$userData ->setAddDateTime($curDate);
	$userData ->setUpdateDateTime($curDate);

	if ($layerid != ""){
		//LayerUserTable
		$layerUserData = new LayerUserData();
		$layerUserData ->setUserID($userid);
		$layerUserData ->setLayerID($layerid);
		if ($userSts == KAKIKOMAP_ADDATTESTUSER_ON){					//認証あり
			$layerUserData ->setStatusFlg(KAKIKOMAP_STATUSFLG_WAIT);	//認証待ち
		}else{
			$layerUserData ->setStatusFlg(KAKIKOMAP_STATUSFLG_ON);		//正常
		}
		$layerUserData ->setAddDateTime($curDate);

		if ($adminService->insertUser($userData, $layerUserData) == FALSE){
			trigger_error($o_resource->getValue("G05005M018"), E_USER_ERROR);
			return FALSE;
		}
	}else{
		if ($adminService->insertUser($userData, NULL) == FALSE){
			trigger_error($o_resource->getValue("G05005M019"), E_USER_ERROR);
			return FALSE;
		}
	}

	return TRUE;
}

?>
